/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.client.network;

import java.util.function.Supplier;
import net.daichang.dcmods.utils.helpers.ParticleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record S2CElainaPacket(Vec3 targets_position) {
    public static void encode(S2CElainaPacket packet, FriendlyByteBuf buf) {
        buf.writeDouble(packet.targets_position.f_82479_);
        buf.writeDouble(packet.targets_position.f_82480_);
        buf.writeDouble(packet.targets_position.f_82481_);
    }

    public static S2CElainaPacket decode(FriendlyByteBuf buf) {
        Vec3 targetpos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        return new S2CElainaPacket(targetpos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handle(S2CElainaPacket packet, Supplier<NetworkEvent.Context> network) {
        network.get().enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            ParticleHelper.spawnExaggeratedWaterSplash((Level)level, packet.targets_position, 40);
        });
        network.get().setPacketHandled(true);
    }
}

