/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.client.network;

import java.util.function.Supplier;
import net.daichang.dcmods.utils.helpers.ParticleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public record S2CSonicBoomPacket(Vec3 player_position, Vec3 targets_position) {
    public static void encode(S2CSonicBoomPacket packet, FriendlyByteBuf buf) {
        buf.writeDouble(packet.player_position.f_82479_);
        buf.writeDouble(packet.player_position.f_82480_);
        buf.writeDouble(packet.player_position.f_82481_);
        buf.writeDouble(packet.targets_position.f_82479_);
        buf.writeDouble(packet.targets_position.f_82480_);
        buf.writeDouble(packet.targets_position.f_82481_);
    }

    public static S2CSonicBoomPacket decode(FriendlyByteBuf buf) {
        Vec3 playerpos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        Vec3 targetpos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        return new S2CSonicBoomPacket(playerpos, targetpos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handle(S2CSonicBoomPacket packet, Supplier<NetworkEvent.Context> network) {
        network.get().enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            ParticleHelper.Line(packet.player_position, packet.targets_position, 32).forEach(arg_0 -> S2CSonicBoomPacket.lambda$handle$0((Level)level, arg_0));
        });
        network.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$handle$0(Level level, Vec3 v) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_235902_, v.f_82479_, v.f_82480_ + 1.5, v.f_82481_, 0.0, 0.0, 0.0);
    }
}

