/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.common.entity;

import net.daichang.dcmods.inits.DCEntities;
import net.daichang.dcmods.inits.DCItems;
import net.daichang.dcmods.utils.Utils;
import net.daichang.dcmods.utils.helpers.EntityHelper;
import net.daichang.dcmods.utils.helpers.ExplodeHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class DCSuperArrow
extends AbstractArrow {
    public DCSuperArrow(EntityType<? extends AbstractArrow> p_36721_, Level p_36722_) {
        super(p_36721_, p_36722_);
    }

    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)DCItems.DC_ARROW.get());
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175828_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
    }

    protected void m_5790_(@NotNull EntityHitResult p_36757_) {
        super.m_5790_(p_36757_);
        Entity entity = p_36757_.m_82443_();
        if (!this.getPersistentData().m_128441_("shootByDC")) {
            this.killEntity(entity);
        } else {
            this.shootByDC(entity);
        }
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        CompoundTag tag = this.getPersistentData();
        super.m_8060_(blockHitResult);
        Level level = this.f_19853_;
        int x = blockHitResult.m_82425_().m_123341_();
        int y = blockHitResult.m_82425_().m_123342_();
        int z = blockHitResult.m_82425_().m_123343_();
        if (!tag.m_128441_("shootByDC")) {
            if (!tag.m_128441_("isDCArrowR")) {
                EntityHelper.spawnEntity(this.f_19853_, (Entity)this, (EntityType)DCEntities.DC_SUPER_ARROW.get());
                ExplodeHelper.boom(level, x, y, z, (Entity)this, 5.0f);
            }
            for (Entity entity : EntityHelper.getEntity(level, x, y, z, 5.0)) {
                this.killEntity(entity);
            }
        } else {
            for (Entity entity : EntityHelper.getEntity(level, x, y, z, 5.0)) {
                this.shootByDC(entity);
            }
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    void killEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!this.getPersistentData().m_128441_("shootByDC")) {
                living.m_6469_(living.m_269291_().m_269425_(), 3094.0f);
            }
        }
    }

    void shootByDC(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Utils.attackEntity(living, living);
        }
    }
}

