/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.common.item.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.daichang.dcmods.client.font.DCItemFont;
import net.daichang.dcmods.common.item.tools.ISwordItem;
import net.daichang.dcmods.inits.DCAttributes;
import net.daichang.dcmods.utils.Utils;
import net.daichang.dcmods.utils.helpers.EffectHelper;
import net.daichang.dcmods.utils.helpers.EntityHelper;
import net.daichang.dcmods.utils.helpers.MathHelper;
import net.daichang.dcmods.utils.lists.items.CanSwordBlockItem;
import net.daichang.dcmods.utils.lists.items.SuperItemList;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DCSuperSwordItem
extends ISwordItem {
    public Multimap<Attribute, AttributeModifier> mainHandModifiers;
    public Multimap<Attribute, AttributeModifier> offHandModifiers;

    public DCSuperSwordItem(Tier p_43269_, int pAttackDamageModifier, float pAttackSpeedModifier, float super_damage, Item.Properties p_43272_) {
        super(p_43269_, pAttackDamageModifier, pAttackSpeedModifier, p_43272_);
        ImmutableMultimap.Builder mainHand = ImmutableMultimap.builder();
        ImmutableMultimap.Builder offHand = ImmutableMultimap.builder();
        mainHand.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.f_43266_, AttributeModifier.Operation.ADDITION));
        mainHand.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)pAttackSpeedModifier, AttributeModifier.Operation.ADDITION));
        mainHand.put((Object)((Attribute)DCAttributes.DC_SUPER_DAMAGE.get()), (Object)new AttributeModifier(UUID.randomUUID(), "Item modifier", (double)super_damage, AttributeModifier.Operation.ADDITION));
        mainHand.put((Object)((Attribute)DCAttributes.DC_SUPER_DAMAGE.get()), (Object)new AttributeModifier(UUID.randomUUID(), "Item modifier", 0.52, AttributeModifier.Operation.MULTIPLY_TOTAL));
        mainHand.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(UUID.randomUUID(), "Item modifier", 7.0, AttributeModifier.Operation.ADDITION));
        this.mainHandModifiers = mainHand.build();
        offHand.put((Object)((Attribute)DCAttributes.DC_SUPER_DAMAGE.get()), (Object)new AttributeModifier(UUID.randomUUID(), "Item modifier", 8.7, AttributeModifier.Operation.ADDITION));
        offHand.put((Object)((Attribute)DCAttributes.DC_DEFENSE.get()), (Object)new AttributeModifier(UUID.randomUUID(), "Item modifier", 3.2, AttributeModifier.Operation.ADDITION));
        mainHand.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.randomUUID(), "Weapon modifier", 0.5, AttributeModifier.Operation.ADDITION));
        this.offHandModifiers = offHand.build();
        SuperItemList.addItem((Item)this);
        CanSwordBlockItem.addItem((Item)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        CompoundTag comTag = stack.m_41783_();
        if (comTag != null && !comTag.m_128441_("dc_attking")) {
            comTag.m_128405_("dc_attking", 0);
        }
        return super.getAttributeModifiers(equipmentSlot, stack);
    }

    @Override
    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        if (pEquipmentSlot == EquipmentSlot.MAINHAND) {
            return this.mainHandModifiers;
        }
        if (pEquipmentSlot == EquipmentSlot.OFFHAND) {
            return this.offHandModifiers;
        }
        return super.m_7167_(pEquipmentSlot);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public Font getFont(ItemStack stack, IClientItemExtensions.FontContext context) {
                return DCItemFont.getFont();
            }
        });
        super.initializeClient(consumer);
    }

    public void m_5929_(Level p_41428_, LivingEntity living, ItemStack p_41430_, int p_41431_) {
        living.m_7292_(EffectHelper.addEffect(MobEffects.f_19605_, 20, true));
        living.m_7292_(EffectHelper.addEffect(MobEffects.f_19606_, 20, 3, true));
        living.m_5634_(5.5f);
        EntityHelper.forceHeal(living, 5.5f);
        living.f_19802_ = 1;
        super.m_5929_(p_41428_, living, p_41430_, p_41431_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> list, TooltipFlag p_41424_) {
        CompoundTag comTag = stack.m_41783_();
        list.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"tooltip.dc_mods.hurts").getString() + comTag.m_128451_("dc_attking"))));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.tips"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.tips_1"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.tips_2"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.attacking_entity"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.sword_boxing"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.tip_3"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.kill_entity"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.minecraft"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.drop_loot"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.health_get"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.kill"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.attacking_entity_cooldown"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.bleed"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.render_death_1"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.render_death_2"));
        list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.setting_max_health"));
        if (comTag.m_128451_("dc_attking") >= 10000) {
            list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.is_strong"));
        } else {
            list.add((Component)Component.m_237115_((String)"tooltip.dc_mods.strong"));
        }
        super.m_7373_(stack, p_41422_, list, p_41424_);
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.m_41783_().m_128451_("dc_attking") < 10000 || super.isDamaged(stack);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, @NotNull LivingEntity living) {
        if (living instanceof Player) {
            Player player = (Player)living;
            Utils.attackEntity(stack, target, player);
        }
        return super.m_7579_(stack, target, living);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (player.f_19853_ instanceof ServerLevel) {
                this.m_7579_(stack, living, (LivingEntity)player);
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public int m_142158_(ItemStack p_150900_) {
        return 13;
    }

    public int m_142159_(ItemStack p_150901_) {
        return new Random(Util.m_137550_()).nextInt();
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41783_().m_128451_("dc_attking") >= 10000;
    }

    public boolean m_5812_(ItemStack pStack) {
        return true;
    }

    public boolean m_41475_() {
        return true;
    }

    @SubscribeEvent
    public static void onHitEntity(LivingAttackEvent event) {
        Player player;
        LivingEntity target = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player && (entity = (player = (Player)entity).m_21205_().m_41720_()) instanceof DCSuperSwordItem) {
            DCSuperSwordItem item = (DCSuperSwordItem)entity;
            ItemStack stack = player.m_21205_();
            item.m_7579_(stack, target, (LivingEntity)player);
            target.m_6469_(target.m_269291_().m_269425_(), 21.0f + (float)(MathHelper.getRandomDouble(1.0, 6.0) * 4.0 - 3.0) + 2.0f);
        }
    }
}

