/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import net.daichang.dcmods.client.font.DCEntityFont;
import net.daichang.dcmods.commands.SoftGetHealthCommand;
import net.daichang.dcmods.common.blocks.RedSpiderLily;
import net.daichang.dcmods.common.entity.DCLoveElaina;
import net.daichang.dcmods.inits.DCAttributes;
import net.daichang.dcmods.inits.DCDamageType;
import net.daichang.dcmods.inits.DCEntities;
import net.daichang.dcmods.inits.DCItems;
import net.daichang.dcmods.utils.AnviUtil;
import net.daichang.dcmods.utils.FontUtil;
import net.daichang.dcmods.utils.ModUtil;
import net.daichang.dcmods.utils.Utils;
import net.daichang.dcmods.utils.helpers.DataHelper;
import net.daichang.dcmods.utils.helpers.EntityHelper;
import net.daichang.dcmods.utils.helpers.FileHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="dc_m", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DCForgeEventHandler {
    public static CopyOnWriteArrayList<LivingEntity> livingEntities = new CopyOnWriteArrayList();
    private static final Map<DCLoveElaina, Integer> prevBarWidthMap = new HashMap<DCLoveElaina, Integer>();

    @SubscribeEvent
    public static void hurtEvent(@NotNull LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        DamageSource damageSource = event.getSource();
        Entity entity = damageSource.m_7639_();
        if (Utils.isBlocking(living)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void leftClickEntity(@NotNull LivingAttackEvent event) {
        LivingEntity living1;
        LivingEntity living = event.getEntity();
        DamageSource damageSource = event.getSource();
        Entity entity = damageSource.m_7639_();
        if (damageSource.m_276093_(DCDamageType.SUPER_DAMAGE) || entity instanceof LivingEntity && (living1 = (LivingEntity)entity).m_21205_().m_150930_((Item)DCItems.SUPER_WOOD_SWORD.get())) {
            event.setCanceled(false);
            float normalDamage = 0.0f;
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                if (attacker.f_20943_.m_22171_(Attributes.f_22281_)) {
                    normalDamage += (float)attacker.m_21051_(Attributes.f_22281_).m_22135_();
                }
                if (attacker.f_20943_.m_22171_((Attribute)DCAttributes.DC_SUPER_DAMAGE.get())) {
                    normalDamage += (float)attacker.m_21051_((Attribute)DCAttributes.DC_SUPER_DAMAGE.get()).m_22135_();
                }
            }
            float removedHealth = event.getAmount() + normalDamage;
            float newHealth = living.m_21223_() - removedHealth;
            EntityHelper.forceSetHealth(living, newHealth);
            EntityHelper.noHurtDuration(living);
            living.m_20088_().m_135381_(LivingEntity.f_20961_, (Object)Float.valueOf(newHealth));
            living.m_21153_(newHealth);
            try {
                living.m_6668_(damageSource);
            }
            catch (Exception exception) {
                // empty catch block
            }
            living.m_6677_(damageSource);
            DataHelper.addHealthDelta(living, -removedHealth);
        }
        if (Utils.isBlocking(living)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void leftClickBlock(PlayerInteractEvent.LeftClickBlock e) {
        Player player = e.getEntity();
        Level level = e.getLevel();
        BlockPos pos = e.getPos();
        if (player.m_21205_().m_41720_() == DCItems.DESTROY_BLOCK.get()) {
            ItemEntity item = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)level.m_8055_(pos).m_60734_()));
            level.m_7967_((Entity)item);
            item.m_32010_(0);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 0);
        }
    }

    @SubscribeEvent
    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock e) {
        BlockPos pos;
        Player player = e.getEntity();
        Level level = e.getLevel();
        BlockState blockState = level.m_8055_(pos = e.getPos());
        Block block = blockState.m_60734_();
        if (block instanceof RedSpiderLily && player.m_150109_().m_18947_((Item)DCItems.SUPER_WOOD_INGOT.get()) > 9 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DCLoveElaina dcWitherBoss = new DCLoveElaina((EntityType<DCLoveElaina>)((EntityType)DCEntities.DC_WITHER.get()), (Level)serverLevel);
            dcWitherBoss.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            dcWitherBoss.m_6710_((LivingEntity)player);
            serverLevel.m_7967_((Entity)dcWitherBoss);
            level.m_46961_(pos, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderGUI(RenderGuiEvent.Pre event) {
        GuiGraphics graphics = event.getGuiGraphics();
        MultiBufferSource.BufferSource source = graphics.m_280091_();
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (EntityHelper.hasElaina(Minecraft.m_91087_().f_91074_.m_9236_())) {
            int w = event.getWindow().m_85445_();
            int h = event.getWindow().m_85446_();
            int posX = w / 2;
            int posY = h / 2;
            int offset = 0;
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Iterator<LivingEntity> iterator = livingEntities.iterator();
            while (iterator.hasNext()) {
                Iterator<LivingEntity> iterator2 = iterator;
                synchronized (iterator2) {
                    LivingEntity entity = iterator.next();
                    if (entity == null) {
                        continue;
                    }
                    if (entity instanceof DCLoveElaina) {
                        DCLoveElaina elaina = (DCLoveElaina)entity;
                        float maxHealth = elaina.m_21233_();
                        float health = elaina.m_21223_();
                        int barWidth = (int)(health / maxHealth * 190.0f);
                        int prevBarWidth = prevBarWidthMap.getOrDefault((Object)elaina, barWidth);
                        float transitionSpeed = 0.1f;
                        int interpolatedBarWidth = (int)((1.0f - transitionSpeed * event.getPartialTick()) * (float)prevBarWidth + transitionSpeed * event.getPartialTick() * (float)barWidth);
                        prevBarWidthMap.put(elaina, barWidth);
                        String displayName = elaina.m_5446_().getString();
                        String displayHealth = String.format("%.1f/%.1f", Float.valueOf(health), Float.valueOf(maxHealth));
                        int displayNameWidth = DCEntityFont.getFont().m_92895_(displayName);
                        int healthWidth = DCEntityFont.getFont().m_92895_(displayHealth);
                        graphics.m_280163_(new ResourceLocation("dc_m:textures/entities/health_bar_1.png"), posX - 97, posY - 116 + offset, 0.0f, 0.0f, 256, 256, 256, 256);
                        graphics.m_280163_(new ResourceLocation("dc_m:textures/entities/health_bar_3.png"), posX - 97, posY - 148 + offset, 0.0f, 0.0f, interpolatedBarWidth, 256, 256, 256);
                        graphics.m_280163_(new ResourceLocation("dc_m:textures/entities/health_bar_2.png"), posX - 97, posY - 148 + offset, 0.0f, 0.0f, barWidth, 256, 256, 256);
                        source.m_6299_(RenderType.m_173239_());
                        graphics.m_280614_((Font)DCEntityFont.getFont(), (Component)Component.m_237113_((String)displayName), posX - displayNameWidth / 2, posY + -92 + offset, -26368, false);
                        graphics.m_280614_((Font)DCEntityFont.getFont(), (Component)Component.m_237113_((String)displayHealth), posX - healthWidth / 2, posY + -82 + offset, -26368, false);
                        offset += 30;
                    }
                }
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderTooltipEvent(RenderTooltipEvent.Color event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        float index = 0.5f;
        float hueOffset = (float)Util.m_137550_() / 16000.0f;
        float hue = hueOffset + index * index;
        float saturation = 1.0f;
        float brightness = 1.0f;
        int c = Color.HSBtoRGB(((hue * 720.0f + index) % 720.0f >= 360.0f ? 720.0f - (hue * 720.0f + index) % 720.0f : (hue * 720.0f + index) % 720.0f) / 256.0f, saturation, brightness);
        if (Utils.isSuperTool(item)) {
            event.setBorderStart(c);
            event.setBorderEnd(c);
        } else if (Utils.isCreativeItem(item)) {
            event.setBorderStart(Color.CYAN.getRGB());
            event.setBorderEnd(Color.CYAN.getRGB());
        } else if (Utils.isNormalTool(item)) {
            event.setBorderStart(Color.WHITE.getRGB());
            event.setBorderEnd(Color.WHITE.getRGB());
        } else if (item.equals(DCItems.DC_ENTITY_REMOVE.get())) {
            event.setBorderStart(new Random().nextInt());
            event.setBorderEnd(new Random().nextInt());
        } else if (Utils.isBlockItem(item)) {
            event.setBorderStart(Color.BLUE.getRGB());
            event.setBorderStart(Color.BLUE.getRGB());
        } else if (ModUtil.isDCLoad() && FontUtil.isCanRenderFont(stack)) {
            event.setBorderStart(c);
            event.setBorderEnd(c);
        }
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dc_mods").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"super_set_health").executes(cs -> {
            Entity entity = ((CommandSourceStack)cs.getSource()).m_81373_();
            SoftGetHealthCommand.killed(entity);
            return 2;
        })).then(Commands.m_82129_((String)"uuid", (ArgumentType)EntityArgument.m_91449_()).executes(cs -> {
            for (Entity entity : EntityArgument.m_91461_((CommandContext)cs, (String)"entity")) {
                SoftGetHealthCommand.killed(entity);
            }
            return 2;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add_def_entity").executes(cs -> {
            Entity entity = ((CommandSourceStack)cs.getSource()).m_81373_();
            FileHelper.defaultWriteYouItem(entity);
            return 2;
        })).then(Commands.m_82129_((String)"uuid", (ArgumentType)EntityArgument.m_91449_()).executes(cs -> {
            for (Entity entity : EntityArgument.m_91461_((CommandContext)cs, (String)"entity")) {
                FileHelper.defaultWriteYouItem(entity);
            }
            return 2;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove_def_player").executes(cs -> {
            Entity entity = ((CommandSourceStack)cs.getSource()).m_81373_();
            FileHelper.removeDefaultItem(entity);
            return 2;
        })).then(Commands.m_82129_((String)"uuid", (ArgumentType)EntityArgument.m_91449_()).executes(cs -> {
            for (Entity entity : EntityArgument.m_91461_((CommandContext)cs, (String)"entity")) {
                FileHelper.removeDefaultItem(entity);
            }
            return 2;
        }))));
    }

    @SubscribeEvent
    public static void sendMessageOfPlayer(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        player.m_5661_((Component)Component.m_237115_((String)"chat.dc_mods.world_loading").m_130940_(ChatFormatting.AQUA), false);
    }

    @SubscribeEvent
    public static void anviUpdate(AnvilUpdateEvent event) {
        AnviUtil.addAnviUpdate(event, Items.f_42416_, Items.f_42415_, (Item)DCItems.SUPER_WOOD_INGOT.get());
    }

    @SubscribeEvent
    public static void livingDeathEvent(LivingDeathEvent event) {
        boolean isHasItem;
        LivingEntity living = event.getEntity();
        DamageSource source = event.getSource();
        Item mainHand = living.m_21205_().m_41720_();
        Item offHand = living.m_21206_().m_41720_();
        boolean bl = isHasItem = mainHand == DCItems.WOOD_TOTEM.get() || offHand == DCItems.WOOD_TOTEM.get();
        if (isHasItem) {
            EntityHelper.forceHeal(living, 1.0f);
            living.m_5634_(1.0f);
            event.setCanceled(true);
            living.m_216990_(SoundEvents.f_12513_);
            if (living instanceof Player) {
                Player player = (Player)living;
                player.m_7583_();
                Minecraft.m_91087_().f_91063_.m_109113_(new ItemStack((ItemLike)DCItems.WOOD_TOTEM.get()));
            }
        }
    }
}

