/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.mixins;

import net.daichang.dcmods.inits.DCAttributes;
import net.daichang.dcmods.inits.DCEffects;
import net.daichang.dcmods.utils.Utils;
import net.daichang.dcmods.utils.asm.MethodUtil;
import net.daichang.dcmods.utils.helpers.DataHelper;
import net.daichang.dcmods.utils.helpers.EffectHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    @Unique
    private final LivingEntity dc_mod$living = (LivingEntity)this;

    @Shadow
    public abstract float m_21233_();

    public MixinLivingEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(method={"heal"}, at={@At(value="HEAD")}, cancellable=true)
    private void heal(float p_21116_, CallbackInfo ci) {
        if (EffectHelper.hasEffect(this.dc_mod$living, (MobEffect)DCEffects.Bloodshed.get()) || this.dc_mod$living.getPersistentData().m_128441_("toDCMark")) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        CompoundTag tag = this.dc_mod$living.getPersistentData();
        if (tag.m_128441_("dc_death")) {
            tag.m_128405_("dc_death", tag.m_128451_("dc_death") + 1);
            if (tag.m_128451_("dc_death") > 20) {
                Utils.removeEntity((Entity)this.dc_mod$living);
            }
            ++this.dc_mod$living.f_20919_;
        }
    }

    @Inject(method={"isDeadOrDying"}, at={@At(value="RETURN")}, cancellable=true)
    private void isDeadOrDying(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)MethodUtil.isDeadOrDying(this.dc_mod$living, (Boolean)cir.getReturnValue()));
    }

    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")}, cancellable=true)
    private static void createLivingAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        cir.setReturnValue((Object)((AttributeSupplier.Builder)cir.getReturnValue()).m_22268_((Attribute)DCAttributes.DC_SUPER_DAMAGE.get(), 0.0).m_22268_((Attribute)DCAttributes.DC_DEFENSE.get(), 0.0));
    }

    @Inject(method={"getHealth"}, at={@At(value="RETURN")}, cancellable=true)
    private void getHealth(CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(MethodUtil.getHealth(this.dc_mod$living, ((Float)cir.getReturnValue()).floatValue())));
    }

    @Inject(method={"isAlive"}, at={@At(value="RETURN")}, cancellable=true)
    private void isAlive(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)MethodUtil.isAlive((Entity)this.dc_mod$living, (Boolean)cir.getReturnValue()));
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void clinit(CallbackInfo ci) {
        DataHelper.DC_GET_HEALTH_DATA = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        DataHelper.setHealthDelta(this.dc_mod$living, tag.m_128451_(DataHelper.DC_GET_HEALTH));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128350_(DataHelper.DC_GET_HEALTH, DataHelper.getHealthDelta(this.dc_mod$living));
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="HEAD")})
    private void defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DataHelper.DC_GET_HEALTH_DATA, (Object)Float.valueOf(0.0f));
    }
}

