/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.utils;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.ModuleLayerHandler;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public final class HelperLib {
    public static final Unsafe UNSAFE = HelperLib.getUnsafe();
    private static final MethodHandles.Lookup lookup = HelperLib.getFieldValue(MethodHandles.Lookup.class, "IMPL_LOOKUP", MethodHandles.Lookup.class);
    private static final Object internalUNSAFE = HelperLib.getInternalUNSAFE();
    private static MethodHandle objectFieldOffsetInternal;

    private static Unsafe getUnsafe() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getInternalUNSAFE() {
        try {
            Class<?> clazz = lookup.findClass("jdk.internal.misc.Unsafe");
            return lookup.findStatic(clazz, "getUnsafe", MethodType.methodType(clazz)).invoke();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T getFieldValue(Field f, Object target, Class<T> clazz) {
        try {
            long offset;
            if (Modifier.isStatic(f.getModifiers())) {
                target = UNSAFE.staticFieldBase(f);
                offset = UNSAFE.staticFieldOffset(f);
            } else {
                offset = HelperLib.objectFieldOffset(f);
            }
            return (T)UNSAFE.getObject(target, offset);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long objectFieldOffset(Field f) {
        try {
            return UNSAFE.objectFieldOffset(f);
        }
        catch (Throwable e) {
            try {
                return objectFieldOffsetInternal.invoke(f);
            }
            catch (Throwable t1) {
                t1.printStackTrace();
                return 0L;
            }
        }
    }

    public static <T> T getFieldValue(Object target, String fieldName, Class<T> clazz) {
        try {
            return HelperLib.getFieldValue(target.getClass().getDeclaredField(fieldName), target, clazz);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T getFieldValue(Class<?> target, String fieldName, Class<T> clazz) {
        try {
            return HelperLib.getFieldValue(target.getDeclaredField(fieldName), null, clazz);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setFieldValue(Object target, String fieldName, Object value) {
        try {
            HelperLib.setFieldValue(target.getClass().getDeclaredField(fieldName), target, value);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void setFieldValue(Field f, Object target, Object value) {
        try {
            long offset;
            if (Modifier.isStatic(f.getModifiers())) {
                target = UNSAFE.staticFieldBase(f);
                offset = UNSAFE.staticFieldOffset(f);
            } else {
                offset = HelperLib.objectFieldOffset(f);
            }
            UNSAFE.putObject(target, offset, value);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static String getJarPath(Class<?> clazz) {
        String file = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (!file.isEmpty()) {
            if (file.startsWith("union:")) {
                file = file.substring(6);
            }
            if (file.startsWith("/")) {
                file = file.substring(1);
            }
            file = file.substring(0, file.lastIndexOf(".jar") + 4);
            file = file.replaceAll("/", "\\\\");
        }
        return URLDecoder.decode(file, StandardCharsets.UTF_8);
    }

    public static void coexistenceCoreAndMod() {
        List found = HelperLib.getFieldValue(ModDirTransformerDiscoverer.class, "found", List.class);
        found.removeIf(namedPath -> HelperLib.getJarPath(HelperLib.class).equals(namedPath.paths()[0].toString()));
        HelperLib.getFieldValue(HelperLib.getFieldValue(Launcher.INSTANCE, "moduleLayerHandler", ModuleLayerHandler.class), "completedLayers", EnumMap.class).values().forEach(layerInfo -> {
            ModuleLayer layer = HelperLib.getFieldValue(layerInfo, "layer", ModuleLayer.class);
            layer.modules().forEach(module -> {
                if (module.getName().equals(HelperLib.class.getModule().getName())) {
                    HashSet modules = new HashSet(HelperLib.getFieldValue(layer.configuration(), "modules", Set.class));
                    HashMap nameToModule = new HashMap(HelperLib.getFieldValue(layer.configuration(), "nameToModule", Map.class));
                    modules.remove(nameToModule.remove(HelperLib.class.getModule().getName()));
                    HelperLib.setFieldValue(layer.configuration(), "modules", modules);
                    HelperLib.setFieldValue(layer.configuration(), "nameToModule", nameToModule);
                }
            });
        });
    }

    public static boolean checkClass(Object o) {
        return o.getClass().getName().startsWith("net.minecraft.");
    }

    public static void copyProperties(Class<?> clazz, Object source, Object target) {
        try {
            AccessibleObject[] fields = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                if (Modifier.isStatic(((Field)field).getModifiers())) continue;
                ((Field)field).set(target, ((Field)field).get(source));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void replaceClass(Object object, Class<?> targetClass) {
        if (object == null) {
            throw new NullPointerException("object==null");
        }
        if (targetClass == null) {
            throw new NullPointerException("targetClass==null");
        }
        try {
            int klass_ptr = UnsafeAccess.UNSAFE.getIntVolatile(UnsafeAccess.UNSAFE.allocateInstance(targetClass), 8L);
            UnsafeAccess.UNSAFE.putIntVolatile(object, 8L, klass_ptr);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T, E> void fieldSetField(T instance, Class<? super T> cls, String fieldName, E val, String srg) {
        String[] remap = new String[]{srg, fieldName};
        String name = SharedConstants.f_136183_ ? remap[1] : remap[0];
        try {
            ObfuscationReflectionHelper.setPrivateValue(cls, instance, val, (String)name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <E> Object getField(E instance, Class<? super E> cls, String fieldName, String srg) {
        String[] remap = new String[]{srg, fieldName};
        String name = SharedConstants.f_136183_ ? remap[1] : remap[0];
        return ObfuscationReflectionHelper.getPrivateValue(cls, instance, (String)name);
    }

    public static Object fieldMethod(Object instance, Class<?> cls, @NotNull String fieldName, Object[] objects, String srg, Class<?> ... classes) {
        String name = SharedConstants.f_136183_ ? fieldName : srg;
        try {
            return ObfuscationReflectionHelper.findMethod(cls, (String)name, (Class[])classes).invoke(instance, objects);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class<?> internalUNSAFEClass = lookup.findClass("jdk.internal.misc.Unsafe");
            objectFieldOffsetInternal = lookup.findVirtual(internalUNSAFEClass, "objectFieldOffset", MethodType.methodType(Long.TYPE, Field.class)).bindTo(internalUNSAFE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

