/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.utils;

public class ImageMath {
    public static final float PI = (float)Math.PI;

    public static float step(float a, float x) {
        return x < a ? 0.0f : 1.0f;
    }

    public static float clamp(float x, float a, float b) {
        return x < a ? a : Math.min(x, b);
    }

    public static int clamp(int x, int a, int b) {
        return x < a ? a : Math.min(x, b);
    }

    public static double mod(double a, double b) {
        int n;
        if ((a -= (double)(n = (int)(a / b)) * b) < 0.0) {
            return a + b;
        }
        return a;
    }

    public static float mod(float a, float b) {
        int n;
        if ((a -= (float)(n = (int)(a / b)) * b) < 0.0f) {
            return a + b;
        }
        return a;
    }

    public static int mod(int a, int b) {
        int n;
        if ((a -= (n = a / b) * b) < 0) {
            return a + b;
        }
        return a;
    }

    public static void premultiply(int[] p, int offset, int length) {
        length += offset;
        for (int i = offset; i < length; ++i) {
            int rgb = p[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            float f = (float)a * 0.003921569f;
            r = (int)((float)r * f);
            g = (int)((float)g * f);
            b = (int)((float)b * f);
            p[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }

    public static void unpremultiply(int[] p, int offset, int length) {
        length += offset;
        for (int i = offset; i < length; ++i) {
            int rgb = p[i];
            int a = rgb >> 24 & 0xFF;
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            if (a == 0 || a == 255) continue;
            float f = 255.0f / (float)a;
            r = (int)((float)r * f);
            g = (int)((float)g * f);
            b = (int)((float)b * f);
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
            p[i] = a << 24 | r << 16 | g << 8 | b;
        }
    }
}

