/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.daichang.dcmods.inits.DCAttributes;
import net.daichang.dcmods.inits.DCBlockItems;
import net.daichang.dcmods.inits.DCItems;
import net.daichang.dcmods.inits.DCSounds;
import net.daichang.dcmods.utils.HelperLib;
import net.daichang.dcmods.utils.Int2ObjectMapUtil;
import net.daichang.dcmods.utils.helpers.DataHelper;
import net.daichang.dcmods.utils.helpers.EntityHelper;
import net.daichang.dcmods.utils.helpers.MathHelper;
import net.daichang.dcmods.utils.lists.DeathList;
import net.daichang.dcmods.utils.lists.items.CanSwordBlockItem;
import net.daichang.dcmods.utils.lists.items.CreativeItemList;
import net.daichang.dcmods.utils.lists.items.SuperItemList;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;

public class Utils {
    public static boolean isBlocking(@NotNull LivingEntity target) {
        return CanSwordBlockItem.getItem(target.m_21211_().m_41720_()) && target.m_6117_() && target.m_21211_().m_41720_().m_6164_(target.m_21211_()) == Utils.getUseAnim();
    }

    public static void removeEntity(Entity target) {
        Level level = target.f_19853_;
        Entity.RemovalReason reason = Entity.RemovalReason.KILLED;
        target.m_142687_(reason);
        target.m_142467_(reason);
        target.m_142036_();
        target.onRemovedFromWorld();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.f_143243_.m_156912_(target);
            serverLevel.f_143244_.f_157494_.m_156822_((EntityAccess)target);
        }
    }

    public static void dataHealthSet(Entity target) {
        DamageSource damageSource = new DamageSource((Holder)target.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_286979_), target);
        Utils.Override_DATA_HEALTH_ID(target, 0.0f);
        target.m_20124_(Pose.DYING);
        DeathList.addDeath(target);
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.m_21153_(0.0f);
            Utils.Override_DATA_HEALTH_ID(living, 0.0f);
            living.m_20124_(Pose.DYING);
            living.m_6667_(damageSource);
            living.m_6074_();
            target.getPersistentData().m_128405_("dc_death", 0);
        }
    }

    public static void killLevelEntity(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            Iterables.unmodifiableIterable((Iterable)level.m_8583_()).forEach(Utils::superKillEntity);
        }
    }

    public static void backtrack(Class<?> caller) {
        try {
            Field[] fields;
            for (Field field : fields = caller.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) && field.getType().getTypeName().equals("boolean")) {
                    field.setAccessible(true);
                    field.set(null, false);
                    System.out.println("[DC MODS]\u5df2\u56de\u6eafBoolean\u5b57\u6bb5");
                    continue;
                }
                if (Modifier.isStatic(field.getModifiers()) && field.getType().getTypeName().equals("int")) {
                    field.setAccessible(true);
                    field.set(null, 0);
                    System.out.println("[DC MODS]\u5df2\u56de\u6eafInt\u5b57\u6bb5");
                    continue;
                }
                if (Modifier.isStatic(field.getModifiers()) && field.getType().getTypeName().equals("float")) {
                    field.setAccessible(true);
                    field.set(null, Float.valueOf(0.0f));
                    System.out.println("[DC MODS]\u5df2\u56de\u6eafFloat\u5b57\u6bb5");
                    continue;
                }
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().getTypeName().equals("double")) continue;
                field.setAccessible(true);
                field.set(null, 0.0);
                System.out.println("[DC MODS]\u5df2\u56de\u6eafDouble\u5b57\u6bb5");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void superKillEntity(Entity target) {
        if (target != null && !(target instanceof Player)) {
            ClientLevel clientLevel;
            Entity clientEntity;
            Entity.RemovalReason reason = Entity.RemovalReason.KILLED;
            MinecraftForge.EVENT_BUS.unregister((Object)target);
            Utils.Override_DATA_HEALTH_ID(target, 0.0f);
            HelperLib.fieldSetField(target, Entity.class, "removalReason", reason, "f_146795_");
            Utils.backtrack(target.getClass());
            target.m_20343_(Double.NaN, Double.NaN, Double.NaN);
            target.m_6034_(Double.NaN, Double.NaN, Double.NaN);
            target.m_20197_().forEach(Entity::m_8127_);
            target.f_146795_ = reason;
            target.m_142036_();
            target.onRemovedFromWorld();
            target.m_20011_(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
            target.m_142687_(reason);
            target.m_142467_(reason);
            target.isAddedToWorld = false;
            target.canUpdate(false);
            target.m_6034_(Double.NaN, Double.NaN, Double.NaN);
            target.m_213651_(DynamicGameEventListener::m_223634_);
            target.canUpdate = false;
            target.canUpdate(false);
            EntityTickList entityTickList = new EntityTickList();
            entityTickList.m_156912_(target);
            entityTickList.f_156903_.clear();
            entityTickList.f_156904_.clear();
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                living.m_6274_().m_276084_();
                for (String s : living.m_19880_()) {
                    living.m_20137_(s);
                }
                living.invalidateCaps();
                Utils.Override_DATA_HEALTH_ID(living, 0.0f);
                living.f_20919_ = 20;
                living.f_20916_ = 20;
            }
            Level level = target.m_9236_();
            level.m_183599_(target);
            HashSet newKnownUuids = Sets.newHashSet();
            EntityLookup newAccess = new EntityLookup();
            newAccess.m_156822_((EntityAccess)target);
            ((EntityInLevelCallback)HelperLib.getField(target, Entity.class, "levelCallback", "f_146801_")).m_142472_(Entity.RemovalReason.KILLED);
            if (level instanceof ServerLevel) {
                ServerLevel surface = (ServerLevel)level;
                newKnownUuids.addAll(surface.f_143244_.f_157491_);
                newKnownUuids.remove(target.m_20148_());
                EntitySectionStorage entitySectionStorage = surface.f_143244_.f_157495_;
                surface.f_143244_.f_157494_ = newAccess;
                surface.f_143244_.f_157494_.m_156822_((EntityAccess)target);
                surface.f_143244_.f_157496_ = new LevelEntityGetterAdapter(newAccess, entitySectionStorage);
                surface.f_143244_.f_157491_ = newKnownUuids;
                surface.f_143244_.f_157491_.remove(target);
                surface.f_143244_.f_157493_ = new EntityPersistentStorage<Entity>(){

                    @NotNull
                    public CompletableFuture<ChunkEntities<Entity>> m_141930_(@NotNull ChunkPos chunkPos) {
                        return null;
                    }

                    public void m_141971_(@NotNull ChunkEntities<Entity> chunkEntities) {
                    }

                    public void m_182219_(boolean b) {
                    }
                };
                surface.f_143243_ = entityTickList;
                surface.f_143243_.m_156912_(target);
                surface.f_143243_.f_156903_.clear();
                surface.f_143243_.f_156904_.clear();
                ObjectOpenHashSet objectOpenHashSet = new ObjectOpenHashSet();
                objectOpenHashSet.remove((Object)target);
                surface.f_143246_ = objectOpenHashSet;
                surface.f_143246_.remove(target);
                surface.f_143244_.f_157492_.m_141986_((Object)target);
                surface.f_143244_.f_157492_.m_141983_((Object)target);
                final MinecraftServer server = surface.m_7654_();
                RegistryAccess.ImmutableRegistryAccess access = (RegistryAccess.ImmutableRegistryAccess)server.m_247573_().m_247579_();
                Registry registry = (Registry)access.f_206223_.get(Registries.f_256862_);
                final ServerLevel secludedLevel = new ServerLevel(server, (Executor)Util.m_183991_(), server.f_129744_, (ServerLevelData)surface.m_6106_(), surface.m_46472_(), (LevelStem)registry.m_6246_(LevelStem.f_63971_), server.f_129756_.m_9620_(11), surface.m_46659_(), surface.m_7062_().f_47863_, Collections.emptyList(), true, surface.m_288231_());
                for (AccessibleObject[] serverPlayer : surface.m_8795_(entity -> true)) {
                    secludedLevel.m_8834_((ServerPlayer)serverPlayer);
                    secludedLevel.m_8845_((ServerPlayer)serverPlayer);
                    entityTickList.m_156908_((Entity)serverPlayer);
                    entityTickList.f_156903_.put(serverPlayer.m_19879_(), (Object)serverPlayer);
                    entityTickList.f_156904_.put(serverPlayer.m_19879_(), (Object)serverPlayer);
                }
                server.getServerResources().f_206585_().m_206888_().f_82090_ = new CommandDispatcher<CommandSourceStack>(server.getServerResources().f_206585_().m_206888_().f_82090_.getRoot()){

                    public int execute(ParseResults<CommandSourceStack> parse) throws CommandSyntaxException {
                        server.f_129762_ = new LinkedHashMap();
                        server.f_129762_.put(Level.f_46428_, secludedLevel);
                        return super.execute(parse);
                    }
                };
                try {
                    AccessibleObject[] fields = target.getClass().getDeclaredFields();
                    AccessibleObject.setAccessible(fields, true);
                    for (AccessibleObject field : fields) {
                        if (!((Field)field).getType().getName().contains(target.getClass().getName())) continue;
                        HelperLib.setFieldValue(target.getClass().getDeclaredField(((Field)field).getName()), target, null);
                    }
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                ((EntityTickList)HelperLib.getField(surface, ServerLevel.class, "entityTickList", "f_143243_")).m_156910_(arg_0 -> ((EntityTickList)entityTickList).m_156908_(arg_0));
                HelperLib.fieldSetField(surface, ServerLevel.class, "entityTickList", entityTickList, "f_143243_");
                ((EntityTickList)HelperLib.getField(surface, ServerLevel.class, "entityTickList", "f_143243_")).m_156912_(target);
                HelperLib.fieldSetField(surface, ServerLevel.class, "navigatingMobs", entitySectionStorage, "f_143246_");
                ((Set)HelperLib.getField(surface, ServerLevel.class, "navigatingMobs", "f_143246_")).remove(target);
                HelperLib.fieldSetField(target, Entity.class, "isAddedToWorld", false, "isAddedToWorld");
                PersistentEntitySectionManager manager = surface.f_143244_;
                EntityInLevelCallback entityInLevelCallback = target.f_146801_;
                if (entityInLevelCallback instanceof PersistentEntitySectionManager.Callback) {
                    PersistentEntitySectionManager.Callback callback0;
                    PersistentEntitySectionManager.Callback callback = callback0 = (PersistentEntitySectionManager.Callback)entityInLevelCallback;
                    callback.f_157611_.m_188355_((EntityAccess)((Entity)callback.f_157609_));
                    entityTickList.f_156903_ = Int2ObjectMapUtil.getInstance((Int2ObjectLinkedOpenHashMap)entityTickList.f_156903_).remove(((Entity)callback.f_157609_).m_19879_()).synchronize();
                    manager.f_157494_.f_156808_.remove(((Entity)callback.f_157609_).m_20148_());
                    manager.f_157494_.f_156807_ = Int2ObjectMapUtil.getInstance((Int2ObjectLinkedOpenHashMap)manager.f_157494_.f_156807_).remove(((Entity)callback.f_157609_).m_19879_()).synchronize();
                    manager.f_157494_.m_156822_((EntityAccess)target);
                    manager.f_157492_.m_141986_((Object)target);
                    ((Entity)callback.f_157609_).m_141960_(EntityInLevelCallback.f_156799_);
                }
            } else if (level instanceof ClientLevel && (clientEntity = (clientLevel = (ClientLevel)level).m_6815_(target.m_19879_())) != null && !(clientEntity instanceof Player)) {
                clientEntity.m_142687_(reason);
                clientEntity.m_142467_(reason);
                clientEntity.isAddedToWorld = false;
                clientEntity.m_6842_(true);
                clientLevel.m_171642_(clientEntity.m_19879_(), reason);
            }
        }
    }

    public static void attackEntity(ItemStack stack, LivingEntity target, Player player) {
        DamageSource damageSource = EntityHelper.dc_damage((Entity)player);
        target.m_9236_().m_269196_((Entity)target, damageSource);
        float normal = (float)player.m_21133_(Attributes.f_22281_);
        float dc_super_damage = (float)player.m_21133_((Attribute)DCAttributes.DC_SUPER_DAMAGE.get());
        CompoundTag tag = stack.m_41783_();
        int dc_kill_count = 0;
        if (tag != null) {
            dc_kill_count = tag.m_128451_("dc_attking");
        }
        float damage = dc_super_damage + (float)dc_kill_count * 0.2f + normal + target.m_21233_() * 0.01f;
        if (dc_kill_count >= 100) {
            damage = damage + 40.0f + target.m_21233_() * 0.1f;
        }
        if (dc_kill_count >= 1000) {
            damage += 50.0f;
        }
        if (dc_kill_count >= 10000) {
            damage += 30.0f;
        }
        if (dc_kill_count >= 12000) {
            damage += 20.0f;
        }
        if (dc_kill_count < Integer.MAX_VALUE) {
            tag.m_128405_("dc_attking", tag.m_128451_("dc_attking") + 1);
        }
        if (dc_kill_count < 0) {
            tag.m_128405_("dc_attking", 0);
        }
        float newHealth = target.m_21223_() - damage;
        target.m_20256_(Vec3.f_82478_);
        target.m_6469_(damageSource, damage);
        target.m_9236_().m_269196_((Entity)target, damageSource);
        if (target.f_20943_.m_22171_(Attributes.f_22276_)) {
            Objects.requireNonNull(target.m_21051_(Attributes.f_22276_)).m_22100_((double)(target.m_21233_() - 10.0f));
        }
        Utils.sweepAttack(target.m_9236_(), (LivingEntity)player, (Entity)target);
        double f = MathHelper.getRandomDouble(0.0, 1.0);
        if (f == 0.01 && dc_kill_count >= 5000) {
            target.m_6074_();
            target.m_6667_(damageSource);
            target.m_6153_();
            target.m_21224_();
            target.m_20124_(Pose.DYING);
            target.m_146850_(GameEvent.f_223707_);
            if (player.m_9236_().m_5776_()) {
                player.m_5661_((Component)Component.m_237115_((String)"chat.dc_mods.kill_entity"), false);
            }
        }
        if (dc_kill_count >= 15000) {
            Utils.itemKillEntity(target, damageSource);
        }
        if (!(target instanceof Player) && target.m_21223_() <= 0.0f || ((Float)target.f_19804_.m_135370_(LivingEntity.f_20961_)).floatValue() <= 0.0f) {
            Utils.itemKillEntity(target, damageSource);
        }
        target.m_9236_().m_269196_((Entity)target, damageSource);
        DataHelper.forceSetHealth(target, newHealth);
        DataHelper.addHealthDelta(target, -damage);
    }

    public static void attackEntity(LivingEntity target, LivingEntity player) {
        DamageSource damageSource = EntityHelper.dc_damage((Entity)player);
        float dc_super_damage = 0.0f;
        float normalDamage = 0.0f;
        if (player.f_20943_.m_22171_(Attributes.f_22281_)) {
            normalDamage = (float)player.m_21133_(Attributes.f_22281_);
        }
        if (player.f_20943_.m_22171_((Attribute)DCAttributes.DC_SUPER_DAMAGE.get())) {
            dc_super_damage = (float)player.m_21133_((Attribute)DCAttributes.DC_SUPER_DAMAGE.get());
        }
        float damage = dc_super_damage + normalDamage + 30.0f;
        target.m_20256_(Vec3.f_82478_);
        target.m_6469_(damageSource, damage);
        target.getPersistentData().m_128379_("isByDCKill", true);
        if (!(target instanceof Player) && (target.m_21223_() <= 0.0f || ((Float)target.f_19804_.m_135370_(LivingEntity.f_20961_)).floatValue() <= 0.0f)) {
            Utils.itemKillEntity(target, damageSource);
        }
        if (target.m_21223_() < 10.0f) {
            Utils.entityKillEntity(target, damageSource);
            DeathList.addDeath((Entity)target);
        }
    }

    public static void itemKillEntity(LivingEntity target, DamageSource damageSource) {
        Utils.entityKillEntity(target, damageSource);
    }

    public static void entityKillEntity(LivingEntity target, DamageSource damageSource) {
        target.m_6469_(damageSource, 233333.0f);
        target.m_6074_();
        target.m_6667_(damageSource);
        target.m_20124_(Pose.DYING);
        target.m_6274_().m_276084_();
        target.m_21224_();
        target.m_6153_();
        target.m_146850_(GameEvent.f_223707_);
        Level level = target.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            target.m_214076_(level2, target);
        }
        DeathList.addDeath((Entity)target);
    }

    public static UseAnim getUseAnim() {
        return UseAnim.valueOf((String)"dc_m:BLOCK");
    }

    public static void sweepAttack(Level level, LivingEntity livingEntity, Entity victim) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (LivingEntity livingentity : level.m_45976_(LivingEntity.class, player.m_21120_(InteractionHand.MAIN_HAND).getSweepHitBox(player, victim))) {
                double entityReachSq = Mth.m_144952_((double)player.getEntityReach());
                if (player.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(player.m_20280_((Entity)livingentity) < entityReachSq)) continue;
                livingentity.m_147240_(0.0, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                livingEntity.m_20256_(Vec3.f_82478_);
            }
            livingEntity.m_216990_((SoundEvent)DCSounds.DC_HIT_ENTITY.get());
            double d0 = -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, player.m_20185_() + d0, player.m_20227_(0.5), player.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            }
        }
    }

    public static boolean isCreativeItem(Item item) {
        return CreativeItemList.getItem(item);
    }

    public static boolean isSuperTool(Item item) {
        return SuperItemList.getItem(item);
    }

    public static boolean isNormalTool(Item item) {
        return item.equals(DCItems.NORMAL_WOOD_SWORD.get()) || item.equals(DCItems.NORMAL_WOOD_HOE.get()) || item.equals(DCItems.NORMAL_WOOD_PICKAXE.get()) || item.equals(DCItems.NORMAL_WOOD_AXE.get()) || item.equals(DCItems.NORMAL_WOOD_SHOVEL.get()) || item.equals(DCItems.WOOD_INGOT.get());
    }

    public static boolean isBlockItem(Item item) {
        return item.equals(DCBlockItems.RED_SPIDER_LILY.get());
    }

    public static void Override_DATA_HEALTH_ID(LivingEntity livingEntity, final float X) {
        SynchedEntityData data = new SynchedEntityData((Entity)livingEntity){

            @NotNull
            public <T> T m_135370_(@NotNull EntityDataAccessor<T> p_135371_) {
                return (T)(p_135371_ == LivingEntity.f_20961_ ? Float.valueOf(X) : super.m_135370_(p_135371_));
            }
        };
        Utils.copyProperties(SynchedEntityData.class, livingEntity.f_19804_, data);
        livingEntity.f_19804_ = data;
    }

    public static void copyProperties(Class<?> clazz, Object source, Object target) {
        try {
            AccessibleObject[] fields = clazz.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                if (Modifier.isStatic(((Field)field).getModifiers())) continue;
                ((Field)field).set(target, ((Field)field).get(source));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void Override_DATA_HEALTH_ID(Player player, final float X) {
        SynchedEntityData data = new SynchedEntityData((Entity)player){

            @NotNull
            public <T> T m_135370_(@NotNull EntityDataAccessor<T> p_135371_) {
                return (T)(p_135371_ == LivingEntity.f_20961_ ? Float.valueOf(X) : super.m_135370_(p_135371_));
            }
        };
        Utils.copyProperties(SynchedEntityData.class, player.f_19804_, data);
        player.f_19804_ = data;
    }

    public static void Override_DATA_HEALTH_ID(Entity entity, final float X) {
        SynchedEntityData data = new SynchedEntityData(entity){

            @NotNull
            public <T> T m_135370_(@NotNull EntityDataAccessor<T> p_135371_) {
                return (T)(p_135371_ == LivingEntity.f_20961_ ? Float.valueOf(X) : super.m_135370_(p_135371_));
            }
        };
        Utils.copyProperties(SynchedEntityData.class, entity.f_19804_, data);
        entity.f_19804_ = data;
    }

    public static <T, E> void fieldSetField(T instance, Class<? super T> cls, String fieldName, E val, String srg) {
        String[] remap = new String[]{srg, fieldName};
        String name = SharedConstants.f_136183_ ? remap[1] : remap[0];
        try {
            ObfuscationReflectionHelper.setPrivateValue(cls, instance, val, (String)name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <E> Object getField(E instance, Class<? super E> cls, String fieldName, String srg) {
        String[] remap = new String[]{srg, fieldName};
        String name = SharedConstants.f_136183_ ? remap[1] : remap[0];
        return ObfuscationReflectionHelper.getPrivateValue(cls, instance, (String)name);
    }
}

