/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.utils.helpers;

import java.util.ArrayList;
import java.util.List;
import net.daichang.dcmods.common.damage_source.DCDamageSource;
import net.daichang.dcmods.common.entity.DCLoveElaina;
import net.daichang.dcmods.event.DCForgeEventHandler;
import net.daichang.dcmods.inits.DCDamageType;
import net.daichang.dcmods.utils.helpers.DataHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityHelper
extends DataHelper {
    public static void noHurtDuration(LivingEntity living) {
        living.f_20916_ = 0;
        living.f_20917_ = 0;
        living.m_20331_(false);
        living.f_19802_ = 0;
        living.f_20926_ = 0;
    }

    public static List<Entity> getEntity(Level level, double x, double y, double z, double range) {
        AABB aabb = new AABB(x - range, y - range, z - range, x + range, y + range, z + range);
        return new ArrayList<Entity>(level.m_45976_(Entity.class, aabb));
    }

    public static DamageSource damageSource(Entity attacked, ResourceKey<DamageType> damageType) {
        return new DamageSource((Holder)attacked.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(damageType), attacked);
    }

    public static DamageSource void_damage(Entity attacked) {
        return EntityHelper.damageSource(attacked, (ResourceKey<DamageType>)DamageTypes.f_268724_);
    }

    public static DamageSource generic_damage(Entity attack) {
        return EntityHelper.damageSource(attack, (ResourceKey<DamageType>)DamageTypes.f_268433_);
    }

    public static DamageSource generic_kill_damage(Entity attack) {
        return EntityHelper.damageSource(attack, (ResourceKey<DamageType>)DamageTypes.f_286979_);
    }

    public static DamageSource dc_damage(Entity attack) {
        return new DCDamageSource((Holder<DamageType>)attack.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DCDamageType.SUPER_DAMAGE), attack);
    }

    public static void spawnEntity(Level level, Entity entity, EntityType<?> spawn) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = entity.m_20185_();
            double y = entity.m_20186_() + 30.0;
            double z = entity.m_20189_();
            double radius = 15.0;
            for (int i = 0; i < 100; ++i) {
                double randomX = Math.round(x - radius + Math.random() * (2.0 * radius));
                double randomZ = Math.round(z - radius + Math.random() * (2.0 * radius));
                Entity entityToSpawn = spawn.m_262496_(serverLevel, BlockPos.m_274561_((double)randomX, (double)y, (double)randomZ), MobSpawnType.COMMAND);
                entityToSpawn.getPersistentData().m_128379_("isDCArrowR", true);
                entityToSpawn.m_20219_(Vec3.m_82539_((Vec3i)BlockPos.m_274561_((double)randomX, (double)y, (double)randomZ)));
                serverLevel.m_7967_(entityToSpawn);
            }
        }
    }

    public static void spawnEntity2(Level level, Entity entity, EntityType<?> spawn) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = entity.m_20185_();
            double y = entity.m_20186_();
            double z = entity.m_20189_();
            double radius = 50.0;
            for (int i = 0; i < 30; ++i) {
                double randomX = Math.round(x - radius + Math.random() * (2.0 * radius));
                double randomZ = Math.round(z - radius + Math.random() * (2.0 * radius));
                Entity entityToSpawn = spawn.m_262496_(serverLevel, BlockPos.m_274561_((double)randomX, (double)y, (double)randomZ), MobSpawnType.EVENT);
                entityToSpawn.m_20219_(Vec3.m_82539_((Vec3i)BlockPos.m_274561_((double)randomX, (double)y, (double)randomZ)));
                serverLevel.m_7967_(entityToSpawn);
            }
        }
    }

    public static boolean hasElaina(Level level) {
        DCLoveElaina elaina;
        if (level == null) {
            return false;
        }
        boolean found = false;
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            for (Entity entity : clientLevel.m_142646_().m_142273_()) {
                if (!(entity instanceof DCLoveElaina)) continue;
                elaina = (DCLoveElaina)entity;
                if (!DCForgeEventHandler.livingEntities.contains((Object)elaina)) {
                    DCForgeEventHandler.livingEntities.add((LivingEntity)elaina);
                }
                found = true;
            }
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Entity entity : serverLevel.m_8583_()) {
                if (!(entity instanceof DCLoveElaina)) continue;
                elaina = (DCLoveElaina)entity;
                if (!DCForgeEventHandler.livingEntities.contains((Object)elaina)) {
                    DCForgeEventHandler.livingEntities.add((LivingEntity)elaina);
                }
                found = true;
            }
        }
        return found;
    }

    public static void forceKnockBack(LivingEntity target, LivingEntity attacker, float XYValue, float ZValue) {
        Vec3 direction = target.m_20182_().m_82546_(attacker.m_20182_()).m_82541_();
        Vec3 knockbackVec = direction.m_82490_((double)XYValue);
        target.m_20256_(target.m_20184_().m_82520_(knockbackVec.f_82479_, knockbackVec.f_82480_ + (double)ZValue, knockbackVec.f_82481_));
    }

    public static void forceHeal(LivingEntity living, float value) {
        if (value >= 0.0f && living.m_21223_() < living.m_21233_()) {
            EntityHelper.forceSetHealth(living, living.m_21223_() + value);
        }
        if (living.m_21223_() > living.m_21233_()) {
            EntityHelper.forceSetHealth(living, living.m_21233_());
        }
    }
}

