/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.utils.helpers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.daichang.dcmods.library.DCBaseLib;
import net.minecraft.world.entity.Entity;

public class FileHelper
implements DCBaseLib {
    static final String DEFAULT_FILE_PATH = path + "/dc_list.txt";

    public static void creativeFile(String filePath) {
        File file = new File(filePath);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            System.err.println("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6: " + filePath);
        }
    }

    public static void creativeDefaultFile() {
        FileHelper.creativeFile(DEFAULT_FILE_PATH);
    }

    public static List<String> getFileItems(String filePath) {
        ArrayList<String> fileItems = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = br.readLine()) != null) {
                fileItems.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileItems;
    }

    public static boolean hasYouItem(String path, String item) {
        boolean isTrue = false;
        for (String s : FileHelper.getFileItems(path)) {
            if (!s.contains(item)) continue;
            isTrue = true;
            break;
        }
        return isTrue;
    }

    public static void writeYouItem(String filePath, String youItem) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(filePath, true));){
            if (!FileHelper.hasYouItem(filePath, youItem)) {
                bw.write("[" + youItem + "]");
                bw.newLine();
            } else {
                System.out.println("\u5f53\u524d\u5185\u5bb9\u5df2\u7ecf\u5728\u5217\u8868\u4e86");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean defaultHasTarget(Entity entity) {
        return FileHelper.hasYouItem(DEFAULT_FILE_PATH, entity.m_20149_());
    }

    public static void defaultWriteYouItem(Entity entity) {
        FileHelper.writeYouItem(DEFAULT_FILE_PATH, entity.m_20149_());
    }

    public static void removeYouItem(String filePath, String removeItem) {
        File inputFile = new File(filePath);
        File tempFile = new File(filePath + ".tmp");
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFile));
             BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                String trimmedLine = currentLine.trim();
                if (trimmedLine.equals(removeItem)) continue;
                writer.write(currentLine);
                writer.newLine();
            }
            inputFile.delete();
            tempFile.renameTo(inputFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void removeDefaultItem(Entity entity) {
        FileHelper.removeYouItem(DEFAULT_FILE_PATH, entity.m_20149_());
    }
}

