/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.utils.helpers;

import java.util.Random;

public class MathHelper {
    private static final Random random = new Random();

    public static int getRandomInt(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("max must be greater than or equal to min");
        }
        return random.nextInt(max - min + 1) + min;
    }

    public static double getRandomDouble(double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("max must be greater than or equal to min");
        }
        return min + (max - min) * random.nextDouble();
    }

    public static double getCosine(double angle) {
        return Math.cos(angle);
    }

    public static double getCosineInDegrees(double angleInDegrees) {
        return Math.cos(Math.toRadians(angleInDegrees));
    }

    public static double getSine(double angle) {
        return Math.sin(angle);
    }

    public static double getSineInDegrees(double angleInDegrees) {
        return Math.sin(Math.toRadians(angleInDegrees));
    }

    public static double getSquareRoot(double number) {
        if (number < 0.0) {
            throw new IllegalArgumentException("number must be non-negative");
        }
        return Math.sqrt(number);
    }

    public static double getPower(double base, double exponent) {
        return Math.pow(base, exponent);
    }

    public static double getAbsoluteValue(double number) {
        return Math.abs(number);
    }

    public static int getAbsoluteValue(int number) {
        return Math.abs(number);
    }

    public static double getMax(double ... numbers) {
        if (numbers == null || numbers.length == 0) {
            throw new IllegalArgumentException("At least one number must be provided");
        }
        double max = numbers[0];
        for (double num : numbers) {
            if (!(num > max)) continue;
            max = num;
        }
        return max;
    }

    public static double getMin(double ... numbers) {
        if (numbers == null || numbers.length == 0) {
            throw new IllegalArgumentException("At least one number must be provided");
        }
        double min = numbers[0];
        for (double num : numbers) {
            if (!(num < min)) continue;
            min = num;
        }
        return min;
    }

    public static double getNaturalLog(double number) {
        if (number <= 0.0) {
            throw new IllegalArgumentException("number must be positive");
        }
        return Math.log(number);
    }

    public static double getCommonLog(double number) {
        if (number <= 0.0) {
            throw new IllegalArgumentException("number must be positive");
        }
        return Math.log10(number);
    }

    public static long getFactorial(int number) {
        if (number < 0) {
            throw new IllegalArgumentException("number must be non-negative");
        }
        long result = 1L;
        for (int i = 1; i <= number; ++i) {
            result *= (long)i;
        }
        return result;
    }

    public static boolean isPrime(int number) {
        if (number <= 1) {
            return false;
        }
        if (number <= 3) {
            return true;
        }
        if (number % 2 == 0 || number % 3 == 0) {
            return false;
        }
        int i = 5;
        while (i * i <= number) {
            if (number % i == 0 || number % (i + 2) == 0) {
                return false;
            }
            i += 6;
        }
        return true;
    }

    public static double getPi() {
        return Math.PI;
    }

    public static double getE() {
        return Math.E;
    }

    public static double getTangent(double angle) {
        return Math.tan(angle);
    }

    public static double getTangentInDegrees(double angleInDegrees) {
        return Math.tan(Math.toRadians(angleInDegrees));
    }

    public static double getArcSine(double angle) {
        if (angle < -1.0 || angle > 1.0) {
            throw new IllegalArgumentException("angle must be between -1 and 1");
        }
        return Math.asin(angle);
    }

    public static double getArcSineInDegrees(double angle) {
        if (angle < -1.0 || angle > 1.0) {
            throw new IllegalArgumentException("angle must be between -1 and 1");
        }
        return Math.toDegrees(Math.asin(angle));
    }

    public static double getArcCosine(double angle) {
        if (angle < -1.0 || angle > 1.0) {
            throw new IllegalArgumentException("angle must be between -1 and 1");
        }
        return Math.acos(angle);
    }

    public static double getArcCosineInDegrees(double angle) {
        if (angle < -1.0 || angle > 1.0) {
            throw new IllegalArgumentException("angle must be between -1 and 1");
        }
        return Math.toDegrees(Math.acos(angle));
    }

    public static double getArcTangent(double angle) {
        return Math.atan(angle);
    }

    public static double getArcTangentInDegrees(double angle) {
        return Math.toDegrees(Math.atan(angle));
    }

    public static double getSum(double ... numbers) {
        if (numbers == null) {
            throw new IllegalArgumentException("numbers must not be null");
        }
        double sum = 0.0;
        for (double num : numbers) {
            sum += num;
        }
        return sum;
    }

    public static double getAverage(double ... numbers) {
        if (numbers == null || numbers.length == 0) {
            throw new IllegalArgumentException("At least one number must be provided");
        }
        return MathHelper.getSum(numbers) / (double)numbers.length;
    }

    public static double getDifference(double a, double b) {
        return a - b;
    }

    public static double getProduct(double ... numbers) {
        if (numbers == null) {
            throw new IllegalArgumentException("numbers must not be null");
        }
        double product = 1.0;
        for (double num : numbers) {
            product *= num;
        }
        return product;
    }

    public static double getQuotient(double a, double b) {
        if (b == 0.0) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        return a / b;
    }

    public static double getModulus(double a, double b) {
        if (b == 0.0) {
            throw new ArithmeticException("Cannot divide by zero");
        }
        return a % b;
    }

    public static double getVectorMagnitude(double ... components) {
        if (components == null) {
            throw new IllegalArgumentException("components must not be null");
        }
        double sumOfSquares = 0.0;
        for (double component : components) {
            sumOfSquares += component * component;
        }
        return Math.sqrt(sumOfSquares);
    }

    public static double getDotProduct(double[] vector1, double[] vector2) {
        if (vector1 == null || vector2 == null) {
            throw new IllegalArgumentException("Vectors must not be null");
        }
        if (vector1.length != vector2.length) {
            throw new IllegalArgumentException("Vectors must have the same length");
        }
        double dotProduct = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            dotProduct += vector1[i] * vector2[i];
        }
        return dotProduct;
    }

    public static double[] getCrossProduct(double[] vector1, double[] vector2) {
        if (vector1 == null || vector2 == null) {
            throw new IllegalArgumentException("Vectors must not be null");
        }
        if (vector1.length != 3 || vector2.length != 3) {
            throw new IllegalArgumentException("Vectors must be 3-dimensional");
        }
        double[] crossProduct = new double[]{vector1[1] * vector2[2] - vector1[2] * vector2[1], vector1[2] * vector2[0] - vector1[0] * vector2[2], vector1[0] * vector2[1] - vector1[1] * vector2[0]};
        return crossProduct;
    }
}

