/*
 * Decompiled with CFR 0.152.
 */
package net.daichang.dcmods.utils.helpers;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import net.daichang.dcmods.utils.GaussianFilter;
import net.daichang.dcmods.utils.helpers.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class Render2DHelper
extends RenderHelper {
    public static HashMap<Integer, Integer> shadowCache = new HashMap();

    public static void drawBlurredShadow(PoseStack matrices, float x, float y, float width, float height, int blurRadius, Color color) {
        float _X = (x -= (float)blurRadius) - 0.25f;
        float _Y = (y -= (float)blurRadius) + 0.25f;
        int identifier = (int)((width += (float)(blurRadius * 2)) * (height += (float)(blurRadius * 2)) + width + (float)(color.hashCode() * blurRadius) + (float)blurRadius);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int texId = -1;
        if (shadowCache.containsKey(identifier)) {
            texId = shadowCache.get(identifier);
        } else {
            if (width <= 0.0f) {
                width = 1.0f;
            }
            if (height <= 0.0f) {
                height = 1.0f;
            }
            BufferedImage original = new BufferedImage((int)width, (int)height, 3);
            Graphics2D g = original.createGraphics();
            g.setColor(color);
            g.fillRect(blurRadius, blurRadius, (int)(width - (float)(blurRadius * 2)), (int)(height - (float)(blurRadius * 2)));
            g.dispose();
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage blurred = op.filter(original, null);
            NativeImage nativeImage = Render2DHelper.convertBufferedImageToNativeImage(blurred, color);
            texId = TextureUtil.generateTextureId();
            TextureUtil.prepareImage((int)texId, (int)blurred.getWidth(), (int)blurred.getHeight());
            nativeImage.m_85040_(0, 0, 0, false);
            nativeImage.close();
            shadowCache.put(identifier, texId);
        }
        RenderSystem.setShaderTexture((int)0, (int)texId);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix, _X, _Y, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix, _X, _Y + height, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, _X + width, _Y + height, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix, _X + width, _Y, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void drawGradientRound(PoseStack ms, float v, float v1, float i, float i1, float v2, Color darker, Color darker1, Color darker2, Color darker3) {
        Render2DHelper.renderRoundedQuad2(ms, darker, darker1, darker2, darker3, v, v1, v + i, v1 + i1, v2);
    }

    public static void renderRoundedQuad2(PoseStack matrices, Color c, Color c2, Color c3, Color c4, double fromX, double fromY, double toX, double toY, double radius) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Render2DHelper.renderRoundedQuadInternal2(matrices.m_85850_().m_252922_(), (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f, (float)c2.getRed() / 255.0f, (float)c2.getGreen() / 255.0f, (float)c2.getBlue() / 255.0f, (float)c2.getAlpha() / 255.0f, (float)c3.getRed() / 255.0f, (float)c3.getGreen() / 255.0f, (float)c3.getBlue() / 255.0f, (float)c3.getAlpha() / 255.0f, (float)c4.getRed() / 255.0f, (float)c4.getGreen() / 255.0f, (float)c4.getBlue() / 255.0f, (float)c4.getAlpha() / 255.0f, fromX, fromY, toX, toY, radius);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderRoundedQuadInternal2(Matrix4f matrix, float cr, float cg, float cb, float ca, float cr1, float cg1, float cb1, float ca1, float cr2, float cg2, float cb2, float ca2, float cr3, float cg3, float cb3, float ca3, double fromX, double fromY, double toX, double toY, double radius) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        double[][] map = new double[][]{{toX - radius, toY - radius, radius}, {toX - radius, fromY + radius, radius}, {fromX + radius, fromY + radius, radius}, {fromX + radius, toY - radius, radius}};
        for (int i = 0; i < 4; ++i) {
            double[] current = map[i];
            double rad = current[2];
            block6: for (double r = (double)(i * 90); r <= (double)(90 + i * 90); r += 10.0) {
                float radian = (float)Math.toRadians(r);
                float sin = (float)(Math.sin(radian) * rad);
                float cos = (float)(Math.cos(radian) * rad);
                switch (i) {
                    case 0: {
                        bufferBuilder.m_252986_(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).m_85950_(cr3, cg3, cb3, ca3).m_5752_();
                        continue block6;
                    }
                    case 1: {
                        bufferBuilder.m_252986_(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).m_85950_(cr1, cg1, cb1, ca1).m_5752_();
                        continue block6;
                    }
                    case 2: {
                        bufferBuilder.m_252986_(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
                        continue block6;
                    }
                    default: {
                        bufferBuilder.m_252986_(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).m_85950_(cr2, cg2, cb2, ca2).m_5752_();
                    }
                }
            }
        }
        tesselator.m_85914_();
        RenderSystem.enableDepthTest();
    }

    private static NativeImage convertBufferedImageToNativeImage(BufferedImage image, Color customColor) {
        NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, image.getWidth(), image.getHeight(), false);
        int customA = customColor.getAlpha();
        int customR = customColor.getRed();
        int customG = customColor.getGreen();
        int customB = customColor.getBlue();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int argb = image.getRGB(x, y);
                int originalA = argb >> 24 & 0xFF;
                int finalA = originalA * customA / 255;
                int combinedColor = finalA << 24 | customR << 16 | customG << 8 | customB;
                nativeImage.m_84988_(x, y, combinedColor);
            }
        }
        return nativeImage;
    }

    public static void drawRect(PoseStack matrices, float x, float y, float width, float height, Color c) {
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        Render2DHelper.setupRender();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix, x, y + height, 0.0f).m_193479_(c.getRGB());
        buffer.m_252986_(matrix, x + width, y + height, 0.0f).m_193479_(c.getRGB());
        buffer.m_252986_(matrix, x + width, y, 0.0f).m_193479_(c.getRGB());
        buffer.m_252986_(matrix, x, y, 0.0f).m_193479_(c.getRGB());
        tesselator.m_85914_();
        Render2DHelper.endRender();
    }

    public static void drawRound(PoseStack matrices, float x, float y, float width, float height, float radius, Color color) {
        Render2DHelper.renderRoundedQuad(matrices, color, x, y, width + x, height + y, radius, 4.0);
    }

    public static void renderRoundedQuad(PoseStack matrices, Color c, double fromX, double fromY, double toX, double toY, double radius, double samples) {
        Render2DHelper.setupRender();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Render2DHelper.renderRoundedQuadInternal(matrices.m_85850_().m_252922_(), (float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f, fromX, fromY, toX, toY, radius, samples);
        Render2DHelper.endRender();
    }

    public static void renderRoundedQuadInternal(Matrix4f matrix, float cr, float cg, float cb, float ca, double fromX, double fromY, double toX, double toY, double radius, double samples) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        double[][] map = new double[][]{{toX - radius, toY - radius, radius}, {toX - radius, fromY + radius, radius}, {fromX + radius, fromY + radius, radius}, {fromX + radius, toY - radius, radius}};
        for (int i = 0; i < 4; ++i) {
            double[] current = map[i];
            double rad = current[2];
            for (double r = (double)i * 90.0; r < 90.0 + (double)i * 90.0; r += 90.0 / samples) {
                float rad1 = (float)Math.toRadians(r);
                float sin = (float)(Math.sin(rad1) * rad);
                float cos = (float)(Math.cos(rad1) * rad);
                bufferBuilder.m_252986_(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
            }
            float rad1 = (float)Math.toRadians(90.0 + (double)i * 90.0);
            float sin = (float)(Math.sin(rad1) * rad);
            float cos = (float)(Math.cos(rad1) * rad);
            bufferBuilder.m_252986_(matrix, (float)current[0] + sin, (float)current[1] + cos, 0.0f).m_85950_(cr, cg, cb, ca).m_5752_();
        }
        RenderSystem.enableDepthTest();
        tesselator.m_85914_();
    }

    public static void draw2DGradientRect(PoseStack matrices, float left, float top, float right, float bottom, Color leftBottomColor, Color leftTopColor, Color rightBottomColor, Color rightTopColor) {
        Matrix4f matrix = matrices.m_85850_().m_252922_();
        Render2DHelper.setupRender();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix, right, top, 0.0f).m_193479_(rightTopColor.getRGB());
        bufferBuilder.m_252986_(matrix, left, top, 0.0f).m_193479_(leftTopColor.getRGB());
        bufferBuilder.m_252986_(matrix, left, bottom, 0.0f).m_193479_(leftBottomColor.getRGB());
        bufferBuilder.m_252986_(matrix, right, bottom, 0.0f).m_193479_(rightBottomColor.getRGB());
        tesselator.m_85914_();
        Render2DHelper.endRender();
    }

    public static void drawRoundGradient(PoseStack poseStack, float x, float y, float width, float height, float radius, int startColor, int endColor) {
        Render2DHelper.drawRound(poseStack, x, y, width, height, radius, new Color(startColor));
        Color start = new Color(startColor);
        Color end = new Color(endColor);
        Render2DHelper.draw2DGradientRect(poseStack, x, y, x + width, y + height, start, end, start, end);
    }

    public static void lightRays(PoseStack poseStack, float partialTicks, float x, float y, MultiBufferSource multiBufferSource) {
        float v = 0.0f;
        if (Minecraft.m_91087_().f_91073_ != null) {
            v = ((float)Minecraft.m_91087_().f_91073_.m_46467_() + partialTicks) / 500.0f;
        }
        float v1 = Math.min(v > 0.8f ? (v - 0.8f) / 0.2f : 0.0f, 1.0f);
        RandomSource randomSource = RandomSource.m_216335_((long)432L);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)new ResourceLocation("dc_m", "textures/entities/white.png")));
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        for (int i = 0; i < 100; ++i) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(randomSource.m_188501_() * 360.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(randomSource.m_188501_() * 360.0f + v * 90.0f));
            float v2 = randomSource.m_188501_() * 100.0f + 5.0f + v1;
            float v3 = randomSource.m_188501_() * 100.0f + 1.0f + v1;
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
            int i1 = 50;
            Render2DHelper.vertex01(vertexConsumer, matrix4f, matrix3f, 1, 30, 51, i1);
            Render2DHelper.vertex2(vertexConsumer, matrix4f, matrix3f, v2, v3);
            Render2DHelper.vertex3(vertexConsumer, matrix4f, matrix3f, v2, v3);
            Render2DHelper.vertex01(vertexConsumer, matrix4f, matrix3f, 1, 30, 51, i1);
            Render2DHelper.vertex3(vertexConsumer, matrix4f, matrix3f, v2, v3);
            Render2DHelper.vertex4(vertexConsumer, matrix4f, matrix3f, v2, v3);
            Render2DHelper.vertex01(vertexConsumer, matrix4f, matrix3f, 48, 0, 51, i1);
            Render2DHelper.vertex4(vertexConsumer, matrix4f, matrix3f, v2, v3);
            Render2DHelper.vertex2(vertexConsumer, matrix4f, matrix3f, v2, v3);
        }
        poseStack.m_85849_();
    }

    private static void vertex01(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, int r, int g, int b, int alpha) {
        vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, alpha).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(15).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void vertex2(VertexConsumer p_253956_, Matrix4f p_254053_, Matrix3f matrix3f, float p_253704_, float p_253701_) {
        p_253956_.m_252986_(p_254053_, -((float)(Math.sqrt(3.0) / 2.0)) * p_253701_, p_253704_, -0.5f * p_253701_).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(15).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void vertex3(VertexConsumer p_253850_, Matrix4f p_254379_, Matrix3f matrix3f, float p_253729_, float p_254030_) {
        p_253850_.m_252986_(p_254379_, (float)(Math.sqrt(3.0) / 2.0) * p_254030_, p_253729_, -0.5f * p_254030_).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(15).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void vertex4(VertexConsumer p_254184_, Matrix4f p_254082_, Matrix3f matrix3f, float p_253649_, float p_253694_) {
        p_254184_.m_252986_(p_254082_, 0.0f, p_253649_, p_253694_).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(15).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

