/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import dev.dracu.bigmobs.blockentity.NautilusDecorBlockEntity;
import dev.dracu.bigmobs.init.BlockEntityInit;
import dev.dracu.bigmobs.init.SoundInit;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class NautilusDecorBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final Map<Direction, VoxelShape> SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)14.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)14.0, (double)14.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)14.0, (double)14.0, (double)12.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)2.0, (double)0.0, (double)4.0, (double)16.0, (double)14.0, (double)12.0)));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public NautilusDecorBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityInit.NAUTILUS_DECOR_ENTITY.get()).m_155264_(pos, state);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.m_5776_()) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof NautilusDecorBlockEntity) {
                NautilusDecorBlockEntity blockEntity = (NautilusDecorBlockEntity)be;
                ItemStackHandler inventory = blockEntity.getInventory();
                for (int index = 0; index < inventory.getSlots(); ++index) {
                    ItemStack stack = inventory.getStackInSlot(index);
                    ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
                    level.m_7967_((Entity)entity);
                }
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (level.m_5776_() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof NautilusDecorBlockEntity) {
            NautilusDecorBlockEntity blockEntity = (NautilusDecorBlockEntity)be;
            ItemStack stack = player.m_21120_(hand);
            ItemStackHandler inventory = blockEntity.getInventory();
            if (!stack.m_41619_() && inventory.getStackInSlot(0).m_41613_() < stack.m_41741_()) {
                ItemStack toInsert = stack.m_41777_();
                toInsert.m_41764_(1);
                ItemStack leftover = inventory.insertItem(0, toInsert, false);
                if (leftover.m_41619_()) {
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    level.m_5594_((Player)null, pos, (SoundEvent)SoundInit.DECOR_INSERT.get(), SoundSource.BLOCKS, 1.0f, 1.2f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.FAIL;
    }

    protected InteractionResult useWithoutItem(BlockState p_329061_, Level p_331143_, BlockPos p_332658_, Player p_330362_, BlockHitResult p_330700_) {
        BlockEntity var7 = p_331143_.m_7702_(p_332658_);
        if (var7 instanceof NautilusDecorBlockEntity) {
            NautilusDecorBlockEntity $$6 = (NautilusDecorBlockEntity)var7;
            p_331143_.m_5594_((Player)null, p_332658_, SoundEvents.f_11797_, SoundSource.BLOCKS, 1.0f, 1.0f);
            $$6.wobble(NautilusDecorBlockEntity.WobbleStyle.NEGATIVE);
            p_331143_.m_142346_((Entity)p_330362_, GameEvent.f_157792_, p_332658_);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean isPathfindable(BlockState p_276295_, PathComputationType p_276303_) {
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE.get(pState.m_61143_((Property)FACING));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }
}

