/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.block;

import dev.dracu.bigmobs.entity.ParsnippetEntity;
import dev.dracu.bigmobs.init.ItemInit;
import dev.dracu.bigmobs.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SproutParsnipBlock
extends CropBlock {
    public static final int MAX_HATCH_LEVEL = 2;
    public static final IntegerProperty HATCH;
    private static final int REGULAR_HATCH_TIME_TICKS = 21600;
    private static final int BOOSTED_HATCH_TIME_TICKS = 12000;
    private static final int RANDOM_HATCH_OFFSET_TICKS = 310;
    private static final VoxelShape SHAPE;
    public static final IntegerProperty AGE;

    public SproutParsnipBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0)));
    }

    public IntegerProperty m_7959_() {
        return AGE;
    }

    public int m_7419_() {
        return 2;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.m_213897_(state, level, pos, random);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HATCH, AGE});
    }

    protected ItemLike m_6404_() {
        return (ItemLike)ItemInit.SPROUT_PARSNIP.get();
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack(this.m_6404_());
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public int getHatchLevel(BlockState pState) {
        return (Integer)pState.m_61143_((Property)HATCH);
    }

    private boolean isReadyToHatch(BlockState pState) {
        return this.getHatchLevel(pState) == 2;
    }

    public void m_213897_(BlockState pState, ServerLevel level, BlockPos pos, RandomSource pRandom) {
        if (!this.isReadyToHatch(pState)) {
            level.m_5594_((Player)null, pos, SoundEvents.f_276434_, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
            level.m_7731_(pos, (BlockState)pState.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(this.getHatchLevel(pState) + 1)), 2);
        } else {
            level.m_5594_((Player)null, pos, (SoundEvent)SoundInit.SPROUT_HATCH.get(), SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
            level.m_46961_(pos, false);
            ParsnippetEntity entity = new ParsnippetEntity((Level)level, pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
            if (entity != null) {
                Vec3 $$5 = pos.m_252807_();
                entity.m_6863_(false);
                entity.m_7678_($$5.m_7096_(), $$5.m_7098_(), $$5.m_7094_(), Mth.m_14177_((float)(level.f_46441_.m_188501_() * 360.0f)), 0.0f);
                level.m_7967_((Entity)entity);
            }
        }
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        boolean $$5 = SproutParsnipBlock.hatchBoost((BlockGetter)pLevel, pPos);
        if (!pLevel.m_5776_() && $$5) {
            pLevel.m_46796_(3009, pPos, 0);
        }
        int $$6 = $$5 ? 11999 : 12000;
        int $$7 = $$6 / 3;
        pLevel.m_220407_(GameEvent.f_157797_, pPos, GameEvent.Context.m_223722_((BlockState)pState));
        pLevel.m_186460_(pPos, (Block)this, $$7 + pLevel.f_46441_.m_188503_(300));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public static boolean hatchBoost(BlockGetter pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_276630_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        return below.m_60713_(Blocks.f_50093_);
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.m_60713_(Blocks.f_50093_);
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof Ravager && pLevel.m_46469_().m_46207_(GameRules.f_46132_)) {
            pLevel.m_46953_(pPos, true, pEntity);
        }
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }

    static {
        AGE = BlockStateProperties.f_61406_;
        HATCH = BlockStateProperties.f_61416_;
        SHAPE = Block.m_49796_((double)6.0, (double)-1.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0);
    }
}

