/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.block;

import dev.dracu.bigmobs.blockentity.SunkenDabloonBlockEntity;
import dev.dracu.bigmobs.init.BlockEntityInit;
import dev.dracu.bigmobs.init.ItemInit;
import dev.dracu.bigmobs.init.PropertyInit;
import dev.dracu.bigmobs.init.SoundInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class SunkenDabloonBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ACTIVE = PropertyInit.ACTIVE;
    public static final BooleanProperty EJECT = PropertyInit.EJECT;
    public static final IntegerProperty CHARGES = IntegerProperty.m_61631_((String)"charges", (int)0, (int)4);
    private final boolean isOminous;

    public SunkenDabloonBlock(BlockBehaviour.Properties properties, boolean check) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EJECT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CHARGES, (Comparable)Integer.valueOf(0)));
        this.isOminous = check;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE});
        builder.m_61104_(new Property[]{EJECT});
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{CHARGES});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        BlockEntity entity = world.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        if (entity instanceof SunkenDabloonBlockEntity) {
            SunkenDabloonBlockEntity target = (SunkenDabloonBlockEntity)entity;
            if (this.isActive(state) && !this.isEjecting(state) && stack.m_150930_(this.isOminous ? (Item)ItemInit.DABLOON.get() : (Item)ItemInit.DABLOON.get())) {
                int charges = (Integer)state.m_61143_((Property)CHARGES);
                if (charges < 3) {
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)CHARGES, (Comparable)Integer.valueOf(charges + 1)), 3);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    if (world instanceof ServerLevel) {
                        ServerLevel lvl = (ServerLevel)world;
                        lvl.m_5594_((Player)null, pos, (SoundEvent)SoundInit.COIN_INSERT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    return InteractionResult.SUCCESS;
                }
                world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)EJECT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CHARGES, (Comparable)Integer.valueOf(charges + 1)), 3);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    lvl.m_5594_((Player)null, pos, (SoundEvent)SoundInit.BOON_INSERT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int i, int e) {
        return world.m_7702_(pos) == null ? super.m_8133_(state, world, pos, i, e) : world.m_7702_(pos).m_7531_(i, e);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        SunkenDabloonBlockEntity vault = new SunkenDabloonBlockEntity(pos, state);
        vault.setVault(this.isOminous);
        return vault;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return SunkenDabloonBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.DABLOON_STASHSTONE_SUNKEN_ENTITY.get()), SunkenDabloonBlockEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isActive(BlockState state) {
        return (Boolean)state.m_61143_((Property)ACTIVE);
    }

    public boolean isEjecting(BlockState state) {
        return (Boolean)state.m_61143_((Property)EJECT);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)ACTIVE) != false ? 4 : 0;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }
}

