/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.block;

import dev.dracu.bigmobs.entity.WalkerEntity;
import dev.dracu.bigmobs.init.EntityInit;
import dev.dracu.bigmobs.init.ParticleInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class WoodEgg
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public WoodEgg(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return RotatedPillarBlock.m_154376_((BlockState)pState, (Rotation)pRot);
    }

    private void spawnInfestation(ServerLevel level, BlockPos pos) {
        WalkerEntity $$2 = (WalkerEntity)((EntityType)EntityInit.Walker_Entity.get()).m_20615_((Level)level);
        if ($$2 != null) {
            $$2.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_8767_((ParticleOptions)((SimpleParticleType)ParticleInit.SAWDUST.get()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 30, 0.0, 0.0, 0.0, 2.0);
            level.m_7967_((Entity)$$2);
            $$2.m_21373_();
        }
        for (BlockPos nearbyPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-3, -3, -3), (BlockPos)pos.m_7918_(3, 3, 3))) {
            BlockState state;
            if (nearbyPos.equals((Object)pos) || !((state = level.m_8055_(nearbyPos)).m_60734_() instanceof WoodEgg)) continue;
            level.m_186460_(nearbyPos, state.m_60734_(), 40);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_8055_(pos).m_60734_() instanceof WoodEgg) {
            this.spawnInfestation(level, pos);
            level.m_7471_(pos, false);
        }
    }

    public void m_213646_(BlockState pState, ServerLevel pLevel, BlockPos pPos, ItemStack pStack, boolean pDropExperience) {
        super.m_213646_(pState, pLevel, pPos, pStack, pDropExperience);
        if (pLevel.m_46469_().m_46207_(GameRules.f_46136_) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)pStack) == 0) {
            this.spawnInfestation(pLevel, pPos);
            pLevel.m_8767_((ParticleOptions)ParticleTypes.f_123778_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 1.2, (double)pPos.m_123343_() + 0.5, 7, 0.2, 0.2, 0.2, 0.2);
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean $$6;
        if (!level.f_46443_ && ($$6 = level.m_276867_(pos)) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnInfestation(serverLevel, pos);
            level.m_7471_(pos, false);
        }
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)ctx.m_43719_().m_122434_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, RotatedPillarBlock.f_55923_, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }
}

