/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.blockentity;

import dev.dracu.bigmobs.init.BlockEntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class NautilusDecorBlockEntity
extends BlockEntity {
    public static final int EVENT_POT_WOBBLES = 1;
    public long wobbleStartedAtTick;
    public WobbleStyle lastWobbleStyle;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return super.getStackLimit(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            NautilusDecorBlockEntity.this.m_6596_();
        }
    };
    private final LazyOptional<ItemStackHandler> optional = LazyOptional.of(() -> this.inventory);

    public NautilusDecorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.NAUTILUS_DECOR_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag bigmobsData = nbt.m_128469_("bigmobs");
        this.inventory.deserializeNBT(bigmobsData.m_128469_("Inventory"));
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag bigmobsData = new CompoundTag();
        bigmobsData.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128365_("bigmobs", (Tag)bigmobsData);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.optional.cast() : super.getCapability(cap);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getItem() {
        return this.inventory.getStackInSlot(0);
    }

    public void setItem(ItemStack stack) {
        this.inventory.setStackInSlot(0, stack);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.optional.invalidate();
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public void wobble(WobbleStyle style) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 1, style.ordinal());
        }
    }

    public boolean m_7531_(int id, int param) {
        if (this.f_58857_ != null && id == 1 && param >= 0 && param < WobbleStyle.values().length) {
            this.wobbleStartedAtTick = this.f_58857_.m_46467_();
            this.lastWobbleStyle = WobbleStyle.values()[param];
            return true;
        }
        return super.m_7531_(id, param);
    }

    public static enum WobbleStyle {
        POSITIVE(7),
        NEGATIVE(10);

        public final int duration;

        private WobbleStyle(int duration) {
            this.duration = duration;
        }
    }
}

