/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.blockentity;

import dev.dracu.bigmobs.block.SunkenDabloonBlock;
import dev.dracu.bigmobs.init.BlockEntityInit;
import dev.dracu.bigmobs.init.SoundInit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class SunkenDabloonBlockEntity
extends BlockEntity {
    private String table;
    private int dropsRemaining = 0;
    private int dropDelay = 0;
    private boolean isOminous;
    private int cd;

    public SunkenDabloonBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.DABLOON_STASHSTONE_SUNKEN_ENTITY.get(), pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.table != null) {
            tag.m_128359_("LootTable", this.table);
        }
        tag.m_128405_("Cooldown", this.cd);
        tag.m_128379_("Ominous", this.isOminous);
        tag.m_128405_("DropsRemaining", this.dropsRemaining);
        tag.m_128405_("DropDelay", this.dropDelay);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("LootTable")) {
            this.table = tag.m_128461_("LootTable");
        }
        this.cd = tag.m_128451_("Cooldown");
        this.isOminous = tag.m_128471_("Ominous");
        this.dropsRemaining = tag.m_128451_("DropsRemaining");
        this.dropDelay = tag.m_128451_("DropDelay");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection queen, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            if (packet.m_131708_().m_128441_("LootTable")) {
                this.table = packet.m_131708_().m_128461_("LootTable");
            }
            this.cd = packet.m_131708_().m_128451_("Cooldown");
            this.isOminous = packet.m_131708_().m_128471_("Ominous");
            this.dropsRemaining = packet.m_131708_().m_128451_("DropsRemaining");
            this.dropDelay = packet.m_131708_().m_128451_("DropDelay");
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        if (this.table != null) {
            tag.m_128359_("LootTable", this.table);
        }
        tag.m_128405_("DropsRemaining", this.dropsRemaining);
        tag.m_128405_("DropDelay", this.dropDelay);
        tag.m_128405_("Cooldown", this.cd);
        tag.m_128379_("Ominous", this.isOminous);
        return tag;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, SunkenDabloonBlockEntity target) {
        Object object;
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel lvl = (ServerLevel)world;
        if (target.getCd() > 0) {
            target.setCd(target.getCd() - 1);
        }
        if ((object = state.m_60734_()) instanceof SunkenDabloonBlock) {
            SunkenDabloonBlock block = (SunkenDabloonBlock)((Object)object);
            target.updateBlock();
            if (block.isActive(state)) {
                lvl.m_8767_((ParticleOptions)(target.isOminous() ? ParticleTypes.f_123748_ : ParticleTypes.f_123746_), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.12, 0.12, 0.12, 0.0);
                if (block.isEjecting(state)) {
                    if (target.dropsRemaining > 0) {
                        if (target.dropDelay-- <= 0) {
                            target.dropDelay = 20;
                            --target.dropsRemaining;
                            for (ItemStack stack : SunkenDabloonBlockEntity.getLootDirectly(lvl, target, target.getLootTable())) {
                                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (ItemStack)stack);
                                lvl.m_5594_(null, pos, (SoundEvent)SoundInit.BOON_EJECT.get(), SoundSource.BLOCKS, 1.0f, 1.2f);
                            }
                            if (target.dropsRemaining <= 0) {
                                world.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)SunkenDabloonBlock.EJECT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SunkenDabloonBlock.CHARGES, (Comparable)Integer.valueOf(0))).m_61124_((Property)SunkenDabloonBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                                lvl.m_5594_(null, pos, (SoundEvent)SoundInit.BOON_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                target.setCd(12000);
                            }
                        }
                    } else if (target.getCd() == 0) {
                        target.dropsRemaining = Mth.m_216271_((RandomSource)world.f_46441_, (int)2, (int)5);
                        target.dropDelay = 20;
                        target.setCd(20 * target.dropsRemaining);
                        lvl.m_5594_(null, pos, (SoundEvent)SoundInit.BOON_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            } else {
                lvl.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.95, (double)pos.m_123343_() + 0.5, 1, 0.12, 0.12, 0.12, 0.0);
                if (target.getCd() == 0) {
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)SunkenDabloonBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                    lvl.m_5594_(null, pos, (SoundEvent)SoundInit.BOON_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
    }

    public static List<ItemStack> getLootDirectly(ServerLevel world, SunkenDabloonBlockEntity target, String table) {
        LootTable lootTable = world.m_7654_().m_278653_().m_278676_(target.isOminous() ? new ResourceLocation("bigmobs", "gameplay/windmill") : new ResourceLocation("bigmobs", "gameplay/sunken"));
        LootParams params = new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)target.m_58899_())).m_287286_(LootContextParams.f_81462_, (Object)target).m_287286_(LootContextParams.f_81461_, (Object)target.m_58900_()).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287235_(LootContextParamSets.f_81421_);
        return lootTable.m_287195_(params);
    }

    public int getCd() {
        return this.cd;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public String getLootTable() {
        return this.table;
    }

    public void setCd(int i) {
        this.cd = i;
    }

    public void setVault(boolean check) {
        this.isOminous = check;
    }

    public void updateBlock() {
        this.m_6596_();
        this.m_58904_().m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

