/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.BigZombieEntityAnimation;
import dev.dracu.bigmobs.entity.BigZombieEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.TamableAnimal;
import org.jetbrains.annotations.NotNull;

public class BigZombieEntityModel<B extends TamableAnimal>
extends HierarchicalModel<BigZombieEntity> {
    private final ModelPart head;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "bigzombie_entity"), "main");
    private final ModelParts parts;

    public BigZombieEntityModel(ModelPart root) {
        ModelPart waist = root.m_171324_("waist");
        ModelPart body = waist.m_171324_("body");
        ModelPart leftLeg = body.m_171324_("leftLeg");
        ModelPart torso = body.m_171324_("torso");
        ModelPart neck = torso.m_171324_("neck");
        ModelPart head = neck.m_171324_("head");
        ModelPart turtle = head.m_171324_("turtle");
        ModelPart thead = turtle.m_171324_("thead");
        ModelPart tarmr = turtle.m_171324_("tarmr");
        ModelPart tarml = turtle.m_171324_("tarml");
        ModelPart tlegl = turtle.m_171324_("tlegl");
        ModelPart tlegr = turtle.m_171324_("tlegr");
        ModelPart backhair = head.m_171324_("backhair");
        ModelPart hair = head.m_171324_("hair");
        ModelPart skirt = torso.m_171324_("skirt");
        ModelPart rightArm = torso.m_171324_("rightArm");
        ModelPart rightItem = rightArm.m_171324_("rightItem");
        ModelPart leftArm = torso.m_171324_("leftArm");
        ModelPart leftItem = leftArm.m_171324_("leftItem");
        ModelPart breast = torso.m_171324_("breast");
        ModelPart cloth = breast.m_171324_("cloth");
        ModelPart goon = cloth.m_171324_("goon");
        ModelPart rightLeg = body.m_171324_("rightLeg");
        this.head = neck.m_171324_("head");
        this.parts = new ModelParts(waist, body, leftLeg, torso, neck, head, turtle, thead, tarmr, tarml, tlegl, tlegr, backhair, hair, skirt, rightArm, rightItem, leftArm, leftItem, breast, cloth, goon, rightLeg);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition waist = partdefinition.m_171599_("waist", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.9f, (float)11.0f, (float)0.0f));
        PartDefinition body = waist.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.8f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(48, 62).m_171488_(-1.8f, -1.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(32, 31).m_171488_(-3.0f, -7.0f, -2.0f, 6.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.9f, (float)-4.0f, (float)0.0f));
        PartDefinition neck = torso.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(64, 64).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition turtle = head.m_171599_("turtle", CubeListBuilder.m_171558_().m_171514_(94, 0).m_171488_(-4.0f, -3.0f, -4.0f, 9.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-6.0f, (float)0.0f));
        PartDefinition thead = turtle.m_171599_("thead", CubeListBuilder.m_171558_().m_171514_(88, 0).m_171488_(-2.0f, -1.0f, -3.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-1.0f, (float)-4.0f));
        PartDefinition tarmr = turtle.m_171599_("tarmr", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)-1.0f, (float)-2.0f));
        PartDefinition head_r1 = tarmr.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(114, 14).m_171480_().m_171488_(-2.5f, 0.0f, -1.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.3f, (float)1.0f, (float)-0.9f, (float)0.0f, (float)0.0f, (float)-0.829f));
        PartDefinition tarml = turtle.m_171599_("tarml", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.3f, (float)-1.0f, (float)-2.9f));
        PartDefinition head_r2 = tarml.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(114, 14).m_171488_(-1.5f, 0.0f, -1.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.829f));
        PartDefinition tlegl = turtle.m_171599_("tlegl", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)4.0f));
        PartDefinition head_r3 = tlegl.m_171599_("head_r3", CubeListBuilder.m_171558_().m_171514_(101, 15).m_171488_(-1.5f, 0.0f, 0.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)0.0f, (float)1.0f, (float)-1.5708f, (float)-1.4399f, (float)1.5708f));
        PartDefinition tlegr = turtle.m_171599_("tlegr", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)0.0f, (float)4.0f));
        PartDefinition head_r4 = tlegr.m_171599_("head_r4", CubeListBuilder.m_171558_().m_171514_(101, 18).m_171488_(-1.5f, 0.0f, -1.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)1.0f, (float)-1.5708f, (float)-1.4399f, (float)1.5708f));
        PartDefinition backhair = head.m_171599_("backhair", CubeListBuilder.m_171558_().m_171514_(7, 17).m_171488_(-4.0f, -1.0f, 0.0f, 8.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(25, 17).m_171480_().m_171488_(4.0f, 7.0f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(25, 17).m_171488_(-6.0f, 7.0f, 0.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)4.0f));
        PartDefinition hair = head.m_171599_("hair", CubeListBuilder.m_171558_().m_171514_(1, 16).m_171480_().m_171488_(3.0f, 1.6f, 0.0f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(1, 16).m_171488_(-4.0f, 1.6f, 0.0f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(25, 21).m_171488_(-5.0f, -0.4f, 0.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(25, 21).m_171480_().m_171488_(2.0f, -0.4f, 0.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(32, 17).m_171488_(-3.5f, -1.4f, 0.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(32, 17).m_171480_().m_171488_(0.5f, -1.4f, 0.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(34, 17).m_171488_(-0.5f, -1.4f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.6f, (float)-5.0f));
        PartDefinition skirt = torso.m_171599_("skirt", CubeListBuilder.m_171558_().m_171514_(0, 78).m_171488_(-4.6f, -0.1f, -2.5f, 9.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.1f, (float)3.0f, (float)0.0f));
        PartDefinition rightArm = torso.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(52, 30).m_171488_(-2.614f, -0.126f, -1.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-7.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition rightItem = rightArm.m_171599_("rightItem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.614f, (float)8.874f, (float)1.0f));
        PartDefinition leftArm = torso.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171488_(-0.386f, -0.126f, -1.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-7.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition leftItem = leftArm.m_171599_("leftItem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.386f, (float)6.874f, (float)1.5f));
        PartDefinition breast = torso.m_171599_("breast", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.1f, (float)-6.0f, (float)-2.0f));
        PartDefinition cloth = breast.m_171599_("cloth", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)10.0f, (float)2.0f));
        PartDefinition body_r1 = cloth.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(52, 22).m_171488_(-3.0f, -3.8452f, -2.513f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.9f, (float)-7.0f, (float)0.0f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition goon = cloth.m_171599_("goon", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.9f, (float)-7.0f, (float)0.0f));
        PartDefinition body_r2 = goon.m_171599_("body_r2", CubeListBuilder.m_171558_().m_171514_(73, 46).m_171480_().m_171488_(-2.9f, -2.0f, -4.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.7422f, (float)0.0322f, (float)0.0295f));
        PartDefinition body_r3 = goon.m_171599_("body_r3", CubeListBuilder.m_171558_().m_171514_(73, 46).m_171488_(-0.1f, -2.0f, -4.0f, 3.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.7422f, (float)-0.0322f, (float)-0.0295f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(64, 70).m_171480_().m_171488_(-0.9f, 1.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(48, 46).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull BigZombieEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, BigZombieEntityAnimation.IDLE, ageInTicks);
        this.head.f_104203_ = headPitch * 0.005f;
        this.head.f_104204_ = netHeadYaw * 0.005f;
        if (!entity.m_20072_()) {
            this.m_267799_(BigZombieEntityAnimation.WALK, limbSwing, limbSwingAmount, 1.3f, 1.3f);
        }
        if (entity.isSitting()) {
            this.m_233381_(entity.sittingAnimationState, BigZombieEntityAnimation.SITTING, ageInTicks);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.waist().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.waist();
    }

    private record ModelParts(ModelPart waist, ModelPart body, ModelPart leftLeg, ModelPart torso, ModelPart neck, ModelPart head, ModelPart turtle, ModelPart thead, ModelPart tarmr, ModelPart tarml, ModelPart tlegl, ModelPart tlegr, ModelPart backhair, ModelPart hair, ModelPart skirt, ModelPart rightArm, ModelPart rightItem, ModelPart leftArm, ModelPart leftItem, ModelPart breast, ModelPart cloth, ModelPart goon, ModelPart rightLeg) {
    }
}

