/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.BordEntityAnimation;
import dev.dracu.bigmobs.entity.BordEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class BordEntityModel<B extends Mob>
extends HierarchicalModel<BordEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "bord_entity"), "main");
    private final ModelParts parts;

    public BordEntityModel(ModelPart root) {
        ModelPart broot = root.m_171324_("broot");
        ModelPart head = broot.m_171324_("head");
        ModelPart feather = head.m_171324_("feather");
        ModelPart beak = head.m_171324_("beak");
        ModelPart right_leg = broot.m_171324_("right_leg");
        ModelPart r_toes = right_leg.m_171324_("r_toes");
        ModelPart left_wing = head.m_171324_("left_wing");
        ModelPart right_wing = head.m_171324_("right_wing");
        ModelPart left_leg = broot.m_171324_("left_leg");
        ModelPart l_toes = left_leg.m_171324_("l_toes");
        this.parts = new ModelParts(broot, head, l_toes, beak, r_toes, right_wing, left_wing, left_leg, right_leg, feather);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition broot = partdefinition.m_171599_("broot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition head = broot.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(14, 0).m_171488_(-3.0f, -10.0f, -1.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(12, 9).m_171488_(-3.0f, -2.0f, -1.0f, 6.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 15).m_171480_().m_171488_(3.0f, -10.0f, -1.0f, 2.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 15).m_171488_(-5.0f, -10.0f, -1.0f, 2.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition feather = head.m_171599_("feather", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition cube_r1 = feather.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(10, 28).m_171488_(-3.0f, -1.0f, -1.0f, 5.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-1.0f, (float)2.25f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition beak = head.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(16, 6).m_171488_(-8.0f, -3.0f, -2.0f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)-4.0f, (float)0.0f));
        PartDefinition right_wing = head.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(22, 24).m_171488_(-1.0f, 0.0f, -1.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-6.0f, (float)0.0f));
        PartDefinition left_wing = head.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(22, 24).m_171480_().m_171488_(0.0f, 0.0f, -1.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-6.0f, (float)0.0f));
        PartDefinition left_leg = broot.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(18, 19).m_171488_(4.5f, -1.0f, -0.75f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)10.0f, (float)0.0f));
        PartDefinition l_toes = left_leg.m_171599_("l_toes", CubeListBuilder.m_171558_().m_171514_(14, 18).m_171488_(4.5f, 0.0f, 0.75f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = l_toes.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(13, 14).m_171488_(0.0f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.7f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition cube_r3 = l_toes.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(13, 14).m_171488_(-1.0f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f));
        PartDefinition right_leg = broot.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(18, 19).m_171488_(-2.5f, -2.0f, -0.75f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)0.0f));
        PartDefinition r_toes = right_leg.m_171599_("r_toes", CubeListBuilder.m_171558_().m_171514_(14, 18).m_171488_(-2.5f, -1.0f, 0.75f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = r_toes.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(13, 14).m_171488_(0.0f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.3f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition cube_r5 = r_toes.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(13, 14).m_171488_(-1.0f, 0.0f, -2.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.75f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.broot().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.broot();
    }

    public void setupAnim(@NotNull BordEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, BordEntityAnimation.IDLE, ageInTicks);
        this.m_233381_(entity.flyingAnimationState, BordEntityAnimation.FLYING, ageInTicks);
        this.m_233381_(entity.partyAnimationState, BordEntityAnimation.PARTY, ageInTicks);
        if (!entity.m_20072_() && entity.m_20096_()) {
            this.m_267799_(BordEntityAnimation.WALK, limbSwing, limbSwingAmount, 4.0f, 4.0f);
        }
    }

    private record ModelParts(ModelPart broot, ModelPart head, ModelPart feather, ModelPart l_toes, ModelPart r_toes, ModelPart left_wing, ModelPart right_wing, ModelPart left_leg, ModelPart right_leg, ModelPart modelPart) {
    }
}

