/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.ColossalCarrotEntityAnimation;
import dev.dracu.bigmobs.entity.ColossalCarrotEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.NeutralMob;
import org.jetbrains.annotations.NotNull;

public class ColossalCarrotEntityModel<B extends NeutralMob>
extends HierarchicalModel<ColossalCarrotEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "colossalcarrot_entity"), "main");
    private final ModelParts parts;

    public ColossalCarrotEntityModel(ModelPart root) {
        ModelPart body = root.m_171324_("body");
        ModelPart head2 = body.m_171324_("head2");
        ModelPart upperHead = head2.m_171324_("upperHead");
        ModelPart upperNeck = upperHead.m_171324_("upperNeck");
        ModelPart upperLip = upperNeck.m_171324_("upperLip");
        ModelPart lowerHead = head2.m_171324_("lowerHead");
        ModelPart lowerNeck = lowerHead.m_171324_("lowerNeck");
        ModelPart lowerLip = lowerNeck.m_171324_("lowerLip");
        ModelPart legs = body.m_171324_("legs");
        ModelPart leg1 = legs.m_171324_("leg1");
        ModelPart leg2 = legs.m_171324_("leg2");
        ModelPart leg3 = legs.m_171324_("leg3");
        ModelPart leg4 = legs.m_171324_("leg4");
        ModelPart leg5 = legs.m_171324_("leg5");
        ModelPart leg6 = legs.m_171324_("leg6");
        ModelPart brains = upperHead.m_171324_("brains");
        ModelPart eyes = upperHead.m_171324_("eyes");
        this.parts = new ModelParts(body, head2, upperHead, upperNeck, upperLip, lowerHead, lowerNeck, lowerLip, legs);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)30.0f, (float)11.0f));
        PartDefinition head2 = body.m_171599_("head2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-24.0f));
        PartDefinition upperHead = head2.m_171599_("upperHead", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(13.0f, -22.0f, -39.0f, 4.0f, 21.0f, 58.0f, new CubeDeformation(0.0f)).m_171514_(274, 68).m_171488_(-13.0f, -22.0f, -39.0f, 26.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(0, 170).m_171488_(-13.0f, -22.0f, 6.0f, 26.0f, 21.0f, 13.0f, new CubeDeformation(0.0f)).m_171514_(125, 0).m_171488_(-17.0f, -23.0f, -39.0f, 34.0f, 1.0f, 58.0f, new CubeDeformation(0.0f)).m_171514_(82, 63).m_171488_(-14.0f, -26.0f, -31.0f, 28.0f, 4.0f, 45.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171480_().m_171488_(-17.0f, -22.0f, -39.0f, 4.0f, 21.0f, 58.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-21.0f, (float)25.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition upperNeck = upperHead.m_171599_("upperNeck", CubeListBuilder.m_171558_().m_171514_(12, 157).m_171480_().m_171488_(-15.0f, -18.9848f, -1.8264f, 3.0f, 18.0f, 26.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(68, 115).m_171480_().m_171488_(-12.0f, -18.9848f, -1.8264f, 24.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(185, 64).m_171488_(-15.0f, -19.9848f, -1.8264f, 30.0f, 1.0f, 26.0f, new CubeDeformation(0.0f)).m_171514_(12, 157).m_171488_(12.0f, -18.9848f, -1.8264f, 3.0f, 18.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)-49.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition upperLip = upperNeck.m_171599_("upperLip", CubeListBuilder.m_171558_().m_171514_(252, 17).m_171480_().m_171488_(-13.0f, -12.9848f, 2.1736f, 4.0f, 12.0f, 23.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(66, 0).m_171480_().m_171488_(-13.0f, -13.9848f, 2.1736f, 26.0f, 1.0f, 23.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(67, 28).m_171480_().m_171488_(-9.0f, -12.9848f, 2.1736f, 18.0f, 12.0f, 14.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(252, 17).m_171488_(9.0f, -12.9848f, 2.1736f, 4.0f, 12.0f, 23.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-17.0f));
        PartDefinition upneckTeeth = upperNeck.m_171599_("upneckTeeth", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-0.1281f, (float)-17.4639f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = upneckTeeth.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(120, 205).m_171488_(15.0f, 0.0f, 19.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(133, 166).m_171488_(15.0f, -6.0f, 18.0f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition upheadTeeth = upperHead.m_171599_("upheadTeeth", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-66.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = upheadTeeth.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(128, 233).m_171488_(17.0f, -3.9162f, 32.8177f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(133, 170).m_171488_(17.0f, -7.9162f, 31.8177f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(129, 166).m_171488_(-18.0f, -6.9162f, 34.8177f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(126, 226).m_171488_(-18.0f, -3.9162f, 35.3177f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(135, 171).m_171488_(17.0f, -6.9162f, 47.8177f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition eyes = upperHead.m_171599_("eyes", CubeListBuilder.m_171558_().m_171514_(80, 150).m_171488_(-8.9f, -10.0f, -11.0f, 1.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(80, 150).m_171480_().m_171488_(-42.1f, -10.0f, -11.0f, 1.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)25.0f, (float)-3.0f, (float)11.0f));
        PartDefinition eyeL = eyes.m_171599_("eyeL", CubeListBuilder.m_171558_().m_171514_(108, 154).m_171488_(-1.6f, -9.0f, 2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)3.0f, (float)-9.0f));
        PartDefinition eyeR = eyes.m_171599_("eyeR", CubeListBuilder.m_171558_().m_171514_(108, 154).m_171480_().m_171488_(0.6f, -9.0f, 2.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-43.0f, (float)3.0f, (float)-9.0f));
        PartDefinition brains = upperHead.m_171599_("brains", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)-8.0f, (float)20.0f));
        PartDefinition cube_r3 = brains.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(143, 120).m_171488_(-1.0f, -14.0f, -1.0f, 2.0f, 16.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)0.0f));
        PartDefinition cube_r4 = brains.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(143, 120).m_171488_(0.0f, -19.0f, -1.0f, 2.0f, 16.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)13.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f));
        PartDefinition cube_r5 = brains.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(143, 120).m_171488_(1.0f, -16.0f, -1.0f, 2.0f, 16.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        PartDefinition cube_r6 = brains.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(143, 120).m_171488_(-1.0f, -16.0f, -1.0f, 2.0f, 16.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f));
        PartDefinition neck = head2.m_171599_("neck", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-20.0f, (float)-24.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition lip = neck.m_171599_("lip", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)-17.0f));
        PartDefinition lowerHead = head2.m_171599_("lowerHead", CubeListBuilder.m_171558_().m_171514_(0, 80).m_171488_(13.0f, -11.0f, -39.0f, 4.0f, 9.0f, 58.0f, new CubeDeformation(0.0f)).m_171514_(117, 225).m_171488_(-17.0f, -2.0f, -39.0f, 34.0f, 1.0f, 58.0f, new CubeDeformation(0.0f)).m_171514_(0, 223).m_171488_(-13.0f, -3.0f, -39.0f, 26.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(0, 80).m_171480_().m_171488_(-17.0f, -11.0f, -39.0f, 4.0f, 9.0f, 58.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(173, 118).m_171488_(-13.0f, -11.0f, 6.0f, 26.0f, 9.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)25.0f));
        PartDefinition lowerNeck = lowerHead.m_171599_("lowerNeck", CubeListBuilder.m_171558_().m_171514_(271, 140).m_171488_(-12.0f, -17.9848f, -1.8264f, 24.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(0, 99).m_171480_().m_171488_(-15.0f, -23.9848f, -1.8264f, 3.0f, 8.0f, 26.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 99).m_171488_(12.0f, -23.9848f, -1.8264f, 3.0f, 8.0f, 26.0f, new CubeDeformation(0.0f)).m_171514_(133, 185).m_171488_(-15.0f, -15.9848f, -1.8264f, 30.0f, 1.0f, 26.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)13.3054f, (float)-45.0608f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition lowerLip = lowerNeck.m_171599_("lowerLip", CubeListBuilder.m_171558_().m_171514_(247, 98).m_171488_(9.0f, -13.9848f, 2.1736f, 4.0f, 6.0f, 23.0f, new CubeDeformation(0.0f)).m_171514_(247, 98).m_171480_().m_171488_(-13.0f, -13.9848f, 2.1736f, 4.0f, 6.0f, 23.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(295, 27).m_171488_(-9.0f, -13.9848f, 2.1736f, 18.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(198, 154).m_171480_().m_171488_(-9.0f, -8.9848f, 4.1736f, 18.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)-17.0f));
        PartDefinition lowlipTeeth = lowerLip.m_171599_("lowlipTeeth", CubeListBuilder.m_171558_().m_171514_(63, 149).m_171488_(-14.0f, -4.0f, 7.0f, 1.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(112, 226).m_171488_(-14.0f, -7.0f, 8.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(133, 170).m_171488_(13.0f, -3.0f, 7.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(109, 232).m_171488_(13.0f, -6.0f, 8.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.3054f, (float)-0.9392f));
        PartDefinition lowneckTeeth = lowerNeck.m_171599_("lowneckTeeth", CubeListBuilder.m_171558_().m_171514_(127, 229).m_171488_(-16.0f, -5.4791f, 22.9544f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(67, 150).m_171488_(-16.0f, -3.4791f, 21.9544f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(66, 133).m_171488_(-16.0f, -2.4791f, 16.9544f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-22.3054f, (float)-16.9392f));
        PartDefinition lowheadTeeth = lowerHead.m_171599_("lowheadTeeth", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)-66.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = lowheadTeeth.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(120, 216).m_171488_(17.0f, -12.9162f, 42.8177f, 1.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(108, 226).m_171488_(17.0f, -10.9162f, 39.8177f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(62, 147).m_171488_(17.0f, -7.9162f, 39.8177f, 1.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(63, 148).m_171488_(-18.0f, -6.9162f, 39.8177f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(122, 227).m_171488_(-18.0f, -8.9162f, 41.8177f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition tongue = lowerHead.m_171599_("tongue", CubeListBuilder.m_171558_().m_171514_(0, 349).m_171488_(-9.0f, -11.0f, -15.0f, 18.0f, 2.0f, 21.0f, new CubeDeformation(0.0f)).m_171514_(0, 349).m_171488_(-7.0f, -11.0f, -35.0f, 14.0f, 2.0f, 21.0f, new CubeDeformation(0.0f)).m_171514_(3, 365).m_171488_(-5.0f, -11.0f, -40.0f, 10.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition legs = body.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-20.0f));
        PartDefinition leg3 = legs.m_171599_("leg3", CubeListBuilder.m_171558_().m_171514_(84, 83).m_171488_(-2.0f, -14.0f, 28.0f, 9.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)14.0f, (float)-5.0f, (float)-7.0f));
        PartDefinition leg1 = legs.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(84, 83).m_171488_(-2.0f, -14.0f, -8.0f, 9.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)14.0f, (float)-5.0f, (float)-7.0f));
        PartDefinition leg6 = legs.m_171599_("leg6", CubeListBuilder.m_171558_().m_171514_(84, 83).m_171480_().m_171488_(-35.0f, -14.0f, 14.0f, 9.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)14.0f, (float)-5.0f, (float)7.0f));
        PartDefinition leg2 = legs.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(84, 83).m_171488_(-2.0f, -14.0f, 10.0f, 9.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)14.0f, (float)-5.0f, (float)-7.0f));
        PartDefinition leg4 = legs.m_171599_("leg4", CubeListBuilder.m_171558_().m_171514_(84, 83).m_171480_().m_171488_(-21.0f, -19.0f, -15.0f, 9.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg5 = legs.m_171599_("leg5", CubeListBuilder.m_171558_().m_171514_(84, 83).m_171480_().m_171488_(-21.0f, -19.0f, 3.0f, 9.0f, 13.0f, 9.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg0 = partdefinition.m_171599_("leg0", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-12.0f, (float)-6.0f, (float)22.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)512, (int)512);
    }

    public void setupAnim(@NotNull ColossalCarrotEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, ColossalCarrotEntityAnimation.IDLE, ageInTicks);
        this.m_233385_(entity.attackAnimationState, ColossalCarrotEntityAnimation.ATTACK, ageInTicks, 1.0f);
        if (!entity.m_20072_()) {
            this.m_267799_(ColossalCarrotEntityAnimation.COLOSSAL_CARROT_WALKING, limbSwing, limbSwingAmount, 12.0f, 12.0f);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.body().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.body();
    }

    private record ModelParts(ModelPart body, ModelPart head2, ModelPart upperHead, ModelPart upperNeck, ModelPart upperLip, ModelPart lowerHead, ModelPart lowerNeck, ModelPart lowerLip, ModelPart legs) {
    }
}

