/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.BigZombieEntityAnimation;
import dev.dracu.bigmobs.client.animation.EndpressEntityAnimation;
import dev.dracu.bigmobs.entity.EndpressEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.TamableAnimal;
import org.jetbrains.annotations.NotNull;

public class EndpressEntityModel<B extends TamableAnimal>
extends HierarchicalModel<EndpressEntity> {
    private final ModelPart head;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "endpress_entity"), "main");
    private final ModelParts parts;

    public EndpressEntityModel(ModelPart root) {
        ModelPart waist = root.m_171324_("waist");
        ModelPart body = waist.m_171324_("body");
        ModelPart torso = body.m_171324_("torso");
        ModelPart breast = torso.m_171324_("breast");
        ModelPart goon = breast.m_171324_("goon");
        ModelPart cloth = breast.m_171324_("cloth");
        ModelPart leftArm = torso.m_171324_("leftArm");
        ModelPart leftArm2 = leftArm.m_171324_("leftArm2");
        ModelPart rightArm = torso.m_171324_("rightArm");
        ModelPart rightArm2 = rightArm.m_171324_("rightArm2");
        ModelPart neck = torso.m_171324_("neck");
        ModelPart head = neck.m_171324_("head");
        ModelPart eyes = head.m_171324_("eyes");
        ModelPart leftEye = eyes.m_171324_("leftEye");
        ModelPart rightEye = eyes.m_171324_("rightEye");
        ModelPart hair = head.m_171324_("hair");
        ModelPart bangs = hair.m_171324_("bangs");
        ModelPart lowerbody = body.m_171324_("lowerbody");
        ModelPart leftThigh = lowerbody.m_171324_("leftThigh");
        ModelPart leftLeg = leftThigh.m_171324_("leftLeg");
        ModelPart skirt = lowerbody.m_171324_("skirt");
        ModelPart loincloth = skirt.m_171324_("loincloth");
        ModelPart rightThigh = lowerbody.m_171324_("rightThigh");
        ModelPart rightLeg = rightThigh.m_171324_("rightLeg");
        ModelPart headphone = head.m_171324_("headphone");
        ModelPart l_fone = headphone.m_171324_("l_fone");
        ModelPart r_fone = headphone.m_171324_("r_fone");
        this.head = neck.m_171324_("head");
        this.parts = new ModelParts(waist, body, leftLeg, torso, neck, head, hair, skirt, rightArm, leftArm, breast, cloth, goon, rightLeg, loincloth, rightThigh, leftThigh, rightArm2, leftArm2, bangs, eyes, rightEye, leftEye, headphone, l_fone, r_fone);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition waist = partdefinition.m_171599_("waist", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition body = waist.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(36, 2).m_171488_(-3.0f, -6.0f, -2.0f, 6.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition breast = torso.m_171599_("breast", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.2f, (float)-2.0f));
        PartDefinition goon = breast.m_171599_("goon", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.1f, (float)0.0f, (float)0.0f));
        PartDefinition body_r1 = goon.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(63, 55).m_171488_(-2.8f, -2.0f, -4.7f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)2.0f, (float)0.6096f, (float)0.0715f, (float)0.0037f));
        PartDefinition body_r2 = goon.m_171599_("body_r2", CubeListBuilder.m_171558_().m_171514_(79, 55).m_171480_().m_171488_(-0.2f, -2.0f, -4.7f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.2f, (float)1.0f, (float)2.0f, (float)0.6096f, (float)-0.0715f, (float)-0.0037f));
        PartDefinition cloth = breast.m_171599_("cloth", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition cloth_r1 = cloth.m_171599_("cloth_r1", CubeListBuilder.m_171558_().m_171514_(57, 8).m_171488_(-3.0f, 1.2873f, -4.5618f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(57, 8).m_171488_(-3.0f, 1.2873f, -4.5618f, 6.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)2.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = torso.m_171599_("leftArm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)-4.0f, (float)-1.0f));
        PartDefinition head_r1 = leftArm.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(44, 95).m_171480_().m_171488_(0.0f, -1.0f, 0.0f, 2.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition leftArm2 = leftArm.m_171599_("leftArm2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.386f, (float)12.874f, (float)1.0f));
        PartDefinition head_r2 = leftArm2.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(68, 109).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition rightArm = torso.m_171599_("rightArm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)-4.0f, (float)-1.0f));
        PartDefinition head_r3 = rightArm.m_171599_("head_r3", CubeListBuilder.m_171558_().m_171514_(52, 95).m_171488_(-2.0f, -1.0f, 0.0f, 2.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition rightArm2 = rightArm.m_171599_("rightArm2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.386f, (float)12.874f, (float)1.0f));
        PartDefinition head_r4 = rightArm2.m_171599_("head_r4", CubeListBuilder.m_171558_().m_171514_(60, 109).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition neck = torso.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(20, 69).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -6.0f, -4.3f, 10.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(47, 74).m_171488_(-5.0f, 2.0f, -4.3f, 1.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(43, 83).m_171488_(-5.0f, -6.0f, 3.7f, 10.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(52, 68).m_171488_(-5.0f, 2.0f, 0.7f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(52, 68).m_171480_().m_171488_(4.0f, 2.0f, 0.7f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(47, 74).m_171480_().m_171488_(4.0f, 2.0f, -4.3f, 1.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(2, 100).m_171488_(-1.5f, -6.2f, -5.8f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(13, 9).m_171488_(-1.2f, -6.4f, 2.6f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(12, 9).m_171488_(-5.8f, 1.2f, -1.9f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(12, 9).m_171488_(4.8f, -2.8f, 3.1f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(12, 9).m_171488_(-5.2f, -6.8f, -3.9f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(14, 77).m_171488_(-4.0f, -6.0f, -5.3f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(12, 9).m_171488_(-1.2f, -7.4f, 2.6f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(13, 9).m_171480_().m_171488_(-0.8f, -6.4f, -0.4f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(12, 9).m_171480_().m_171488_(4.8f, 1.2f, 2.1f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(12, 9).m_171480_().m_171488_(-5.8f, -2.8f, 0.1f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.3f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)27.0f, (float)-0.3f));
        PartDefinition leftEye = eyes.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(1, 111).m_171488_(-1.0f, -2.0f, -1.1f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-26.0f, (float)-3.0f));
        PartDefinition rightEye = eyes.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(1, 111).m_171488_(0.0f, -2.0f, -1.1f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-26.0f, (float)-3.0f));
        PartDefinition hair = head.m_171599_("hair", CubeListBuilder.m_171558_().m_171514_(66, 69).m_171488_(-5.0f, -2.0f, -0.3f, 1.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(9, 76).m_171488_(-4.0f, -1.0f, -0.3f, 1.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(66, 69).m_171480_().m_171488_(4.0f, -2.0f, -0.3f, 1.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(9, 76).m_171480_().m_171488_(3.0f, -1.0f, -0.3f, 1.0f, 11.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-5.0f));
        PartDefinition bangs = hair.m_171599_("bangs", CubeListBuilder.m_171558_().m_171514_(6, 105).m_171488_(-3.0f, -1.5f, -0.3f, 6.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headphone = head.m_171599_("headphone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.8f, (float)-1.5f, (float)-1.0f));
        PartDefinition head_r5 = headphone.m_171599_("head_r5", CubeListBuilder.m_171558_().m_171514_(4, 91).m_171488_(-9.0f, -28.0f, 2.0f, 11.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)9.3f, (float)-7.5f, (float)-26.3f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition l_fone = headphone.m_171599_("l_fone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)11.1f, (float)-2.0f, (float)0.5f));
        PartDefinition head_r6 = l_fone.m_171599_("head_r6", CubeListBuilder.m_171558_().m_171514_(13, 99).m_171488_(-1.5f, -0.7f, -0.2f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)1.0f, (float)-0.5f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition r_fone = headphone.m_171599_("r_fone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)-2.0f, (float)0.9f));
        PartDefinition head_r7 = r_fone.m_171599_("head_r7", CubeListBuilder.m_171558_().m_171514_(13, 99).m_171480_().m_171488_(-2.5f, -1.7f, -0.2f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.5f, (float)2.0f, (float)-0.9f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition lowerbody = body.m_171599_("lowerbody", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftThigh = lowerbody.m_171599_("leftThigh", CubeListBuilder.m_171558_().m_171514_(79, 30).m_171488_(-2.6f, 0.0f, -2.5f, 6.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)0.0f, (float)0.5f));
        PartDefinition leftLeg = leftThigh.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(102, 23).m_171488_(-2.0f, 0.0f, -1.5f, 4.0f, 18.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.4f, (float)8.0f, (float)-0.5f));
        PartDefinition skirt = lowerbody.m_171599_("skirt", CubeListBuilder.m_171558_().m_171514_(79, 0).m_171488_(-6.5f, -4.1f, -2.5f, 13.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition loincloth = skirt.m_171599_("loincloth", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-2.0f));
        PartDefinition rightThigh = lowerbody.m_171599_("rightThigh", CubeListBuilder.m_171558_().m_171514_(79, 30).m_171480_().m_171488_(-3.4f, 0.0f, -2.5f, 6.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)3.5f, (float)0.0f, (float)0.5f));
        PartDefinition rightLeg = rightThigh.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(102, 23).m_171480_().m_171488_(-2.0f, 0.0f, -1.5f, 4.0f, 18.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.4f, (float)8.0f, (float)-0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull EndpressEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, EndpressEntityAnimation.IDLE, ageInTicks);
        this.head.f_104203_ = headPitch * 0.003f;
        this.head.f_104204_ = netHeadYaw * 0.005f;
        if (!entity.m_20072_()) {
            this.m_267799_(BigZombieEntityAnimation.WALK, limbSwing, limbSwingAmount, 1.5f, 1.5f);
        }
        if (entity.isSitting()) {
            this.m_233381_(entity.sittingAnimationState, BigZombieEntityAnimation.SITTING, ageInTicks);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.waist().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.waist();
    }

    private record ModelParts(ModelPart waist, ModelPart body, ModelPart leftLeg, ModelPart torso, ModelPart neck, ModelPart head, ModelPart hair, ModelPart skirt, ModelPart rightArm, ModelPart leftArm, ModelPart breast, ModelPart cloth, ModelPart goon, ModelPart rightLeg, ModelPart loincloth, ModelPart rightThigh, ModelPart leftThigh, ModelPart rightArm2, ModelPart leftArm2, ModelPart bangs, ModelPart eyes, ModelPart rightEye, ModelPart leftEye, ModelPart headphone, ModelPart l_fone, ModelPart r_fone) {
    }
}

