/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.EnormousEggplantEntityAnimation;
import dev.dracu.bigmobs.entity.EnormousEggplantEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import org.jetbrains.annotations.NotNull;

public class EnormousEggplantEntityModel<B extends AbstractHorse>
extends HierarchicalModel<EnormousEggplantEntity> {
    private final ModelPart neck;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "enormouseggplant_entity"), "main");
    private final ModelParts parts;

    public EnormousEggplantEntityModel(ModelPart root) {
        ModelPart bone = root.m_171324_("bone");
        ModelPart body = bone.m_171324_("body");
        ModelPart torso = body.m_171324_("torso");
        ModelPart neck = torso.m_171324_("neck");
        ModelPart head = neck.m_171324_("head");
        ModelPart eye1 = head.m_171324_("eye1");
        ModelPart sniffer = head.m_171324_("sniffer");
        ModelPart jaw = head.m_171324_("jaw");
        ModelPart eye2 = head.m_171324_("eye2");
        ModelPart booty = torso.m_171324_("booty");
        ModelPart tail1 = booty.m_171324_("tail1");
        ModelPart tail2 = tail1.m_171324_("tail2");
        ModelPart leg1 = body.m_171324_("leg1");
        ModelPart leg2 = body.m_171324_("leg2");
        ModelPart leg3 = body.m_171324_("leg3");
        ModelPart leg4 = body.m_171324_("leg4");
        ModelPart leg5 = body.m_171324_("leg5");
        ModelPart leg6 = body.m_171324_("leg6");
        this.neck = torso.m_171324_("neck");
        this.parts = new ModelParts(bone, body, torso, neck, head, eye1, sniffer, eye2, jaw, booty, tail1, tail2, leg1, leg2, leg3, leg4, leg5, leg6);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-11.0f, -14.0f, -21.0f, 22.0f, 30.0f, 33.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-33.0f, (float)0.0f));
        PartDefinition neck = torso.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(80, 63).m_171488_(-5.0f, -47.0f, -21.0f, 10.0f, 50.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(115, 5).m_171488_(-5.0f, -9.0f, -11.0f, 10.0f, 12.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)-20.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(110, 27).m_171488_(-5.0f, -71.0f, -54.0f, 10.0f, 10.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)20.0f));
        PartDefinition eye1 = head.m_171599_("eye1", CubeListBuilder.m_171558_().m_171514_(168, 37).m_171488_(-1.0f, -1.0f, -1.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.2f, (float)-66.0f, (float)-44.0f));
        PartDefinition sniffer = head.m_171599_("sniffer", CubeListBuilder.m_171558_().m_171514_(0, 101).m_171488_(-3.0f, -5.0f, -13.0f, 6.0f, 9.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-69.0f, (float)-43.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-60.0f, (float)-40.0f));
        PartDefinition cube_r1 = jaw.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(77, 15).m_171488_(-5.0f, -1.0f, -12.7f, 10.0f, 4.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-1.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition eye2 = head.m_171599_("eye2", CubeListBuilder.m_171558_().m_171514_(168, 37).m_171480_().m_171488_(0.0f, -1.0f, -1.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.2f, (float)-66.0f, (float)-44.0f));
        PartDefinition booty = torso.m_171599_("booty", CubeListBuilder.m_171558_().m_171514_(4, 63).m_171488_(-9.0f, -12.0f, 0.0f, 18.0f, 20.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)12.0f));
        PartDefinition tail1 = booty.m_171599_("tail1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)19.0f));
        PartDefinition cube_r2 = tail1.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(136, 146).m_171488_(-7.5f, -1.0f, -4.1f, 15.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)1.0f, (float)-5.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition tail2 = tail1.m_171599_("tail2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)-1.0f));
        PartDefinition cube_r3 = tail2.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(136, 146).m_171488_(-8.5f, 0.0f, -4.1f, 15.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)0.0f, (float)-4.0f, (float)-3.1416f, (float)0.0f, (float)3.1416f));
        PartDefinition leg1 = body.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(120, 53).m_171488_(-6.0f, 0.0f, -5.0f, 10.0f, 21.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)12.0f, (float)-21.0f, (float)-19.0f));
        PartDefinition leg2 = body.m_171599_("leg2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)12.0f, (float)-21.0f, (float)3.0f));
        PartDefinition cube_r4 = leg2.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(120, 53).m_171488_(-6.0f, 1.0f, -5.0f, 10.0f, 21.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg3 = body.m_171599_("leg3", CubeListBuilder.m_171558_().m_171514_(120, 53).m_171488_(-5.0f, 0.0f, -5.0f, 10.0f, 21.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)11.0f, (float)-21.0f, (float)24.0f));
        PartDefinition leg4 = body.m_171599_("leg4", CubeListBuilder.m_171558_().m_171514_(120, 53).m_171480_().m_171488_(-4.0f, 0.0f, -5.0f, 10.0f, 21.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-12.0f, (float)-21.0f, (float)-19.0f));
        PartDefinition leg5 = body.m_171599_("leg5", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-12.0f, (float)-21.0f, (float)3.0f));
        PartDefinition cube_r5 = leg5.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(120, 53).m_171480_().m_171488_(-4.0f, 1.0f, -5.0f, 10.0f, 21.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg6 = body.m_171599_("leg6", CubeListBuilder.m_171558_().m_171514_(120, 53).m_171480_().m_171488_(-5.0f, 0.0f, -5.0f, 10.0f, 21.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-11.0f, (float)-21.0f, (float)24.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.bone().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.bone();
    }

    public void setupAnim(@NotNull EnormousEggplantEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, EnormousEggplantEntityAnimation.TRUE_IDLE, ageInTicks);
        this.m_233381_(entity.sitAnimationState, EnormousEggplantEntityAnimation.SITTING2, ageInTicks);
        this.m_233381_(entity.sitPoseAnimationState, EnormousEggplantEntityAnimation.SIT, ageInTicks);
        this.m_233381_(entity.sitUpAnimationState, EnormousEggplantEntityAnimation.STAND_UP, ageInTicks);
        this.neck.f_104203_ = headPitch * 0.0025f;
        this.neck.f_104204_ = netHeadYaw * 0.0025f;
        if (!entity.m_20072_() && entity.m_20096_()) {
            this.m_267799_(EnormousEggplantEntityAnimation.WALK, limbSwing, limbSwingAmount, 3.0f, 3.0f);
        }
    }

    private record ModelParts(ModelPart bone, ModelPart body, ModelPart torso, ModelPart neck, ModelPart head, ModelPart eye1, ModelPart sniffer, ModelPart eye2, ModelPart jaw, ModelPart booty, ModelPart tail1, ModelPart tail2, ModelPart leg1, ModelPart leg2, ModelPart leg3, ModelPart leg4, ModelPart leg5, ModelPart leg6) {
    }
}

