/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.GoliathEntityAnimation;
import dev.dracu.bigmobs.entity.GoliathEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.frog.Frog;
import org.jetbrains.annotations.NotNull;

public class GoliathEntityModel<B extends Frog>
extends HierarchicalModel<GoliathEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "goliath_entity"), "main");
    private final ModelParts parts;

    public GoliathEntityModel(ModelPart root) {
        ModelPart root6 = root.m_171324_("root");
        ModelPart body = root6.m_171324_("body");
        ModelPart head = body.m_171324_("head");
        ModelPart eyes = head.m_171324_("eyes");
        ModelPart left_arm = body.m_171324_("left_arm");
        ModelPart right_arm = body.m_171324_("right_arm");
        ModelPart tongue = body.m_171324_("tongue");
        ModelPart left_leg = body.m_171324_("left_leg");
        ModelPart right_leg = body.m_171324_("right_leg");
        ModelPart croaking_body = body.m_171324_("croaking_body");
        this.parts = new ModelParts(root6, body, head, eyes, tongue, croaking_body, left_arm, left_leg, right_arm, right_leg);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(317, 193).m_171488_(-6.0f, -4.0f, -15.0f, 12.0f, 5.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(81, 39).m_171488_(-6.0f, -1.4f, -15.0f, 12.0f, 1.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)9.0f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)-2.0f, (float)-9.0f));
        PartDefinition leftEye = eyes.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(391, 184).m_171480_().m_171488_(1.0f, -5.0f, -5.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(123, 158).m_171488_(1.0f, -9.0f, -4.0f, 6.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightEye = eyes.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(123, 158).m_171480_().m_171488_(-7.0f, -9.6f, -4.0f, 6.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(391, 184).m_171488_(-5.0f, -5.6f, -5.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)1.6f, (float)0.0f));
        PartDefinition right_leg = body.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(374, 132).m_171488_(-2.0f, -5.0f, -2.0f, 5.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)0.0f, (float)6.0f));
        PartDefinition cube_r1 = right_leg.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(316, 129).m_171488_(-4.0f, 0.0f, -8.0f, 10.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)3.098f, (float)0.0f));
        PartDefinition left_leg = body.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(374, 132).m_171480_().m_171488_(4.0f, -5.0f, 4.0f, 5.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = left_leg.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(316, 129).m_171480_().m_171488_(-6.0f, 0.0f, -8.0f, 10.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)8.0f, (float)0.0f, (float)4.0f, (float)0.0f, (float)-3.098f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(290, 149).m_171480_().m_171488_(5.0f, -5.0f, -5.0f, 3.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(316, 140).m_171480_().m_171488_(1.0f, 0.0f, -9.0f, 10.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(290, 149).m_171488_(-8.0f, -5.0f, -5.0f, 3.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(316, 140).m_171488_(-11.0f, 0.0f, -9.0f, 10.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition croaking_body = body.m_171599_("croaking_body", CubeListBuilder.m_171558_().m_171514_(269, 185).m_171488_(-5.0f, 1.0f, -5.4f, 10.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.8f, (float)-0.5f));
        PartDefinition tongue = body.m_171599_("tongue", CubeListBuilder.m_171558_().m_171514_(14, 11).m_171488_(-3.0f, -2.3f, -7.1f, 6.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.1f, (float)5.0f));
        PartDefinition body2 = body.m_171599_("body2", CubeListBuilder.m_171558_().m_171514_(81, 39).m_171488_(-6.0f, -5.2f, -6.0f, 12.0f, 1.0f, 15.0f, new CubeDeformation(0.0f)).m_171514_(307, 161).m_171488_(-6.0f, -8.0f, -6.0f, 12.0f, 6.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)512, (int)512);
    }

    public void setupAnim(@NotNull GoliathEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.jumpAnimationState, GoliathEntityAnimation.JUMP, ageInTicks);
        this.m_233381_(entity.croakAnimationState, GoliathEntityAnimation.CROAK, ageInTicks);
        this.m_233381_(entity.tongueAnimationState, GoliathEntityAnimation.TONGUE, ageInTicks);
        this.m_233381_(entity.swimIdleAnimationState, GoliathEntityAnimation.IDLE_WATER, ageInTicks);
        if (!entity.m_20072_()) {
            this.m_267799_(GoliathEntityAnimation.WALK, limbSwing, limbSwingAmount, 1.0f, 1.0f);
        } else {
            this.m_267799_(GoliathEntityAnimation.SWIM, limbSwing, limbSwingAmount, 1.0f, 1.0f);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.root6().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.root6();
    }

    private record ModelParts(ModelPart root6, ModelPart body, ModelPart head, ModelPart eyes, ModelPart left_arm, ModelPart right_arm, ModelPart croaking_body, ModelPart tongue, ModelPart right_leg, ModelPart left_leg) {
    }
}

