/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.GravelettEntityAnimation;
import dev.dracu.bigmobs.entity.GravelettEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Enemy;
import org.jetbrains.annotations.NotNull;

public class GravelettEntityModel<B extends Enemy>
extends HierarchicalModel<GravelettEntity> {
    private final ModelPart head;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "gravelett_entity"), "main");
    private final ModelParts parts;

    public GravelettEntityModel(ModelPart root) {
        ModelPart body = root.m_171324_("body");
        ModelPart torso = body.m_171324_("torso");
        ModelPart head = torso.m_171324_("head");
        ModelPart eyes = head.m_171324_("eyes");
        ModelPart legs = torso.m_171324_("legs");
        ModelPart legr = legs.m_171324_("legr");
        ModelPart legl = legs.m_171324_("legl");
        ModelPart legr2 = legs.m_171324_("legr2");
        ModelPart legl2 = legs.m_171324_("legl2");
        ModelPart y_eye = eyes.m_171324_("y_eye");
        ModelPart x_eye = eyes.m_171324_("x_eye");
        ModelPart one = y_eye.m_171324_("one");
        ModelPart two = y_eye.m_171324_("two");
        ModelPart three = x_eye.m_171324_("three");
        ModelPart four = x_eye.m_171324_("four");
        this.head = torso.m_171324_("head");
        this.parts = new ModelParts(body, torso, head, eyes, legs, legl, legl2, legr2, legr, eyes, one, two, three, four, x_eye, y_eye);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)18.0f, (float)-1.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = torso.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(36, 27).m_171488_(-4.0f, -10.0f, -1.0f, 8.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(11, 34).m_171488_(-3.0f, -11.0f, 0.5f, 6.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)4.0f, (float)-1.0f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)2.0f, (float)-0.1f));
        PartDefinition y_eye = eyes.m_171599_("y_eye", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)1.0f));
        PartDefinition one = y_eye.m_171599_("one", CubeListBuilder.m_171558_().m_171514_(31, 6).m_171480_().m_171488_(-4.0f, -10.0f, -1.0f, 5.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)0.0f, (float)0.0f));
        PartDefinition two = y_eye.m_171599_("two", CubeListBuilder.m_171558_().m_171514_(31, 6).m_171488_(-2.0f, -10.0f, -1.0f, 5.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition x_eye = eyes.m_171599_("x_eye", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition three = x_eye.m_171599_("three", CubeListBuilder.m_171558_().m_171514_(37, 2).m_171480_().m_171488_(0.0f, -2.0f, -1.0f, 5.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.0f, (float)-6.0f, (float)0.0f));
        PartDefinition four = x_eye.m_171599_("four", CubeListBuilder.m_171558_().m_171514_(37, 2).m_171488_(-5.0f, -2.0f, -1.0f, 5.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-6.0f, (float)0.0f));
        PartDefinition legs = torso.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)6.0f, (float)-2.5f));
        PartDefinition legr = legs.m_171599_("legr", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)2.0f));
        PartDefinition cube_r3 = legr.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(22, 1).m_171480_().m_171488_(-1.0f, -1.0f, -1.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.5f, (float)-1.6f, (float)-1.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition legl = legs.m_171599_("legl", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)2.0f));
        PartDefinition cube_r4 = legl.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(22, 1).m_171488_(0.0f, -1.0f, 2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)2.4f, (float)-1.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition legr2 = legs.m_171599_("legr2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.5f, (float)2.4f, (float)1.0f));
        PartDefinition cube_r5 = legr2.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(22, 1).m_171488_(0.0f, -1.0f, 2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)0.0f, (float)4.0f, (float)-1.5708f, (float)0.0f, (float)3.1416f));
        PartDefinition legl2 = legs.m_171599_("legl2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.5f, (float)2.4f, (float)5.0f));
        PartDefinition cube_r6 = legl2.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(22, 1).m_171480_().m_171488_(0.0f, -1.0f, 2.5f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)9.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)-3.1416f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@NotNull GravelettEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233385_(entity.attackAnimationState, GravelettEntityAnimation.ATTACK2, ageInTicks, 1.0f);
        this.head.f_104203_ = headPitch * 0.003f;
        this.head.f_104204_ = netHeadYaw * 0.003f;
        if (!entity.m_20072_()) {
            this.m_267799_(GravelettEntityAnimation.WALK2, limbSwing, limbSwingAmount, 2.5f, 2.5f);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.body().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.body();
    }

    private record ModelParts(ModelPart body, ModelPart torso, ModelPart head, ModelPart eyes, ModelPart legs, ModelPart legl, ModelPart legr, ModelPart legr2, ModelPart legl2, ModelPart eyes1, ModelPart one, ModelPart two, ModelPart three, ModelPart four, ModelPart xEye, ModelPart yEye) {
    }
}

