/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.NanamigoEntityAnimation;
import dev.dracu.bigmobs.entity.NanamigoEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.TamableAnimal;
import org.jetbrains.annotations.NotNull;

public class NanamigoEntityModel<B extends TamableAnimal>
extends HierarchicalModel<NanamigoEntity> {
    private final ModelPart head;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "nanamigo_entity"), "main");
    private final ModelParts parts;

    public NanamigoEntityModel(ModelPart root) {
        ModelPart go = root.m_171324_("go");
        ModelPart body = go.m_171324_("body");
        ModelPart torso = body.m_171324_("torso");
        ModelPart legs = body.m_171324_("legs");
        ModelPart legl = legs.m_171324_("legl");
        ModelPart bendl = legl.m_171324_("bendl");
        ModelPart footl = bendl.m_171324_("footl");
        ModelPart legr = legs.m_171324_("legr");
        ModelPart bendr = legr.m_171324_("bendr");
        ModelPart footr = bendr.m_171324_("footr");
        ModelPart neckbone = torso.m_171324_("neckbone");
        ModelPart head = neckbone.m_171324_("head");
        ModelPart beak = head.m_171324_("beak");
        ModelPart eyeL = head.m_171324_("eyeL");
        ModelPart eyeR = head.m_171324_("eyeR");
        ModelPart nana = head.m_171324_("nana");
        ModelPart tail = torso.m_171324_("tail");
        ModelPart wings = torso.m_171324_("wings");
        ModelPart wingR = wings.m_171324_("wingR");
        ModelPart wingL = wings.m_171324_("wingL");
        this.head = neckbone.m_171324_("head");
        this.parts = new ModelParts(body, go, head, neckbone, body, eyeL, eyeR, nana, wingL, wingR, wings, torso, beak, legs, bendl, bendr, footl, footr, legl, legr);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition go = partdefinition.m_171599_("go", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)31.9f, (float)0.0f));
        PartDefinition body = go.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition legs = body.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)-3.0f, (float)-5.0f));
        PartDefinition legl = legs.m_171599_("legl", CubeListBuilder.m_171558_().m_171514_(74, 36).m_171488_(-1.0f, -1.0f, -0.8f, 2.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)-21.0f, (float)7.0f));
        PartDefinition bendl = legl.m_171599_("bendl", CubeListBuilder.m_171558_().m_171514_(78, 36).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)-0.8f));
        PartDefinition footl = bendl.m_171599_("footl", CubeListBuilder.m_171558_().m_171514_(82, 26).m_171480_().m_171488_(-3.0f, 0.0f, -6.9f, 5.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition legr = legs.m_171599_("legr", CubeListBuilder.m_171558_().m_171514_(74, 36).m_171480_().m_171488_(-1.0f, -1.0f, -0.8f, 2.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)-21.0f, (float)7.0f));
        PartDefinition bendr = legr.m_171599_("bendr", CubeListBuilder.m_171558_().m_171514_(78, 37).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)-0.8f));
        PartDefinition footr = bendr.m_171599_("footr", CubeListBuilder.m_171558_().m_171514_(82, 26).m_171488_(-2.0f, 0.0f, -6.9f, 5.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171488_(-4.5f, -1.5f, -5.0f, 9.0f, 10.0f, 14.0f, new CubeDeformation(0.0f)).m_171514_(38, 52).m_171488_(-3.0f, 0.6f, -5.8f, 6.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-32.0f, (float)-1.0f));
        PartDefinition neckbone = torso.m_171599_("neckbone", CubeListBuilder.m_171558_().m_171514_(34, 60).m_171488_(-1.5f, -9.5f, -3.0f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(46, 64).m_171488_(-1.5f, -15.5f, 0.0f, 3.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-5.0f));
        PartDefinition head = neckbone.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-3.0f, -5.5f, -6.0f, 6.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(12, 44).m_171488_(-2.5f, -5.9f, -7.5f, 5.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition eyeL = head.m_171599_("eyeL", CubeListBuilder.m_171558_().m_171514_(67, 8).m_171488_(2.1f, -4.5f, -8.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)3.0f));
        PartDefinition eyeR = head.m_171599_("eyeR", CubeListBuilder.m_171558_().m_171514_(67, 8).m_171488_(-4.1f, -5.5f, -10.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)5.0f));
        PartDefinition beak = head.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(2, 71).m_171488_(-2.0f, -0.3f, -5.0f, 4.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-6.0f));
        PartDefinition nana = head.m_171599_("nana", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.5f, (float)0.8293f, (float)-2.0651f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = nana.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(82, 31).m_171488_(-0.3f, -0.4887f, -6.4477f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5131f, (float)0.3463f, (float)-0.189f));
        PartDefinition cube_r2 = nana.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(82, 31).m_171488_(0.1f, -0.4887f, -5.2477f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4943f, (float)-0.2316f, (float)0.1231f));
        PartDefinition bone = torso.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-18.0f, (float)-11.0f));
        PartDefinition tail = torso.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(58, 22).m_171488_(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)9.0f));
        PartDefinition cube_r3 = tail.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(58, 35).m_171488_(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)5.0f, (float)1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = tail.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(0, 63).m_171488_(-2.0f, -3.0f, 0.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)2.0f, (float)3.0f, (float)0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition wings = torso.m_171599_("wings", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wingL = wings.m_171599_("wingL", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = wingL.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 2.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = wingL.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(32, 38).m_171480_().m_171488_(0.0f, 0.0f, 8.0f, 2.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition wingR = wings.m_171599_("wingR", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = wingR.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(32, 38).m_171488_(-2.0f, 0.0f, 8.0f, 2.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = wingR.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-2.0f, 0.0f, 0.0f, 2.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull NanamigoEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, NanamigoEntityAnimation.IDLE4, ageInTicks);
        this.m_233381_(entity.flyingAnimationState, NanamigoEntityAnimation.FLY, ageInTicks);
        this.m_233381_(entity.meetAnimationState, NanamigoEntityAnimation.MEET, ageInTicks);
        this.head.f_104203_ = headPitch * 0.003f;
        this.head.f_104204_ = netHeadYaw * 0.003f;
        if (!entity.m_20072_() && entity.m_20096_()) {
            this.m_267799_(NanamigoEntityAnimation.WALK4, limbSwing, limbSwingAmount, 4.0f, 4.0f);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.go().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.go();
    }

    private record ModelParts(ModelPart body, ModelPart go, ModelPart head, ModelPart neckbone, ModelPart body1, ModelPart eyeL, ModelPart eyeR, ModelPart nana, ModelPart wingL, ModelPart wingR, ModelPart wings, ModelPart torso, ModelPart beak, ModelPart legs, ModelPart bendl, ModelPart bendr, ModelPart footl, ModelPart footr, ModelPart legl, ModelPart legr) {
    }
}

