/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.ParsnippetEntityAnimation;
import dev.dracu.bigmobs.entity.ParsnippetEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.TamableAnimal;
import org.jetbrains.annotations.NotNull;

public class ParsnippetEntityModel<B extends TamableAnimal>
extends HierarchicalModel<ParsnippetEntity> {
    private final ModelPart head;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "pipsqueakparsnip_entity"), "main");
    private final ModelParts parts;

    public ParsnippetEntityModel(ModelPart root) {
        ModelPart bone = root.m_171324_("bone");
        ModelPart body = bone.m_171324_("body");
        ModelPart head = body.m_171324_("head");
        ModelPart lowNeck = head.m_171324_("lowNeck");
        ModelPart lowLip = lowNeck.m_171324_("lowLip");
        ModelPart upNeck = head.m_171324_("upNeck");
        ModelPart upLip = upNeck.m_171324_("upLip");
        ModelPart eyes = head.m_171324_("eyes");
        ModelPart eyeL = eyes.m_171324_("eyeL");
        ModelPart ele = eyeL.m_171324_("ele");
        ModelPart eyeR = eyes.m_171324_("eyeR");
        ModelPart ere = eyeR.m_171324_("ere");
        ModelPart brains = head.m_171324_("brains");
        ModelPart legs = body.m_171324_("legs");
        ModelPart leg1 = legs.m_171324_("leg1");
        ModelPart leg2 = legs.m_171324_("leg2");
        ModelPart leg3 = legs.m_171324_("leg3");
        ModelPart leg4 = legs.m_171324_("leg4");
        ModelPart leg5 = legs.m_171324_("leg5");
        ModelPart leg6 = legs.m_171324_("leg6");
        this.head = body.m_171324_("head");
        this.parts = new ModelParts(bone, body, head, lowNeck, lowLip, upNeck, upLip, eyes, eyeL, eyeR, ele, ere, brains, legs, leg1, leg2, leg3, leg4, leg5, leg6);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)31.0f, (float)5.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 44).m_171488_(-9.0f, -7.0f, -14.0f, 17.0f, 15.0f, 29.0f, new CubeDeformation(0.0f)).m_171514_(0, 88).m_171488_(-7.0f, -9.0f, -11.0f, 13.0f, 2.0f, 24.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-18.0f, (float)-5.0f));
        PartDefinition lowNeck = head.m_171599_("lowNeck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)2.0f, (float)-12.0f));
        PartDefinition cube_r1 = lowNeck.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(130, 96).m_171488_(-7.0f, -1.4384f, -6.0115f, 15.0f, 4.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition lowLip = lowNeck.m_171599_("lowLip", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-9.0f));
        PartDefinition cube_r2 = lowLip.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(126, 5).m_171488_(-5.0f, -7.0f, -9.0f, 11.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)4.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition upNeck = head.m_171599_("upNeck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-9.0f));
        PartDefinition cube_r3 = upNeck.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(74, 88).m_171488_(-7.0f, -15.0f, -3.0f, 15.0f, 8.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)12.0f, (float)-8.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition upLip = upNeck.m_171599_("upLip", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)5.658f, (float)-13.0f));
        PartDefinition cube_r4 = upLip.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(92, 0).m_171488_(-5.0f, -12.0f, -9.0f, 11.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)6.342f, (float)5.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition eyeL = eyes.m_171599_("eyeL", CubeListBuilder.m_171558_().m_171514_(40, 114).m_171480_().m_171488_(-0.8f, -3.0f, -3.0f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)8.0f, (float)0.0f, (float)5.0f));
        PartDefinition ele = eyeL.m_171599_("ele", CubeListBuilder.m_171558_().m_171514_(48, 114).m_171480_().m_171488_(-0.7f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition eyeR = eyes.m_171599_("eyeR", CubeListBuilder.m_171558_().m_171514_(40, 114).m_171488_(-0.2f, -3.0f, -3.0f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-9.0f, (float)0.0f, (float)5.0f));
        PartDefinition ere = eyeR.m_171599_("ere", CubeListBuilder.m_171558_().m_171514_(48, 114).m_171488_(-0.3f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition brains = head.m_171599_("brains", CubeListBuilder.m_171558_().m_171514_(92, 14).m_171488_(-1.5f, -4.0f, 0.0f, 1.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)15.0f));
        PartDefinition cube_r5 = brains.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(92, 50).m_171488_(0.0f, -4.0f, 2.0f, 1.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition cube_r6 = brains.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(92, 32).m_171488_(-1.0f, -4.0f, 2.0f, 1.0f, 7.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition legs = body.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)21.0f));
        PartDefinition leg1 = legs.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(20, 114).m_171488_(-3.0f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)-18.0f, (float)-36.5f));
        PartDefinition leg2 = legs.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(20, 114).m_171488_(-3.0f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)-18.0f, (float)-26.5f));
        PartDefinition leg3 = legs.m_171599_("leg3", CubeListBuilder.m_171558_().m_171514_(20, 114).m_171488_(-3.0f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)-18.0f, (float)-16.5f));
        PartDefinition leg4 = legs.m_171599_("leg4", CubeListBuilder.m_171558_().m_171514_(20, 114).m_171480_().m_171488_(-2.0f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-9.0f, (float)-18.0f, (float)-36.5f));
        PartDefinition leg5 = legs.m_171599_("leg5", CubeListBuilder.m_171558_().m_171514_(20, 114).m_171480_().m_171488_(-2.0f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-9.0f, (float)-18.0f, (float)-26.5f));
        PartDefinition leg6 = legs.m_171599_("leg6", CubeListBuilder.m_171558_().m_171514_(20, 114).m_171480_().m_171488_(-2.0f, 0.0f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-9.0f, (float)-18.0f, (float)-16.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(@NotNull ParsnippetEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, ParsnippetEntityAnimation.IDLE3, ageInTicks);
        this.head.f_104203_ = headPitch * 0.002f;
        this.head.f_104204_ = netHeadYaw * 0.002f;
        if (!entity.m_20072_()) {
            this.m_267799_(ParsnippetEntityAnimation.WALK, limbSwing, limbSwingAmount, 2.0f, 2.0f);
        }
        if (entity.isSitting()) {
            this.m_233381_(entity.sittingAnimationState, ParsnippetEntityAnimation.SITFACTS, ageInTicks);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.bone().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.bone();
    }

    private record ModelParts(ModelPart bone, ModelPart body, ModelPart head, ModelPart lowNeck, ModelPart lowLip, ModelPart upNeck, ModelPart upLip, ModelPart eyes, ModelPart eyeL, ModelPart eyeR, ModelPart ele, ModelPart ere, ModelPart brains, ModelPart legs, ModelPart leg1, ModelPart leg2, ModelPart leg3, ModelPart leg4, ModelPart leg5, ModelPart leg6) {
    }
}

