/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.RooferEntityAnimation;
import dev.dracu.bigmobs.entity.RooferEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class RooferEntityModel<B extends Mob>
extends HierarchicalModel<RooferEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "roofer_entity"), "main");
    private final ModelParts parts;

    public RooferEntityModel(ModelPart root) {
        ModelPart root6 = root.m_171324_("bone");
        ModelPart body = root6.m_171324_("body");
        ModelPart torso = body.m_171324_("torso");
        ModelPart head = torso.m_171324_("head");
        ModelPart eye = head.m_171324_("eye");
        ModelPart armL = torso.m_171324_("armL");
        ModelPart armR = torso.m_171324_("armR");
        ModelPart legL = body.m_171324_("legL");
        ModelPart legR = body.m_171324_("legR");
        ModelPart twig = head.m_171324_("twig");
        this.parts = new ModelParts(root6, body, head, eye, torso, twig, armL, armR, legL, legR);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)13.0f, (float)-4.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-13.0f, (float)-18.0f, (float)1.0f));
        PartDefinition legL = body.m_171599_("legL", CubeListBuilder.m_171558_().m_171514_(44, 80).m_171488_(2.0f, -2.0f, 0.0f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(29, 107).m_171488_(7.0f, -2.0f, 0.0f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(96, 39).m_171488_(1.0f, 6.0f, -4.0f, 9.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)13.0f, (float)23.0f, (float)-1.0f));
        PartDefinition legR = body.m_171599_("legR", CubeListBuilder.m_171558_().m_171514_(105, 51).m_171488_(-7.0f, -2.0f, 0.0f, 5.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)13.0f, (float)23.0f, (float)-1.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(72, 77).m_171488_(-1.0f, -20.0f, -4.0f, 12.0f, 20.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(29, 94).m_171488_(-11.0f, -20.0f, -4.0f, 10.0f, 18.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(52, 0).m_171488_(-11.0f, -23.0f, -4.0f, 22.0f, 3.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)13.0f, (float)23.0f, (float)-1.0f));
        PartDefinition head = torso.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(1, 115).m_171488_(-4.0f, -5.0f, -5.0f, 8.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-7.0f, (float)-4.0f));
        PartDefinition cube_r1 = head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 56).m_171488_(-5.3819f, -5.0f, 1.1103f, 8.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-4.0f, (float)-4.0f, (float)0.0f, (float)0.8727f, (float)0.0f));
        PartDefinition cube_r2 = head.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 56).m_171488_(-2.8819f, -5.0f, 1.5103f, 8.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.0f, (float)-4.0f, (float)-4.0f, (float)0.0f, (float)-0.6545f, (float)0.0f));
        PartDefinition cube_r3 = head.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(77, 52).m_171488_(-3.0f, -2.0f, -3.0f, 5.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)-6.0f, (float)-2.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition twig = head.m_171599_("twig", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -6.0f, 0.0f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition eye = head.m_171599_("eye", CubeListBuilder.m_171558_().m_171514_(1, 43).m_171488_(-4.9819f, -17.0f, -12.1897f, 7.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(1, 43).m_171488_(-7.9819f, -15.0f, -12.1897f, 7.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)13.0f, (float)8.0f));
        PartDefinition armL = torso.m_171599_("armL", CubeListBuilder.m_171558_().m_171514_(24, 86).m_171488_(-2.0f, -2.0f, -3.0f, 4.0f, 18.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)13.0f, (float)-11.0f, (float)1.0f));
        PartDefinition armR = torso.m_171599_("armR", CubeListBuilder.m_171558_().m_171514_(0, 80).m_171488_(-3.0f, -11.0f, -3.0f, 5.0f, 28.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(104, 26).m_171488_(-3.0f, 17.0f, -3.0f, 5.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(104, 66).m_171488_(-3.0f, -14.0f, -3.0f, 5.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-13.0f, (float)-11.0f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull RooferEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, RooferEntityAnimation.IDLE, ageInTicks);
        if (!entity.m_20072_()) {
            this.m_267799_(RooferEntityAnimation.WALK, limbSwing, limbSwingAmount, 10.0f, 10.0f);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.root6().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.root6();
    }

    private record ModelParts(ModelPart root6, ModelPart body, ModelPart torso, ModelPart head, ModelPart eyes, ModelPart armR, ModelPart legL, ModelPart twig, ModelPart eye, ModelPart armL) {
    }
}

