/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.SavannariEntityAnimation;
import dev.dracu.bigmobs.entity.SavannariEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class SavannariEntityModel<B extends Mob>
extends HierarchicalModel<SavannariEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "savannari_entity"), "main");
    private final ModelParts parts;

    public SavannariEntityModel(ModelPart root) {
        ModelPart oroot = root.m_171324_("oroot");
        ModelPart body = oroot.m_171324_("body");
        ModelPart belly = body.m_171324_("belly");
        ModelPart sigma = belly.m_171324_("sigma");
        ModelPart neck = sigma.m_171324_("neck");
        ModelPart head = neck.m_171324_("head");
        ModelPart beak = head.m_171324_("beak");
        ModelPart beakUp = beak.m_171324_("beakUp");
        ModelPart beakDown = beak.m_171324_("beakDown");
        ModelPart wings = belly.m_171324_("wings");
        ModelPart wingL = wings.m_171324_("wingL");
        ModelPart wingR = wings.m_171324_("wingR");
        ModelPart thighs = body.m_171324_("thighs");
        ModelPart left = thighs.m_171324_("left");
        ModelPart legL = left.m_171324_("legL");
        ModelPart right = thighs.m_171324_("right");
        ModelPart legR = right.m_171324_("legR");
        this.parts = new ModelParts(body, oroot, head, neck, sigma, belly, beak, legL, legR, left, right, beakDown, beakUp, thighs, wingL, wingR, wings);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition oroot = partdefinition.m_171599_("oroot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = oroot.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition belly = body.m_171599_("belly", CubeListBuilder.m_171558_().m_171514_(63, 33).m_171488_(-6.0f, -7.0f, -10.0f, 12.0f, 12.0f, 19.0f, new CubeDeformation(0.0f)).m_171514_(54, 4).m_171488_(-6.0f, 5.0f, -10.0f, 12.0f, 2.0f, 19.0f, new CubeDeformation(0.0f)).m_171514_(28, 0).m_171480_().m_171488_(-6.0f, 2.4f, -10.0f, 12.0f, 2.0f, 19.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(81, 47).m_171488_(-1.0f, -3.0f, 7.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(104, 53).m_171488_(-5.0f, -5.0f, 9.0f, 7.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-17.0f, (float)2.0f));
        PartDefinition sigma = belly.m_171599_("sigma", CubeListBuilder.m_171558_().m_171514_(30, 50).m_171488_(-5.0f, -7.0f, -5.0f, 10.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)-10.0f));
        PartDefinition neck = sigma.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-2.0f, -14.0f, -3.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(15, 25).m_171488_(-2.0f, -5.0f, -3.0f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(40, 33).m_171488_(-3.0f, -9.0f, -3.1f, 6.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)-1.0f));
        PartDefinition beak = head.m_171599_("beak", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)30.0f, (float)13.0f));
        PartDefinition beakUp = beak.m_171599_("beakUp", CubeListBuilder.m_171558_().m_171514_(16, 59).m_171488_(-2.0f, -1.0f, -4.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-32.0f, (float)-15.0f));
        PartDefinition beakDown = beak.m_171599_("beakDown", CubeListBuilder.m_171558_().m_171514_(16, 55).m_171488_(-2.0f, 0.0f, -4.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-32.0f, (float)-15.0f));
        PartDefinition wings = belly.m_171599_("wings", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition wingL = wings.m_171599_("wingL", CubeListBuilder.m_171558_().m_171514_(42, 27).m_171488_(0.0f, -4.0f, -3.0f, 2.0f, 7.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)2.0f, (float)-1.0f));
        PartDefinition wingR = wings.m_171599_("wingR", CubeListBuilder.m_171558_().m_171514_(42, 27).m_171480_().m_171488_(-2.0f, -4.0f, -3.0f, 2.0f, 7.0f, 15.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-6.0f, (float)2.0f, (float)-1.0f));
        PartDefinition thighs = body.m_171599_("thighs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left = thighs.m_171599_("left", CubeListBuilder.m_171558_().m_171514_(16, 38).m_171488_(-3.1f, -2.0f, -4.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-13.0f, (float)2.0f));
        PartDefinition legL = left.m_171599_("legL", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(3.0f, -10.0f, 1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(1, 27).m_171488_(3.0f, -2.0f, 0.1f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 34).m_171488_(3.0f, -1.0f, -0.9f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)13.0f, (float)-2.0f));
        PartDefinition right = thighs.m_171599_("right", CubeListBuilder.m_171558_().m_171514_(16, 38).m_171480_().m_171488_(-1.9f, -3.0f, -2.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)-12.0f, (float)0.0f));
        PartDefinition legR = right.m_171599_("legR", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171480_().m_171488_(-5.0f, -10.0f, 1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(1, 27).m_171480_().m_171488_(-5.0f, -2.0f, 0.1f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 34).m_171480_().m_171488_(-5.0f, -1.0f, -0.9f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(@NotNull SavannariEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, SavannariEntityAnimation.IDLE, ageInTicks);
        this.m_233381_(entity.diggingAnimationState, SavannariEntityAnimation.DIGGING, ageInTicks);
        this.m_233381_(entity.undigAnimationState, SavannariEntityAnimation.UNDIG, ageInTicks);
        if (!entity.m_20072_()) {
            this.m_267799_(SavannariEntityAnimation.WALK, limbSwing, limbSwingAmount, 4.0f, 4.0f);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.oroot().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.oroot();
    }

    private record ModelParts(ModelPart body, ModelPart oroot, ModelPart head, ModelPart neck, ModelPart sigma, ModelPart belly, ModelPart legL, ModelPart legR, ModelPart beak, ModelPart beakUp, ModelPart beakDown, ModelPart left, ModelPart right, ModelPart thighs, ModelPart wingL, ModelPart wingR, ModelPart wings) {
    }
}

