/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.SeagullEntityAnimation;
import dev.dracu.bigmobs.entity.SeagullEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class SeagullEntityModel<B extends Mob>
extends HierarchicalModel<SeagullEntity> {
    private final ModelPart head;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "seagull_entity"), "main");
    private final ModelParts parts;

    public SeagullEntityModel(ModelPart root) {
        ModelPart sea = root.m_171324_("sea");
        ModelPart body = sea.m_171324_("body");
        ModelPart torso = body.m_171324_("torso");
        ModelPart head = torso.m_171324_("head");
        ModelPart eyeLeft = head.m_171324_("eyeLeft");
        ModelPart lowbeak = head.m_171324_("lowbeak");
        ModelPart twirl = head.m_171324_("twirl");
        ModelPart eyeRight = head.m_171324_("eyeRight");
        ModelPart hurl = head.m_171324_("hurl");
        ModelPart leftWing = torso.m_171324_("leftWing");
        ModelPart rightWing = torso.m_171324_("rightWing");
        ModelPart tails = torso.m_171324_("tails");
        ModelPart leftLeg = body.m_171324_("leftLeg");
        ModelPart toesl = leftLeg.m_171324_("toesl");
        ModelPart rightLeg = body.m_171324_("rightLeg");
        ModelPart toesr = rightLeg.m_171324_("toesr");
        this.head = torso.m_171324_("head");
        this.parts = new ModelParts(sea, body, torso, head, eyeLeft, eyeRight, lowbeak, leftLeg, rightLeg, leftWing, rightWing, hurl, twirl, tails, toesl, toesr);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition sea = partdefinition.m_171599_("sea", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)45.0f, (float)-4.0f));
        PartDefinition body = sea.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -3.0f, -5.0f, 5.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-27.0f, (float)4.0f));
        PartDefinition head = torso.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.4f, -6.0f, -2.0f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 32).m_171488_(-0.4f, -5.0f, -5.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.4f, (float)-1.0f, (float)-4.0f));
        PartDefinition eyeLeft = head.m_171599_("eyeLeft", CubeListBuilder.m_171558_().m_171514_(20, 41).m_171488_(-1.0f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.7f, (float)-4.5f, (float)-0.5f));
        PartDefinition lowbeak = head.m_171599_("lowbeak", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-2.0f, 0.0f, -4.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.6f, (float)-4.0f, (float)-1.0f));
        PartDefinition twirl = head.m_171599_("twirl", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.3f, (float)-4.5f, (float)1.0f));
        PartDefinition cube_r1 = twirl.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(11, 40).m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f));
        PartDefinition eyeRight = head.m_171599_("eyeRight", CubeListBuilder.m_171558_().m_171514_(20, 41).m_171480_().m_171488_(0.0f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)-4.5f, (float)-0.5f));
        PartDefinition hurl = head.m_171599_("hurl", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)1.0f));
        PartDefinition cube_r2 = hurl.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(11, 40).m_171480_().m_171488_(0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-0.1f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        PartDefinition leftWing = torso.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(5, 23).m_171488_(0.0f, -1.0f, 0.0f, 1.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(30, 8).m_171488_(0.0f, -2.0f, 7.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-2.0f, (float)-2.0f));
        PartDefinition rightWing = torso.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(5, 23).m_171480_().m_171488_(-1.0f, -1.0f, 0.0f, 1.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(30, 8).m_171480_().m_171488_(-1.0f, -2.0f, 7.0f, 1.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)-2.0f, (float)-2.0f));
        PartDefinition tails = torso.m_171599_("tails", CubeListBuilder.m_171558_().m_171514_(9, 15).m_171488_(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-3.0f, (float)5.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(42, 23).m_171488_(-0.5f, 0.9f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(6, 8).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-25.0f, (float)5.5f));
        PartDefinition toesl = leftLeg.m_171599_("toesl", CubeListBuilder.m_171558_().m_171514_(40, 7).m_171488_(-1.5f, -0.1f, -2.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(42, 23).m_171488_(-0.5f, 0.9f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(6, 8).m_171488_(-0.5f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-25.0f, (float)5.5f));
        PartDefinition toesr = rightLeg.m_171599_("toesr", CubeListBuilder.m_171558_().m_171514_(40, 7).m_171488_(-1.5f, -0.1f, -2.0f, 3.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull SeagullEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, SeagullEntityAnimation.IDLE, ageInTicks);
        this.m_233381_(entity.barterAnimationState, SeagullEntityAnimation.BARTER, ageInTicks);
        this.m_233381_(entity.floatingAnimationState, SeagullEntityAnimation.SWIMMING, ageInTicks);
        this.m_233381_(entity.flyingAnimationState, SeagullEntityAnimation.FLYING, ageInTicks);
        this.head.f_104203_ = headPitch * 0.005f;
        this.head.f_104204_ = netHeadYaw * 0.008f;
        if (!entity.m_20072_()) {
            this.m_267799_(SeagullEntityAnimation.WALKING, limbSwing, limbSwingAmount, 1.5f, 1.5f);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.body().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.body();
    }

    private record ModelParts(ModelPart body, ModelPart head, ModelPart lowbeak, ModelPart eyeLeft, ModelPart leftWing, ModelPart leftFoot, ModelPart rightFoot, ModelPart rightLeg, ModelPart eyeRight, ModelPart wing, ModelPart rightWing, ModelPart hurl, ModelPart twirl, ModelPart tails, ModelPart toesl, ModelPart toesr) {
    }
}

