/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.dracu.bigmobs.client.animation.WalkerEntityAnimation;
import dev.dracu.bigmobs.entity.WalkerEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Enemy;
import org.jetbrains.annotations.NotNull;

public class WalkerEntityModel<B extends Enemy>
extends HierarchicalModel<WalkerEntity> {
    private final ModelPart head;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("bigmobs", "walker_entity"), "main");
    private final ModelParts parts;

    public WalkerEntityModel(ModelPart root) {
        ModelPart shellroot = root.m_171324_("shellroot");
        ModelPart body = shellroot.m_171324_("body");
        ModelPart torso = body.m_171324_("torso");
        ModelPart head = torso.m_171324_("head");
        ModelPart chomper = head.m_171324_("chomper");
        ModelPart chomperl = chomper.m_171324_("chomperl");
        ModelPart chomperr = chomper.m_171324_("chomperr");
        ModelPart antenna = head.m_171324_("antenna");
        ModelPart antl = antenna.m_171324_("antl");
        ModelPart antr = antenna.m_171324_("antr");
        ModelPart hands = head.m_171324_("hands");
        ModelPart handl = hands.m_171324_("handl");
        ModelPart pinl1 = handl.m_171324_("pinl1");
        ModelPart pinl2 = handl.m_171324_("pinl2");
        ModelPart handr = hands.m_171324_("handr");
        ModelPart pinr1 = handr.m_171324_("pinr1");
        ModelPart pinr2 = handr.m_171324_("pinr2");
        ModelPart disguise = head.m_171324_("disguise");
        ModelPart butt = head.m_171324_("butt");
        ModelPart fins = head.m_171324_("fins");
        ModelPart finl = fins.m_171324_("finl");
        ModelPart finr = fins.m_171324_("finr");
        ModelPart legs = body.m_171324_("legs");
        ModelPart leg1 = legs.m_171324_("leg1");
        ModelPart leg2 = legs.m_171324_("leg2");
        ModelPart leg3 = legs.m_171324_("leg3");
        ModelPart leg6 = legs.m_171324_("leg6");
        ModelPart leg5 = legs.m_171324_("leg5");
        ModelPart leg4 = legs.m_171324_("leg4");
        this.head = torso.m_171324_("head");
        this.parts = new ModelParts(shellroot, body, torso, head, chomper, legs, leg1, leg2, leg3, leg4, leg5, leg6, butt, pinr1, pinr2, pinl1, pinl2, disguise, fins, finl, finr, hands, handl, handr, chomperl, chomperr, antenna, antl, antr);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition shellroot = partdefinition.m_171599_("shellroot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.5f, (float)22.8f, (float)3.5f));
        PartDefinition body = shellroot.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso = body.m_171599_("torso", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.5f, (float)1.0f, (float)-9.5f));
        PartDefinition head = torso.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171488_(-3.0f, -1.0f, -7.0f, 6.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-5.0f, (float)8.0f));
        PartDefinition chomper = head.m_171599_("chomper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)-6.0f));
        PartDefinition chomperl = chomper.m_171599_("chomperl", CubeListBuilder.m_171558_().m_171514_(32, 17).m_171488_(-1.5f, -0.5f, -4.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(12, 28).m_171488_(-0.5f, -0.5f, -4.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)-0.5f, (float)-1.0f));
        PartDefinition chomperr = chomper.m_171599_("chomperr", CubeListBuilder.m_171558_().m_171514_(22, 31).m_171488_(-0.5f, -0.5f, -5.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(26, 17).m_171488_(0.5f, -0.5f, -5.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)-0.5f, (float)0.0f));
        PartDefinition antenna = head.m_171599_("antenna", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)-1.0f, (float)1.0f));
        PartDefinition antl = antenna.m_171599_("antl", CubeListBuilder.m_171558_().m_171514_(33, 32).m_171488_(-0.8f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.3f, (float)0.0f, (float)-8.0f));
        PartDefinition antr = antenna.m_171599_("antr", CubeListBuilder.m_171558_().m_171514_(33, 32).m_171480_().m_171488_(-0.2f, -3.0f, 0.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.7f, (float)0.0f, (float)-8.0f));
        PartDefinition hands = head.m_171599_("hands", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.0f, (float)5.0f, (float)-8.0f));
        PartDefinition handl = hands.m_171599_("handl", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)10.0f, (float)-2.0f, (float)2.0f));
        PartDefinition cube_r1 = handl.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(24, 20).m_171488_(-3.0f, -2.0f, -6.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)2.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition pinl1 = handl.m_171599_("pinl1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)1.0f, (float)-4.0f));
        PartDefinition cube_r2 = pinl1.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(24, 36).m_171488_(-3.0f, -2.5f, -2.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)1.0f, (float)2.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition pinl2 = handl.m_171599_("pinl2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)1.0f, (float)-4.0f));
        PartDefinition cube_r3 = pinl2.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(20, 33).m_171488_(-3.0f, -2.0f, -2.0f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)1.0f, (float)2.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition handr = hands.m_171599_("handr", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)4.0f, (float)-2.0f, (float)2.0f));
        PartDefinition cube_r4 = handr.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(24, 20).m_171480_().m_171488_(1.0f, 0.8612f, -6.9021f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-3.0f, (float)2.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition pinr1 = handr.m_171599_("pinr1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)1.0f, (float)-4.0f));
        PartDefinition cube_r5 = pinr1.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(22, 28).m_171488_(0.0f, -0.9449f, -0.3933f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition pinr2 = handr.m_171599_("pinr2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)0.5f, (float)-4.0f));
        PartDefinition cube_r6 = pinr2.m_171599_("cube_r6", CubeListBuilder.m_171558_().m_171514_(26, 36).m_171488_(3.0f, -1.0463f, -2.3007f, 0.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)0.5f, (float)2.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition disguise = head.m_171599_("disguise", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.7f, (float)0.0f));
        PartDefinition cube_r7 = disguise.m_171599_("cube_r7", CubeListBuilder.m_171558_().m_171514_(1, 42).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.2f, (float)0.0f, (float)1.2217f, (float)0.0f, (float)0.0f));
        PartDefinition butt = head.m_171599_("butt", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-3.0f, -1.0f, 0.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition fins = head.m_171599_("fins", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.0f, (float)5.0f, (float)-8.0f));
        PartDefinition finl = fins.m_171599_("finl", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171480_().m_171488_(0.0f, 0.0f, -1.8f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)10.0f, (float)-4.5f, (float)5.8f));
        PartDefinition finr = fins.m_171599_("finr", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-2.0f, 0.0f, -1.8f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-4.5f, (float)5.8f));
        PartDefinition legs = body.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition leg1 = legs.m_171599_("leg1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)-2.7f, (float)-2.5f));
        PartDefinition cube_r8 = leg1.m_171599_("cube_r8", CubeListBuilder.m_171558_().m_171514_(22, 30).m_171488_(-0.5f, 0.4f, -2.5f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(8, 32).m_171488_(-0.5f, -3.0f, -3.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)2.7f, (float)2.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition leg2 = legs.m_171599_("leg2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)-2.7f, (float)-0.5f));
        PartDefinition cube_r9 = leg2.m_171599_("cube_r9", CubeListBuilder.m_171558_().m_171514_(36, 27).m_171488_(-0.5f, 0.4f, -0.5f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(8, 32).m_171488_(-0.5f, -3.0f, -1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)2.7f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition leg3 = legs.m_171599_("leg3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)6.0f, (float)-2.7f, (float)1.5f));
        PartDefinition cube_r10 = leg3.m_171599_("cube_r10", CubeListBuilder.m_171558_().m_171514_(36, 27).m_171488_(-0.5f, 0.4f, -0.5f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(8, 32).m_171488_(-0.5f, -3.0f, -1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.0f, (float)2.7f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition leg6 = legs.m_171599_("leg6", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-2.7f, (float)1.5f));
        PartDefinition cube_r11 = leg6.m_171599_("cube_r11", CubeListBuilder.m_171558_().m_171514_(36, 27).m_171480_().m_171488_(-0.5f, 0.4f, -0.5f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(8, 32).m_171480_().m_171488_(-0.5f, -3.0f, -1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)2.7f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition leg5 = legs.m_171599_("leg5", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-2.7f, (float)-0.5f));
        PartDefinition cube_r12 = leg5.m_171599_("cube_r12", CubeListBuilder.m_171558_().m_171514_(20, 35).m_171488_(-0.5f, 0.4f, -0.5f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(8, 32).m_171480_().m_171488_(-0.5f, -3.0f, -1.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)2.7f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition leg4 = legs.m_171599_("leg4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-2.7f, (float)-2.5f));
        PartDefinition cube_r13 = leg4.m_171599_("cube_r13", CubeListBuilder.m_171558_().m_171514_(28, 36).m_171488_(-0.5f, 0.4f, -2.5f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(8, 32).m_171480_().m_171488_(-0.5f, -3.0f, -3.0f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)2.7f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.3491f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@NotNull WalkerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, WalkerEntityAnimation.IDLE, ageInTicks);
        this.m_233381_(entity.croakAnimationState, WalkerEntityAnimation.SCRATCH, ageInTicks);
        this.m_233381_(entity.swimAnimationState, WalkerEntityAnimation.SWIM2, ageInTicks);
        this.m_233381_(entity.swimIdleAnimationState, WalkerEntityAnimation.SWIM_IDLE, ageInTicks);
        this.head.f_104203_ = headPitch * 0.003f;
        this.head.f_104204_ = netHeadYaw * 0.003f;
        if (!entity.m_20072_()) {
            this.m_267799_(WalkerEntityAnimation.WALK, limbSwing, limbSwingAmount, 2.0f, 2.0f);
        } else if (entity.m_20072_() && entity.m_20096_()) {
            this.m_267799_(WalkerEntityAnimation.WALK, limbSwing, limbSwingAmount, 2.0f, 2.0f);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.parts.shellroot().m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.parts.shellroot();
    }

    private record ModelParts(ModelPart shellroot, ModelPart body, ModelPart torso, ModelPart head, ModelPart chomper, ModelPart legs, ModelPart leg1, ModelPart leg2, ModelPart leg3, ModelPart leg4, ModelPart leg5, ModelPart leg6, ModelPart butt, ModelPart pinr1, ModelPart pinr2, ModelPart pinl1, ModelPart pinl2, ModelPart disguise, ModelPart fins, ModelPart finl, ModelPart finr, ModelPart hands, ModelPart handl, ModelPart handr, ModelPart chomperl, ModelPart chomperr, ModelPart antenna, ModelPart antl, ModelPart antr) {
    }
}

