/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.dracu.bigmobs.client.model.GoliathEntityModel;
import dev.dracu.bigmobs.client.renderer.layers.SaddleLayer;
import dev.dracu.bigmobs.entity.GoliathEntity;
import dev.dracu.bigmobs.init.BiomeTagInit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.Mob;

public class GoliathRenderer
extends MobRenderer<GoliathEntity, GoliathEntityModel<GoliathEntity>> {
    private static final ResourceLocation TEMPERATE = new ResourceLocation("bigmobs", "textures/entity/goliath/goliath_temperate.png");
    private static final ResourceLocation WARM = new ResourceLocation("bigmobs", "textures/entity/goliath/goliath_warm.png");
    private static final ResourceLocation COLD = new ResourceLocation("bigmobs", "textures/entity/goliath/goliath_cold_retextured.png");
    private static final ResourceLocation SADDLED = new ResourceLocation("bigmobs", "textures/entity/goliath/goliath_saddle.png");

    public GoliathRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new GoliathEntityModel(ctx.m_174023_(GoliathEntityModel.LAYER_LOCATION)), 0.4f);
        this.m_115326_(new SaddleLayer((RenderLayerParent<GoliathEntity, GoliathEntityModel<GoliathEntity>>)this));
    }

    public ResourceLocation getTextureLocation(GoliathEntity entity) {
        int textureType = entity.getTextureType();
        if (textureType == 0) {
            Holder biome = entity.m_9236_().m_204166_(entity.m_20183_());
            textureType = biome.m_203656_(BiomeTagInit.SPAWNS_COLD_GOLIATH) ? 1 : (biome.m_203656_(BiomeTags.f_215809_) ? 3 : 2);
            entity.setTextureType(textureType);
        }
        return switch (textureType) {
            case 1 -> COLD;
            case 2 -> TEMPERATE;
            case 3 -> WARM;
            default -> TEMPERATE;
        };
    }

    public void render(GoliathEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

