/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import com.google.common.collect.Sets;
import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.EntityInit;
import dev.dracu.bigmobs.init.ItemInit;
import dev.dracu.bigmobs.init.SoundInit;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class BordEntity
extends TamableAnimal {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState flyingAnimationState = new AnimationState();
    public final AnimationState partyAnimationState = new AnimationState();
    private static final Set<Item> TAME_FOOD;
    @javax.annotation.Nullable
    private static final EntityDataAccessor<Byte> BORD_FLAGS;
    private static final EntityDataAccessor<Integer> VARIANT;
    @Nullable
    public BlockPos jukebox;
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;

    public BordEntity(EntityType<BordEntity> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 15, false);
        this.m_7105_(false);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(BORD_FLAGS, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag data) {
        super.m_6518_(level, difficulty, spawnType, spawnData, data);
        if (this.getVariant() == 0) {
            this.setVariant(this.randomizeVariant());
        }
        return spawnData;
    }

    public BordEntity(Level level, double x, double y, double z) {
        this((EntityType<BordEntity>)((EntityType)EntityInit.Bord_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public BordEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        if (!serverLevel.m_5776_()) {
            this.m_19998_((ItemLike)ItemInit.BORD_BLOSSOM.get());
        }
        return (AgeableMob)((EntityType)EntityInit.Bord_Entity.get()).m_20615_((Level)serverLevel);
    }

    public void m_6863_(boolean isBaby) {
        super.m_6863_(isBaby);
        this.setVariant(this.randomizeVariant());
    }

    boolean closerThan(BlockPos pPos, int pDistance) {
        return pPos.m_123314_((Vec3i)this.m_20183_(), (double)pDistance);
    }

    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions dimensions = super.m_6972_(pose);
        return this.m_6162_() ? dimensions.m_20388_(0.5f) : dimensions;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        return pOtherAnimal != this && pOtherAnimal instanceof BordEntity;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42206_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42206_}), false));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 15.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        if (this.m_6162_()) {
            this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.5));
        }
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            if (this.isNearJukeboxPlayingMusic()) {
                this.partyAnimationState.m_246184_(true, this.f_19797_);
                this.stopFlyingAndMoveToJukebox();
            } else {
                this.partyAnimationState.m_246184_(false, this.f_19797_);
            }
            this.idleAnimationState.m_246184_(!this.m_20072_() && !this.f_267362_.m_267780_() && this.m_20096_(), this.f_19797_);
            this.flyingAnimationState.m_246184_(!this.m_20096_() && !this.m_20072_(), this.f_19797_);
        }
        super.m_8119_();
    }

    private boolean isNearJukeboxPlayingMusic() {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.m_20183_().m_7918_(-5, -5, -5), (BlockPos)this.m_20183_().m_7918_(5, 5, 5))) {
            BlockState state = this.m_9236_().m_8055_(pos);
            if (!state.m_60713_(Blocks.f_50131_) || !((Boolean)state.m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void stopFlyingAndMoveToJukebox() {
        BlockPos nearestJukebox;
        if (this.isFlying()) {
            this.f_21342_ = new MoveControl((Mob)this);
        }
        if ((nearestJukebox = this.findNearestJukebox()) != null) {
            this.m_21573_().m_26519_((double)nearestJukebox.m_123341_(), (double)nearestJukebox.m_123342_(), (double)nearestJukebox.m_123343_(), 1.0);
        }
    }

    public BlockPos findNearestJukebox() {
        BlockPos closestJukebox = null;
        double closestDistance = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.m_20183_().m_7918_(-10, -10, -10), (BlockPos)this.m_20183_().m_7918_(10, 10, 10))) {
            double distance;
            BlockState state = this.m_9236_().m_8055_(pos);
            if (!state.m_60713_(Blocks.f_50131_) || !((Boolean)state.m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue() || !((distance = this.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)pos))) < closestDistance)) continue;
            closestDistance = distance;
            closestJukebox = pos;
        }
        return closestJukebox;
    }

    public static AttributeSupplier.Builder createBordAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22280_, (double)0.4f);
    }

    public static boolean canSpawn(EntityType<BordEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.bordSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    private int randomizeVariant() {
        Random random = new Random();
        int roll = random.nextInt(150);
        if (roll < 5) {
            return 2;
        }
        if (roll < 70) {
            return 1;
        }
        return 0;
    }

    public boolean isFlying() {
        return !this.m_20096_();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return this.m_6162_() ? pSize.f_20378_ * 0.85f : pSize.f_20378_ * 0.92f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.BORD_TALK.get();
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (float)(!this.m_20096_() && !this.m_20159_() ? 4 : -1) * 0.3f;
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    public void m_8107_() {
        super.m_8107_();
        this.calculateFlapping();
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.m_21824_() && TAME_FOOD.contains(itemstack.m_41720_())) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (TAME_FOOD.contains(itemstack.m_41720_())) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_21828_(player);
                        this.f_21344_.m_26573_();
                        this.m_6710_(null);
                        this.m_21839_(true);
                        this.m_9236_().m_7605_((Entity)this, (byte)7);
                    } else {
                        this.m_9236_().m_7605_((Entity)this, (byte)6);
                    }
                }
                this.m_21530_();
                return InteractionResult.SUCCESS;
            }
            return super.m_6071_(player, hand);
        }
        if (this.m_21824_() && !this.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND && !TAME_FOOD.contains(itemstack.m_41720_())) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_()) {
            if (TAME_FOOD.contains(itemstack.m_41720_()) && this.m_21223_() < this.m_21233_() && this.m_21824_()) {
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            this.m_146852_(GameEvent.f_157806_, (Entity)this);
            return InteractionResult.SUCCESS;
        }
        if (TAME_FOOD.contains(itemstack.m_41720_())) {
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    static {
        BORD_FLAGS = SynchedEntityData.m_135353_(BordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        VARIANT = SynchedEntityData.m_135353_(BordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        TAME_FOOD = Sets.newHashSet((Object[])new Item[]{Items.f_42404_, Items.f_42578_, Items.f_42577_, Items.f_42733_, Items.f_271133_, Items.f_276594_, Items.f_42406_, Items.f_42410_});
    }
}

