/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import dev.dracu.bigmobs.entity.ai.EggplantAi;
import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.EntityInit;
import dev.dracu.bigmobs.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RiderShieldingMount;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public class EnormousEggplantEntity
extends AbstractHorse
implements PlayerRideableJumping,
RiderShieldingMount,
Saddleable {
    public static final Ingredient TEMPTATION_ITEM;
    private static final EntityDataAccessor<Integer> SADDLE_COLOR;
    public static final int DASH_COOLDOWN_TICKS = 55;
    public static final int MAX_HEAD_Y_ROT = 30;
    private static final float RUNNING_SPEED_BONUS = 0.1f;
    private static final float DASH_VERTICAL_MOMENTUM = 1.4285f;
    private static final float DASH_HORIZONTAL_MOMENTUM = 22.2222f;
    private static final int DASH_MINIMUM_DURATION_TICKS = 5;
    private static final int SITDOWN_DURATION_TICKS = 40;
    private static final int STANDUP_DURATION_TICKS = 52;
    private static final int IDLE_MINIMAL_DURATION_TICKS = 80;
    private static final float SITTING_HEIGHT_DIFFERENCE = 1.43f;
    public static final EntityDataAccessor<Boolean> DASH;
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState sittingAnimationState = new AnimationState();
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState sitPoseAnimationState = new AnimationState();
    public final AnimationState sitUpAnimationState = new AnimationState();
    public final AnimationState dashAnimationState = new AnimationState();
    private static final EntityDimensions SITTING_DIMENSIONS;
    private int dashCooldown = 0;
    private int idleAnimationTimeout = 0;
    private static final EntityDataAccessor<Boolean> SITTING;

    public EnormousEggplantEntity(EntityType<EnormousEggplantEntity> type, Level level) {
        super(type, level);
        this.m_274367_(2.0f);
        this.f_21342_ = new EggplantMoveControl();
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.m_21573_();
        groundpathnavigation.m_7008_(true);
        groundpathnavigation.m_255224_(true);
    }

    public EnormousEggplantEntity(Level level, double x, double y, double z) {
        this((EntityType<EnormousEggplantEntity>)((EntityType)EntityInit.EnormousEggplant_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public EnormousEggplantEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return new EnormousEggplantEntity((Level)level, this.m_20183_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42533_}), false));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(!this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        if (this.m_9236_().m_5776_()) {
            this.sittingAnimationState.m_246184_(!this.m_20072_() && this.isSitting(), this.f_19797_);
        }
        if (this.isDashing() && this.dashCooldown < 50 && (this.m_20096_() || this.m_20069_() || this.m_20159_())) {
            this.setDashing(false);
        }
        if (this.dashCooldown > 0) {
            --this.dashCooldown;
            if (this.dashCooldown == 0) {
                this.m_9236_().m_5594_((Player)null, this.m_20183_(), SoundEvents.f_244032_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.refuseToMove()) {
            this.clampHeadRotationToBody((Entity)this, 30.0f);
        }
        if (this.isCamelSitting() && this.m_20069_()) {
            this.standUpInstantly();
        }
        super.m_8119_();
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(900) + 700;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isCamelVisuallySitting()) {
            this.sitUpAnimationState.m_216973_();
            this.dashAnimationState.m_216973_();
            this.idleAnimationState.m_216973_();
            if (this.isVisuallySittingDown()) {
                this.sitAnimationState.m_216982_(this.f_19797_);
                this.sitPoseAnimationState.m_216973_();
            } else {
                this.sitAnimationState.m_216973_();
                this.sitPoseAnimationState.m_216982_(this.f_19797_);
            }
        } else {
            this.sitAnimationState.m_216973_();
            this.sitPoseAnimationState.m_216973_();
            this.dashAnimationState.m_246184_(this.isDashing(), this.f_19797_);
            this.sitUpAnimationState.m_246184_(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.f_19797_);
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING && !this.dashAnimationState.m_216984_() ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.refuseToMove() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            pTravelVector = pTravelVector.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(pTravelVector);
    }

    protected void m_274498_(Player pPlayer, Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        if (pPlayer.f_20902_ > 0.0f && this.isCamelSitting() && !this.isInPoseTransition()) {
            this.standUp();
        }
    }

    public boolean refuseToMove() {
        return this.isCamelSitting() || this.isInPoseTransition();
    }

    protected float m_245547_(Player pPlayer) {
        float f = pPlayer.m_20142_() && this.m_245614_() == 0 ? 0.1f : 0.0f;
        return (float)this.m_21133_(Attributes.f_22279_) + f;
    }

    protected Vec2 m_274391_(LivingEntity pEntity) {
        return this.refuseToMove() ? new Vec2(this.m_146909_(), this.m_146908_()) : super.m_274391_(pEntity);
    }

    protected Vec3 m_274312_(Player pPlayer, Vec3 pTravelVector) {
        return this.refuseToMove() ? Vec3.f_82478_ : super.m_274312_(pPlayer, pTravelVector);
    }

    public boolean m_7132_() {
        return !this.refuseToMove() && super.m_7132_();
    }

    public void m_7888_(int pJumpPower) {
        if (this.m_6254_() && this.dashCooldown <= 0 && this.m_20096_()) {
            super.m_7888_(pJumpPower);
        }
    }

    public boolean m_264410_() {
        return true;
    }

    protected void m_245980_(float pPlayerJumpPendingScale, Vec3 pTravelVector) {
        double d0 = this.m_21133_(Attributes.f_22288_) * (double)this.m_20098_() + (double)this.m_285755_();
        this.m_246865_(this.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)(22.2222f * pPlayerJumpPendingScale) * this.m_21133_(Attributes.f_22279_) * (double)this.m_6041_()).m_82520_(0.0, (double)(1.4285f * pPlayerJumpPendingScale) * d0, 0.0));
        this.dashCooldown = 55;
        this.setDashing(true);
        this.f_19812_ = true;
    }

    public boolean isDashing() {
        return (Boolean)this.f_19804_.m_135370_(DASH);
    }

    public void setDashing(boolean pDashing) {
        this.f_19804_.m_135381_(DASH, (Object)pDashing);
    }

    public boolean isPanicking() {
        return this.m_6274_().m_21876_(MemoryModuleType.f_217768_, MemoryStatus.VALUE_PRESENT);
    }

    public void m_7199_(int pJumpPower) {
        this.m_5496_(SoundEvents.f_244538_, 1.0f, 1.0f);
        this.setDashing(true);
    }

    public void m_8012_() {
    }

    public int m_245614_() {
        return this.dashCooldown;
    }

    public boolean m_6898_(ItemStack pStack) {
        return TEMPTATION_ITEM.test(pStack);
    }

    protected void m_7880_(float pDistance) {
        if (pDistance > 6.0f && this.isCamelSitting() && !this.isInPoseTransition()) {
            this.standUp();
        }
    }

    protected boolean m_5994_(Player pPlayer, ItemStack pStack) {
        SoundEvent soundevent;
        boolean flag2;
        boolean flag1;
        boolean flag;
        if (!this.m_6898_(pStack)) {
            return false;
        }
        boolean bl = flag = this.m_21223_() < this.m_21233_();
        if (flag) {
            this.m_5634_(2.0f);
        }
        boolean bl2 = flag1 = this.m_30614_() && this.m_146764_() == 0 && this.m_5957_();
        if (flag1) {
            this.m_27595_(pPlayer);
        }
        if (flag2 = this.m_6162_()) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.m_9236_().f_46443_) {
                this.m_146758_(10);
            }
        }
        if (!(flag || flag1 || flag2)) {
            return false;
        }
        if (!this.m_20067_() && (soundevent = this.m_7872_()) != null) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundevent, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        return true;
    }

    protected boolean m_245259_() {
        return false;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        if (pOtherAnimal != this && pOtherAnimal instanceof EnormousEggplantEntity) {
            EnormousEggplantEntity entity = (EnormousEggplantEntity)pOtherAnimal;
            if (this.m_30628_() && entity.m_30628_()) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected SoundEvent m_7872_() {
        return SoundEvents.f_243713_;
    }

    protected void m_6475_(DamageSource pDamageSource, float pDamageAmount) {
        this.standUpInstantly();
        super.m_6475_(pDamageSource, pDamageAmount);
    }

    protected void m_19956_(Entity pPassenger, Entity.MoveFunction pCallback) {
        int i = this.m_20197_().indexOf(pPassenger);
        if (i >= 0) {
            boolean flag = i == 0;
            float f = 0.5f;
            float f1 = (float)(this.m_213877_() ? (double)0.01f : this.getBodyAnchorAnimationYOffset(flag, 0.0f) + pPassenger.m_6049_());
            if (this.m_20197_().size() > 1) {
                if (!flag) {
                    f = -0.7f;
                }
                if (pPassenger instanceof Animal) {
                    f += 0.2f;
                }
            }
            Vec3 vec3 = new Vec3(0.0, 0.0, -0.1).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            pCallback.m_20372_(pPassenger, this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vec3.f_82481_);
            this.clampRotation(pPassenger);
        }
    }

    private double getBodyAnchorAnimationYOffset(boolean pSitting, float pPartialTick) {
        double d0 = this.m_6048_();
        float f = this.m_6134_() * 1.43f;
        float f1 = f - this.m_6134_() * 0.2f;
        float f2 = f - f1;
        boolean flag = this.isInPoseTransition();
        boolean flag1 = this.isCamelSitting();
        if (flag) {
            float f3;
            int j;
            int i;
            int n = i = flag1 ? 40 : 52;
            if (flag1) {
                j = 28;
                f3 = pSitting ? 0.5f : 0.1f;
            } else {
                j = pSitting ? 24 : 32;
                f3 = pSitting ? 0.6f : 0.35f;
            }
            float f4 = Mth.m_14036_((float)((float)this.getPoseTime() + pPartialTick), (float)0.0f, (float)i);
            boolean flag2 = f4 < (float)j;
            float f5 = flag2 ? f4 / (float)j : (f4 - (float)j) / (float)(i - j);
            float f6 = f - f3 * f1;
            d0 += flag1 ? (double)Mth.m_14179_((float)f5, (float)(flag2 ? f : f6), (float)(flag2 ? f6 : f2)) : (double)Mth.m_14179_((float)f5, (float)(flag2 ? f2 - f : f2 - f6), (float)(flag2 ? f2 - f6 : 0.0f));
        }
        if (flag1 && !flag) {
            d0 += (double)f2;
        }
        return d0;
    }

    public Vec3 m_245894_(float pPartialTick) {
        return new Vec3(0.0, this.getBodyAnchorAnimationYOffset(true, pPartialTick) - (double)(0.2f * this.m_6134_()), (double)(this.m_20205_() * 0.56f));
    }

    public double m_6048_() {
        return this.m_6972_((Pose)(this.isCamelSitting() ? Pose.SITTING : Pose.STANDING)).f_20378_ - (this.m_6162_() ? 0.35f : 0.6f);
    }

    public void m_7340_(Entity pEntityToUpdate) {
        if (this.m_6688_() != pEntityToUpdate) {
            this.clampRotation(pEntityToUpdate);
        }
    }

    private void clampRotation(Entity pEntity) {
        pEntity.m_5618_(this.m_146908_());
        float f = pEntity.m_146908_();
        float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
        float f2 = Mth.m_14036_((float)f1, (float)-160.0f, (float)160.0f);
        pEntity.f_19859_ += f2 - f1;
        float f3 = f + f2 - f1;
        pEntity.m_146922_(f3);
        pEntity.m_5616_(f3);
    }

    private void clampHeadRotationToBody(Entity pEntity, float p_265541_) {
        float f = pEntity.m_6080_();
        float f1 = Mth.m_14177_((float)(this.f_20883_ - f));
        float f2 = Mth.m_14036_((float)Mth.m_14177_((float)(this.f_20883_ - f)), (float)(-p_265541_), (float)p_265541_);
        float f3 = f + f1 - f2;
        pEntity.m_5616_(f3);
    }

    public int m_8085_() {
        return 30;
    }

    protected boolean m_7310_(Entity pPassenger) {
        return this.m_20197_().size() <= 1;
    }

    @javax.annotation.Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (!this.m_20197_().isEmpty() && this.m_6254_() && (entity = (Entity)this.m_20197_().get(0)) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public boolean isCamelSitting() {
        return (Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public boolean isCamelVisuallySitting() {
        return this.getPoseTime() < 0L != this.isCamelSitting();
    }

    public boolean isInPoseTransition() {
        long i = this.getPoseTime();
        return i < (long)(this.isCamelSitting() ? 40 : 52);
    }

    private boolean isVisuallySittingDown() {
        return this.isCamelSitting() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public void sitDown() {
        if (!this.isCamelSitting()) {
            this.m_5496_((SoundEvent)SoundInit.EGGPLANT_SIT.get(), 1.0f, 1.0f);
            this.m_20124_(Pose.SITTING);
            this.resetLastPoseChangeTick(-this.m_9236_().m_46467_());
        }
    }

    public void standUp() {
        if (this.isCamelSitting()) {
            this.m_5496_((SoundEvent)SoundInit.EGGPLANT_SIT.get(), 1.0f, 1.0f);
            this.m_20124_(Pose.STANDING);
            this.resetLastPoseChangeTick(this.m_9236_().m_46467_());
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.EGGPLANT_IDLE.get();
    }

    public void standUpInstantly() {
        this.m_20124_(Pose.STANDING);
        this.resetLastPoseChangeTickToFullStand(this.m_9236_().m_46467_());
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long pLastPoseChangeTick) {
        this.f_19804_.m_135381_(LAST_POSE_CHANGE_TICK, (Object)pLastPoseChangeTick);
    }

    private void resetLastPoseChangeTickToFullStand(long pLastPoseChangedTick) {
        this.resetLastPoseChangeTick(Math.max(0L, pLastPoseChangedTick - 52L - 1L));
    }

    public long getPoseTime() {
        return this.m_9236_().m_46467_() - Math.abs((Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK));
    }

    public SoundEvent m_246265_() {
        return SoundEvents.f_12236_;
    }

    public void setSaddleColor(DyeColor color) {
        this.f_19804_.m_135381_(SADDLE_COLOR, (Object)color.m_41060_());
    }

    public DyeColor getSaddleColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(SADDLE_COLOR)));
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (!this.f_19803_ && DASH.equals(pKey)) {
            this.dashCooldown = this.dashCooldown == 0 ? 55 : this.dashCooldown;
        }
        super.m_7350_(pKey);
    }

    protected BodyRotationControl m_7560_() {
        return new CamelBodyRotationControl(this);
    }

    public boolean m_30614_() {
        return true;
    }

    public void m_213583_(Player pPlayer) {
        if (!this.m_9236_().f_46443_) {
            pPlayer.m_6658_((AbstractHorse)this, (Container)this.f_30520_);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        DyeItem dyeItem;
        DyeColor newColor;
        Item item;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.m_6254_() && (item = itemstack.m_41720_()) instanceof DyeItem && (newColor = (dyeItem = (DyeItem)item).m_41089_()) != this.getSaddleColor()) {
            this.setSaddleColor(newColor);
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (pPlayer.m_36341_() && !this.m_6162_()) {
            this.m_213583_(pPlayer);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        InteractionResult interactionresult = itemstack.m_41647_(pPlayer, (LivingEntity)this, pHand);
        if (interactionresult.m_19077_()) {
            return interactionresult;
        }
        if (this.m_6898_(itemstack)) {
            return this.m_30580_(pPlayer, itemstack);
        }
        if (this.m_20197_().size() < 2 && !this.m_6162_()) {
            this.m_6835_(pPlayer);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public static AttributeSupplier.Builder createEnormousEggplantAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.08f).m_22268_(Attributes.f_22276_, 42.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22288_, 0.2696969869694201);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        EggplantAi.initMemories(this, pLevel.m_213780_());
        this.resetLastPoseChangeTickToFullStand(pLevel.m_6018_().m_46467_());
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public static boolean canSpawn(EntityType<EnormousEggplantEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.enormouseggplantSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return level.m_8055_(position.m_7495_()).m_60713_(Blocks.f_50440_);
    }

    protected Brain.Provider<EnormousEggplantEntity> m_5490_() {
        return EggplantAi.brainProvider();
    }

    protected Brain<?> m_8075_(Dynamic<?> pDynamic) {
        return EggplantAi.makeBrain((Brain<EnormousEggplantEntity>)this.m_5490_().m_22073_(pDynamic));
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return pPose == Pose.SITTING ? SITTING_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(pPose);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ - 0.1f;
    }

    public double m_262813_() {
        return 0.5;
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("eggplantBrain");
        Brain brain = this.m_6274_();
        brain.m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("eggplantActivityUpdate");
        EggplantAi.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSitting(tag.m_128471_("isSitting"));
        tag.m_128356_("LastPoseTick", ((Long)this.f_19804_.m_135370_(LAST_POSE_CHANGE_TICK)).longValue());
        if (tag.m_128441_("SaddleColor")) {
            this.setSaddleColor(DyeColor.m_41053_((int)tag.m_128451_("SaddleColor")));
        } else {
            this.setSaddleColor(DyeColor.BROWN);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("SaddleColor", this.getSaddleColor().m_41060_());
        tag.m_128379_("isSitting", this.isSitting());
        long i = tag.m_128454_("LastPoseTick");
        if (i < 0L) {
            this.m_20124_(Pose.SITTING);
        }
        this.resetLastPoseChangeTick(i);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SITTING, (Object)false);
        this.f_19804_.m_135372_(DASH, (Object)false);
        this.f_19804_.m_135372_(LAST_POSE_CHANGE_TICK, (Object)0L);
        this.f_19804_.m_135372_(SADDLE_COLOR, (Object)DyeColor.BROWN.m_41060_());
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public Team m_5647_() {
        return super.m_5647_();
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    static {
        SADDLE_COLOR = SynchedEntityData.m_135353_(EnormousEggplantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SITTING = SynchedEntityData.m_135353_(EnormousEggplantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        TEMPTATION_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42533_});
        DASH = SynchedEntityData.m_135353_(Camel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        LAST_POSE_CHANGE_TICK = SynchedEntityData.m_135353_(Camel.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
        SITTING_DIMENSIONS = EntityDimensions.m_20395_((float)2.5f, (float)2.4f);
    }

    class EggplantMoveControl
    extends MoveControl {
        public EggplantMoveControl() {
            super((Mob)EnormousEggplantEntity.this);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !EnormousEggplantEntity.this.m_21523_() && EnormousEggplantEntity.this.isCamelSitting() && !EnormousEggplantEntity.this.isInPoseTransition()) {
                EnormousEggplantEntity.this.standUp();
            }
            super.m_8126_();
        }
    }

    class CamelBodyRotationControl
    extends BodyRotationControl {
        public CamelBodyRotationControl(EnormousEggplantEntity entity) {
            super((Mob)entity);
        }

        public void m_8121_() {
            if (!EnormousEggplantEntity.this.refuseToMove()) {
                super.m_8121_();
            }
        }
    }
}

