/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import com.google.common.collect.ImmutableList;
import dev.dracu.bigmobs.entity.ai.GoliathAi;
import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.BiomeTagInit;
import dev.dracu.bigmobs.init.EntityInit;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GoliathEntity
extends Frog
implements ItemSteerable,
Saddleable {
    public static final Ingredient TEMPTATION_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42518_});
    private static final EntityDataAccessor<Boolean> DATA_SADDLE_ID;
    private static final EntityDataAccessor<Integer> DATA_BOOST_TIME;
    private final ItemBasedSteering steering;
    private static final EntityDataAccessor<FrogVariant> DATA_VARIANT_ID;
    protected static final ImmutableList<SensorType<? extends Sensor<? super GoliathEntity>>> SENSOR_TYPES;
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES;
    private static final EntityDataAccessor<OptionalInt> DATA_TONGUE_TARGET_ID;
    private static final int FROG_FALL_DAMAGE_REDUCTION = 5;
    public final AnimationState jumpAnimationState = new AnimationState();
    public final AnimationState croakAnimationState = new AnimationState();
    public final AnimationState tongueAnimationState = new AnimationState();
    public final AnimationState swimIdleAnimationState = new AnimationState();
    private int textureType = 0;

    public GoliathEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21365_ = new GoliathLookControl((Mob)this);
        this.m_21441_(BlockPathTypes.WATER, 4.0f);
        this.m_21441_(BlockPathTypes.TRAPDOOR, -1.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.m_274367_(1.0f);
        this.steering = new ItemBasedSteering(this.f_19804_, DATA_BOOST_TIME, DATA_SADDLE_ID);
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (this.m_6254_() && (entity = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity;
            if (player.m_21205_().m_150930_(Items.f_42518_) || player.m_21206_().m_150930_(Items.f_42518_)) {
                return player;
            }
            if (player.m_21205_().m_150930_(Items.f_42204_) || player.m_21206_().m_150930_(Items.f_42204_)) {
                return player;
            }
            if (player.m_21205_().m_150930_(Items.f_42713_) || player.m_21206_().m_150930_(Items.f_42713_)) {
                return player;
            }
        }
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TONGUE_TARGET_ID, (Object)OptionalInt.empty());
        this.f_19804_.m_135372_(DATA_SADDLE_ID, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("TextureType", this.textureType);
        this.steering.m_20847_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.steering.m_20852_(compound);
        if (compound.m_128441_("TextureType")) {
            this.textureType = compound.m_128451_("TextureType");
        }
    }

    public int getTextureType() {
        return this.textureType;
    }

    public void setTextureType(int textureType) {
        this.textureType = textureType;
    }

    public void initializeTextureType() {
        if (this.textureType == 0 && !this.m_9236_().f_46443_) {
            Biome biome = (Biome)this.m_9236_().m_204166_(this.m_20183_()).m_203334_();
            float temperature = biome.m_47554_();
            this.textureType = (double)temperature < 0.3 ? 1 : ((double)temperature < 0.8 ? 2 : 3);
        }
    }

    public void m_218536_() {
        this.f_19804_.m_135381_(DATA_TONGUE_TARGET_ID, (Object)OptionalInt.empty());
    }

    public Optional<Entity> m_218538_() {
        IntStream var10000 = ((OptionalInt)this.f_19804_.m_135370_(DATA_TONGUE_TARGET_ID)).stream();
        Level var10001 = this.m_9236_();
        Objects.requireNonNull(var10001);
        return var10000.mapToObj(arg_0 -> ((Level)var10001).m_6815_(arg_0)).filter(Objects::nonNull).findFirst();
    }

    public void m_218481_(Entity pTongueTarget) {
        this.f_19804_.m_135381_(DATA_TONGUE_TARGET_ID, (Object)OptionalInt.of(pTongueTarget.m_19879_()));
    }

    public int m_21529_() {
        return 35;
    }

    public int m_8085_() {
        return 5;
    }

    public GoliathEntity(Level level, double x, double y, double z) {
        this((EntityType<? extends Animal>)((EntityType)EntityInit.Goliath_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public GoliathEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return new GoliathEntity((Level)level, this.m_20183_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.5, 1));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, (double)1.7f));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42518_}), false));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public boolean m_6040_() {
        return true;
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("frogBrain");
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("frogActivityUpdate");
        GoliathAi.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.swimIdleAnimationState.m_246184_(this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        super.m_8119_();
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (f_19806_.equals(pKey)) {
            Pose $$1 = this.m_20089_();
            if ($$1 == Pose.LONG_JUMPING) {
                this.jumpAnimationState.m_216977_(this.f_19797_);
            } else {
                this.jumpAnimationState.m_216973_();
            }
            if ($$1 == Pose.CROAKING) {
                this.croakAnimationState.m_216977_(this.f_19797_);
            } else {
                this.croakAnimationState.m_216973_();
            }
            if ($$1 == Pose.USING_TONGUE) {
                this.tongueAnimationState.m_216977_(this.f_19797_);
            } else {
                this.tongueAnimationState.m_216973_();
            }
            if (DATA_BOOST_TIME.equals(pKey) && this.m_9236_().f_46443_) {
                this.steering.m_20844_();
            }
        }
        super.m_7350_(pKey);
    }

    protected void m_267689_(float pPartialTick) {
        float $$2 = this.jumpAnimationState.m_216984_() ? 0.0f : Math.min(pPartialTick * 25.0f, 1.0f);
        this.f_267362_.m_267566_($$2, 0.4f);
    }

    public boolean m_6162_() {
        return false;
    }

    public void m_6863_(boolean pBaby) {
    }

    public void m_27563_(ServerLevel pLevel, Animal pMate) {
        this.m_277117_(pLevel, pMate, null);
        this.m_6274_().m_21879_(MemoryModuleType.f_217767_, (Object)Unit.INSTANCE);
    }

    public static AttributeSupplier.Builder createGoliathAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22288_, 4.0);
    }

    public static boolean canSpawn(EntityType<GoliathEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.goliathSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return Frog.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public boolean m_6746_() {
        return false;
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_();
    }

    public void m_5853_(@Nullable SoundSource pSource) {
        this.steering.m_20849_(true);
        if (pSource != null) {
            this.m_9236_().m_6269_((Player)null, (Entity)this, SoundEvents.f_12236_, pSource, 0.5f, 1.0f);
        }
    }

    public boolean m_6254_() {
        return this.steering.m_20851_();
    }

    public boolean m_6063_() {
        return false;
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    protected int m_5639_(float pFallDistance, float pDamageMultiplier) {
        return super.m_5639_(pFallDistance, pDamageMultiplier) - 5;
    }

    public Vec3 m_7688_(LivingEntity pLivingEntity) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.m_7688_(pLivingEntity);
        }
        int[][] aint = DismountHelper.m_38467_((Direction)direction);
        BlockPos blockpos = this.m_20183_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (Pose pose : pLivingEntity.m_7431_()) {
            AABB aabb = pLivingEntity.m_21270_(pose);
            int[][] var9 = aint;
            int var10 = aint.length;
            for (int var11 = 0; var11 < var10; ++var11) {
                int[] aint1 = var9[var11];
                blockpos$mutableblockpos.m_122178_(blockpos.m_123341_() + aint1[0], blockpos.m_123342_(), blockpos.m_123343_() + aint1[1]);
                double d0 = this.m_9236_().m_45573_((BlockPos)blockpos$mutableblockpos);
                if (!DismountHelper.m_38439_((double)d0)) continue;
                Vec3 vec3 = Vec3.m_82514_((Vec3i)blockpos$mutableblockpos, (double)d0);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)pLivingEntity, (AABB)aabb.m_82383_(vec3))) continue;
                pLivingEntity.m_20124_(pose);
                return vec3;
            }
        }
        return super.m_7688_(pLivingEntity);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    protected void m_274498_(Player pPlayer, Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        this.m_19915_(pPlayer.m_146908_(), pPlayer.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        this.steering.m_274606_();
    }

    protected Vec3 m_274312_(Player pPlayer, Vec3 pTravelVector) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float m_245547_(Player pPlayer) {
        return (float)(this.m_21133_(Attributes.f_22279_) * 0.05 * (double)this.steering.m_274439_());
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public static boolean m_218532_(LivingEntity pEntity) {
        Slime $$1;
        if (pEntity instanceof Slime && ($$1 = (Slime)pEntity).m_33632_() != 1) {
            return false;
        }
        return pEntity.m_6095_().m_204039_(EntityTypeTags.f_215847_);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        boolean flag = this.m_6898_(pPlayer.m_21120_(pHand));
        if (!flag && this.m_6254_() && !this.m_20160_() && !pPlayer.m_36341_()) {
            if (!this.m_9236_().f_46443_) {
                pPlayer.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
        if (!interactionresult.m_19077_()) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            return itemstack.m_150930_(Items.f_42450_) ? itemstack.m_41647_(pPlayer, (LivingEntity)this, pHand) : InteractionResult.PASS;
        }
        return interactionresult;
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new FrogPathNavigation(this, pLevel);
    }

    public boolean m_6898_(ItemStack pStack) {
        return TEMPTATION_ITEM.test(pStack);
    }

    public static boolean m_218511_(EntityType<? extends Animal> pAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_215827_) && GoliathEntity.m_186209_((BlockAndTintGetter)pLevel, (BlockPos)pPos);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setTextureType(this.textureType);
        if (this.textureType == 0) {
            Holder biome = this.m_9236_().m_204166_(this.m_20183_());
            this.textureType = biome.m_203656_(BiomeTagInit.SPAWNS_COLD_GOLIATH) ? 1 : (biome.m_203656_(BiomeTags.f_215809_) ? 3 : 2);
            this.setTextureType(this.textureType);
        }
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    static {
        SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)SensorType.f_217823_, (Object)SensorType.f_217822_, (Object)SensorType.f_217824_);
        MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_148199_, (Object)MemoryModuleType.f_148200_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_148196_, (Object)MemoryModuleType.f_148197_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_148198_, MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_148194_, MemoryModuleType.f_217766_, MemoryModuleType.f_217767_, MemoryModuleType.f_217768_, MemoryModuleType.f_238182_});
        DATA_VARIANT_ID = SynchedEntityData.m_135353_(Frog.class, (EntityDataSerializer)EntityDataSerializers.f_238115_);
        DATA_TONGUE_TARGET_ID = SynchedEntityData.m_135353_(Frog.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
        DATA_SADDLE_ID = SynchedEntityData.m_135353_(Pig.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        DATA_BOOST_TIME = SynchedEntityData.m_135353_(Pig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }

    class GoliathLookControl
    extends LookControl {
        GoliathLookControl(Mob pMob) {
            super(pMob);
        }

        protected boolean m_8106_() {
            return GoliathEntity.this.m_218538_().isEmpty();
        }
    }

    static class FrogPathNavigation
    extends AmphibiousPathNavigation {
        FrogPathNavigation(GoliathEntity pMob, Level pLevel) {
            super((Mob)pMob, pLevel);
        }

        public boolean m_264193_(BlockPathTypes pPathType) {
            return pPathType != BlockPathTypes.WATER_BORDER && super.m_264193_(pPathType);
        }

        protected PathFinder m_5532_(int pMaxVisitedNodes) {
            this.f_26508_ = new GoliathNodeEvaluator(true);
            this.f_26508_.m_77351_(true);
            return new PathFinder(this.f_26508_, pMaxVisitedNodes);
        }
    }

    private static class GoliathNodeEvaluator
    extends AmphibiousNodeEvaluator {
        private final BlockPos.MutableBlockPos belowPos = new BlockPos.MutableBlockPos();

        public GoliathNodeEvaluator(boolean p_218548_) {
            super(p_218548_);
        }

        public Node m_7171_() {
            return !this.f_77313_.m_20069_() ? super.m_7171_() : this.m_230631_(new BlockPos(Mth.m_14107_((double)this.f_77313_.m_20191_().f_82288_), Mth.m_14107_((double)this.f_77313_.m_20191_().f_82289_), Mth.m_14107_((double)this.f_77313_.m_20191_().f_82290_)));
        }

        public BlockPathTypes m_8086_(BlockGetter p_218551_, int p_218552_, int p_218553_, int p_218554_) {
            this.belowPos.m_122178_(p_218552_, p_218553_ - 1, p_218554_);
            BlockState $$4 = p_218551_.m_8055_((BlockPos)this.belowPos);
            return $$4.m_204336_(BlockTags.f_215837_) ? BlockPathTypes.OPEN : super.m_8086_(p_218551_, p_218552_, p_218553_, p_218554_);
        }
    }
}

