/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import dev.dracu.bigmobs.entity.ai.GravelettAttackGoal;
import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.EntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class GravelettEntity
extends Monster
implements Enemy {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(GravelettEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public GravelettEntity(EntityType<GravelettEntity> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        if (!((Boolean)BigMobsConfig.COMMON.gravelettSpawnEnabled.get()).booleanValue() && !this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    public GravelettEntity(Level level, double x, double y, double z) {
        this((EntityType<GravelettEntity>)((EntityType)EntityInit.Gravelett_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public GravelettEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GravelettAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.5, 26.0f));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return this.m_6162_() ? pSize.f_20378_ * 0.75f : pSize.f_20378_ * 0.72f;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(!this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        if (this.m_9236_().m_5776_() && this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 50;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
        if (!((Boolean)BigMobsConfig.COMMON.gravelettSpawnEnabled.get()).booleanValue()) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    public static AttributeSupplier.Builder createGravelettAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, (double)0.22f).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    public static boolean canSpawn(EntityType<GravelettEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.gravelettSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return Mob.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    public boolean m_6785_(double distance) {
        return false;
    }
}

