/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import com.google.common.collect.Sets;
import dev.dracu.bigmobs.entity.ai.FollowGroupGoal;
import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.EntityInit;
import dev.dracu.bigmobs.init.ItemInit;
import dev.dracu.bigmobs.init.SoundInit;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NanamigoEntity
extends TamableAnimal {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState floatingAnimationState = new AnimationState();
    public final AnimationState flyingAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState meetAnimationState = new AnimationState();
    private static final Set<Item> TAME_FOOD = Sets.newHashSet((Object[])new Item[]{Items.f_42404_, Items.f_42578_, Items.f_42526_, Items.f_42529_, Items.f_42528_, (Item)ItemInit.PLANTAIN.get()});
    private int callCooldown = 0;
    private int playCooldown = 0;

    public NanamigoEntity(EntityType<NanamigoEntity> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 14, false);
    }

    public NanamigoEntity(Level level, double x, double y, double z) {
        this((EntityType<NanamigoEntity>)((EntityType)EntityInit.Nanamigo_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public NanamigoEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    public boolean m_7848_(@NotNull Animal pOtherAnimal) {
        return pOtherAnimal != this && pOtherAnimal instanceof NanamigoEntity;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42528_);
    }

    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions dimensions = super.m_6972_(pose);
        return this.m_6162_() ? dimensions.m_20388_(0.7f) : dimensions;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        NanamigoEntity baby = (NanamigoEntity)((EntityType)EntityInit.Nanamigo_Entity.get()).m_20615_((Level)serverLevel);
        if (baby != null) {
            baby.m_6863_(true);
        }
        return baby;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.2, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 30.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FollowGroupGoal(this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new PlayfulBehaviorGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CallNanamigoGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.15, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.15, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42528_}), false));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.0));
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(!this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
            this.floatingAnimationState.m_246184_(this.m_20072_(), this.f_19797_);
            this.flyingAnimationState.m_246184_(!this.m_20096_() && !this.m_20072_() && this.isFlying(), this.f_19797_);
        }
        if (this.m_9236_().m_5776_() && this.playCooldown == 0 && this.m_20096_() && !this.f_267362_.m_267780_()) {
            this.playCooldown = 400;
            this.meetAnimationState.m_216977_(this.f_19797_);
            this.idleAnimationState.m_216973_();
        } else {
            --this.playCooldown;
        }
        if (this.playCooldown != 0 && !this.m_20096_() && this.f_267362_.m_267780_()) {
            this.meetAnimationState.m_216973_();
        }
        if (!this.m_9236_().f_46443_) {
            if (this.callCooldown > 0) {
                --this.callCooldown;
            }
            if (this.playCooldown > 0) {
                --this.playCooldown;
            }
        }
        super.m_8119_();
    }

    public static AttributeSupplier.Builder createNanamigoAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22279_, (double)0.13f).m_22268_(Attributes.f_22276_, 7.0).m_22268_(Attributes.f_22280_, (double)0.45f);
    }

    public static boolean canSpawn(EntityType<NanamigoEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.nanamigoSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return TamableAnimal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public boolean isFlying() {
        return !this.m_20096_();
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.NANAMIGO_AMBIENT.get();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.m_21824_() && TAME_FOOD.contains(itemstack.m_41720_())) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (TAME_FOOD.contains(itemstack.m_41720_())) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_21828_(player);
                        this.f_21344_.m_26573_();
                        this.m_6710_(null);
                        this.m_21839_(true);
                        this.m_9236_().m_7605_((Entity)this, (byte)7);
                    } else {
                        this.m_9236_().m_7605_((Entity)this, (byte)6);
                    }
                }
                this.m_21530_();
                return InteractionResult.SUCCESS;
            }
            return super.m_6071_(player, hand);
        }
        if (this.m_21824_() && !this.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND && !TAME_FOOD.contains(itemstack.m_41720_())) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_()) {
            if (TAME_FOOD.contains(itemstack.m_41720_()) && this.m_21223_() < this.m_21233_() && this.m_21824_()) {
                this.m_5634_(Objects.requireNonNull(itemstack.getFoodProperties((LivingEntity)this)).m_38744_());
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            this.m_146852_(GameEvent.f_157806_, (Entity)this);
            return InteractionResult.SUCCESS;
        }
        if (TAME_FOOD.contains(itemstack.m_41720_())) {
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    static class PlayfulBehaviorGoal
    extends Goal {
        private final NanamigoEntity nanamigo;

        public PlayfulBehaviorGoal(NanamigoEntity nanamigo) {
            this.nanamigo = nanamigo;
        }

        public boolean m_8036_() {
            return this.nanamigo.playCooldown == 0 && this.nanamigo.m_9236_().m_45963_(NanamigoEntity.class, TargetingConditions.m_148353_(), (LivingEntity)this.nanamigo, this.nanamigo.m_20185_(), this.nanamigo.m_20186_(), this.nanamigo.m_20189_(), this.nanamigo.m_20191_().m_82400_(6.0)) != null;
        }

        public void m_8056_() {
            this.nanamigo.playCooldown = 400 + this.nanamigo.m_217043_().m_188503_(2400);
        }
    }

    static class CallNanamigoGoal
    extends Goal {
        private final NanamigoEntity nanamigo;

        public CallNanamigoGoal(NanamigoEntity nanamigo) {
            this.nanamigo = nanamigo;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.nanamigo.callCooldown == 0 && this.nanamigo.m_9236_().m_45963_(NanamigoEntity.class, TargetingConditions.m_148353_(), (LivingEntity)this.nanamigo, this.nanamigo.m_20185_(), this.nanamigo.m_20186_(), this.nanamigo.m_20189_(), this.nanamigo.m_20191_().m_82400_(10.0)) != null;
        }

        public void m_8056_() {
            this.nanamigo.m_5496_((SoundEvent)SoundInit.NANAMIGO_SOCIALIZE.get(), 1.0f, 1.0f);
            this.nanamigo.callCooldown = 400 + this.nanamigo.m_217043_().m_188503_(2400);
        }
    }
}

