/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import dev.dracu.bigmobs.entity.GravelettEntity;
import dev.dracu.bigmobs.entity.ai.ObelisxAttackGoal;
import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.EntityInit;
import dev.dracu.bigmobs.init.SoundInit;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class ObelisxEntity
extends PathfinderMob
implements NeutralMob {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    private float eyeRotationX;
    private float eyeRotationY;
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(ObelisxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SUMMONED = SynchedEntityData.m_135353_(ObelisxEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private boolean hasSpawnedGraveletts = false;
    private int attackAnimationTick;

    public ObelisxEntity(EntityType<ObelisxEntity> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.f_21364_ = 8;
        if (!((Boolean)BigMobsConfig.COMMON.obelisxSpawnEnabled.get()).booleanValue() && !this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    public ObelisxEntity(Level level, double x, double y, double z) {
        this((EntityType<ObelisxEntity>)((EntityType)EntityInit.Obelisx_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public ObelisxEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ObelisxAttackGoal(this, 2.8, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 3.5, 30.0f));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((ObelisxEntity)this).m_21674_(arg_0)));
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)1.11f, (float)1.11f);
    }

    public void m_8119_() {
        if (!((Boolean)BigMobsConfig.COMMON.obelisxSpawnEnabled.get()).booleanValue()) {
            this.m_146870_();
        }
        if (this.m_9236_().m_5776_() && this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 40;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
        super.m_8119_();
        Player player = this.m_9236_().m_45930_((Entity)this, 32.0);
        if (player != null) {
            double dx = player.m_20185_() - this.m_20185_();
            double dy = player.m_20188_() - this.m_20188_();
            double dz = player.m_20189_() - this.m_20189_();
            this.eyeRotationY = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            this.eyeRotationX = (float)(-(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232));
        }
    }

    public float getEyeRotationX() {
        return this.eyeRotationX;
    }

    public float getEyeRotationY() {
        return this.eyeRotationY;
    }

    public static AttributeSupplier.Builder createObelisxAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 59.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22276_, 59.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 0.9);
    }

    public static boolean canSpawn(EntityType<ObelisxEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.obelisxSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return Mob.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(SUMMONED, (Object)false);
    }

    public boolean hasSummonedGraveletts() {
        return (Boolean)this.f_19804_.m_135370_(SUMMONED);
    }

    public void setHasSummonedGraveletts(boolean value) {
        this.f_19804_.m_135381_(SUMMONED, (Object)value);
    }

    private void triggerSummonAnimation() {
        this.m_5496_(SoundEvents.f_215771_, 1.5f, 0.8f);
        this.summonGraveletts();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean damaged = super.m_6469_(source, amount);
        if (!this.m_9236_().f_46443_ && this.m_21223_() <= this.m_21233_() / 2.0f && !this.hasSpawnedGraveletts) {
            this.spawnGraveletts();
            this.hasSpawnedGraveletts = true;
        }
        return damaged;
    }

    private void spawnGraveletts() {
        for (int i = 0; i < 3; ++i) {
            GravelettEntity gravelett = new GravelettEntity((EntityType<GravelettEntity>)((EntityType)EntityInit.Gravelett_Entity.get()), this.m_9236_());
            double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 4.0;
            double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 4.0;
            gravelett.m_6034_(x, this.m_20186_(), z);
            this.m_9236_().m_7967_((Entity)gravelett);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, this.m_20186_(), z, 10, 0.5, 0.5, 0.5, 0.1);
            this.m_5496_(SoundEvents.f_215771_, 1.5f, 0.8f);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_147285_(this.m_9236_(), tag);
        this.hasSpawnedGraveletts = tag.m_128471_("HasSpawnedGraveletts");
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.m_21678_(tag);
        tag.m_128379_("HasSpawnedGraveletts", this.hasSpawnedGraveletts);
    }

    private void summonGraveletts() {
        for (int i = 0; i < 3; ++i) {
            GravelettEntity gravelett = (GravelettEntity)((EntityType)EntityInit.Gravelett_Entity.get()).m_20615_(this.m_9236_());
            if (gravelett == null) continue;
            double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 4.0;
            double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 4.0;
            gravelett.m_6034_(x, this.m_20186_(), z);
            this.m_9236_().m_7967_((Entity)gravelett);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, this.m_20186_(), z, 10, 0.5, 0.5, 0.5, 0.1);
        }
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int p_21673_) {
        this.remainingPersistentAngerTime = p_21673_;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_21672_) {
        this.persistentAngerTarget = p_21672_;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public boolean m_213824_() {
        return true;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.OBELISX_THUMP.get();
    }
}

