/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.EntityInit;
import dev.dracu.bigmobs.init.ItemInit;
import dev.dracu.bigmobs.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.scores.Team;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class ParsnippetEntity
extends TamableAnimal {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState sittingAnimationState = new AnimationState();
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(ParsnippetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public ParsnippetEntity(EntityType<ParsnippetEntity> type, Level level) {
        super(type, level);
        this.m_7105_(false);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
    }

    public ParsnippetEntity(Level level, double x, double y, double z) {
        this((EntityType<ParsnippetEntity>)((EntityType)EntityInit.PunyParsnip_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public ParsnippetEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return new ParsnippetEntity((Level)level, this.m_20183_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.NASTY_SOUP.get()}), false));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.PARSNIP.get()}), false));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 9.0f, 2.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(!this.m_20072_() && !this.f_267362_.m_267780_() && !this.isSitting(), this.f_19797_);
        }
        if (this.m_9236_().m_5776_()) {
            this.sittingAnimationState.m_246184_(!this.m_20072_() && this.isSitting(), this.f_19797_);
        }
        super.m_8119_();
    }

    public static AttributeSupplier.Builder createPunyParsnipAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.2777f).m_22268_(Attributes.f_22276_, 21.5).m_22268_(Attributes.f_22281_, 3.0);
    }

    public static boolean canSpawn(EntityType<ParsnippetEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.punyparsnipSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return TamableAnimal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.PARSNIP_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.PARSNIP_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundInit.PARSNIP_HURT.get();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Item itemForTaming;
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item == (itemForTaming = (Item)ItemInit.NASTY_SOUP.get()) && !this.m_21824_()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (item == itemForTaming) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_21828_(player);
                        this.f_21344_.m_26573_();
                        this.m_6710_(null);
                        this.setSitting(true);
                        this.m_21839_(true);
                        this.m_9236_().m_7605_((Entity)this, (byte)7);
                    } else {
                        this.m_9236_().m_7605_((Entity)this, (byte)6);
                    }
                }
                this.m_21530_();
                return InteractionResult.SUCCESS;
            }
        }
        if (this.m_21824_() && (this.m_6898_(itemstack) || item == itemForTaming && this.m_21223_() < this.m_21233_())) {
            this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_146852_(GameEvent.f_157806_, (Entity)this);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && !this.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND && item != itemForTaming) {
            this.setSitting(!this.isSitting());
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSitting(tag.m_128471_("isSitting"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("isSitting", this.isSitting());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SITTING, (Object)false);
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        this.m_21839_(sitting);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public Team m_5647_() {
        return super.m_5647_();
    }

    public boolean m_6573_(Player player) {
        return true;
    }

    public void m_7105_(boolean isTamed) {
        super.m_7105_(isTamed);
        if (isTamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(21.5);
            this.m_21153_(20.0f);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
            this.m_21051_(Attributes.f_22281_).m_22100_(3.0);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(21.5);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.2777);
            this.m_21051_(Attributes.f_22281_).m_22100_(2.5);
        }
    }

    public boolean m_7757_(LivingEntity pTarget, LivingEntity pOwner) {
        if (!(pTarget instanceof Creeper) && !(pTarget instanceof Ghast)) {
            if (pTarget instanceof ParsnippetEntity) {
                ParsnippetEntity parsnippet = (ParsnippetEntity)pTarget;
                return !parsnippet.m_21824_() || parsnippet.m_269323_() != pOwner;
            }
            if (pTarget instanceof Player && pOwner instanceof Player && !((Player)pOwner).m_7099_((Player)pTarget)) {
                return false;
            }
            if (pTarget instanceof AbstractHorse && ((AbstractHorse)pTarget).m_30614_()) {
                return false;
            }
            return !(pTarget instanceof TamableAnimal) || !((TamableAnimal)pTarget).m_21824_();
        }
        return false;
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, pEntity);
        }
        return flag;
    }

    protected float m_6108_() {
        return 0.78f;
    }

    public boolean m_6785_(double distance) {
        return false;
    }
}

