/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.EntityInit;
import dev.dracu.bigmobs.init.ItemInit;
import dev.dracu.bigmobs.init.SoundInit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class RooferEntity
extends AbstractVillager
implements Merchant {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState sittingAnimationState = new AnimationState();
    private static final int BEE_ATTRACTION_DURATION = 350;
    private static final int BEE_ATTRACTION_COOLDOWN = 36000;
    private static final int NUMBER_OF_TRADE_OFFERS = 5;
    private int beeAttractionCooldown = 0;
    private int beeAttractionTime = 0;
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(RooferEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public RooferEntity(EntityType<RooferEntity> type, Level level) {
        super(type, level);
    }

    public RooferEntity(Level level, double x, double y, double z) {
        this((EntityType<RooferEntity>)((EntityType)EntityInit.Roofer_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public RooferEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public boolean m_7826_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().m_46461_()) {
            return super.m_6469_(source, amount);
        }
        return false;
    }

    public boolean m_142066_() {
        return false;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(!this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        if (this.beeAttractionCooldown > 0) {
            --this.beeAttractionCooldown;
        }
        if (this.beeAttractionTime > 0) {
            --this.beeAttractionTime;
            if (this.beeAttractionTime == 0) {
                this.releaseBees();
            }
        }
        super.m_8119_();
    }

    public void attractBees() {
        if (this.beeAttractionCooldown > 0 || this.beeAttractionTime > 0) {
            return;
        }
        this.beeAttractionTime = 350;
        this.beeAttractionCooldown = 36000;
        List nearbyBees = this.m_9236_().m_45976_(Bee.class, this.m_20191_().m_82400_(10.0));
        for (Bee bee : nearbyBees) {
            bee.m_6710_((LivingEntity)this);
        }
    }

    private void releaseBees() {
        List nearbyBees = this.m_9236_().m_45976_(Bee.class, this.m_20191_().m_82400_(10.0));
        for (Bee bee : nearbyBees) {
            bee.m_6710_(null);
        }
    }

    public static AttributeSupplier.Builder createRooferAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.11f).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 0.2).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public static boolean canSpawn(EntityType<RooferEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.rooferSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return Mob.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_(Items.f_42399_)) {
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42718_));
            itemstack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_(Items.f_42590_)) {
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42787_));
            itemstack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (this.m_6084_() && !this.m_35306_() && !this.m_6162_()) {
            if (hand == InteractionHand.MAIN_HAND) {
                player.m_36220_(Stats.f_12940_);
            }
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    protected void m_7604_() {
        VillagerTrades.ItemListing[] $$0 = (VillagerTrades.ItemListing[])VillagerTrades.f_35628_.get(1);
        VillagerTrades.ItemListing[] $$1 = (VillagerTrades.ItemListing[])VillagerTrades.f_35628_.get(2);
        if ($$0 != null && $$1 != null) {
            Item[] possibleOutputs = new Item[]{Items.f_42799_, Items.f_41827_, Items.f_41826_, Items.f_42801_, Items.f_42800_, Items.f_271375_, (Item)ItemInit.POOP_SAPLING.get()};
            int numberOfTrades = 1 + this.f_19796_.m_188503_(10);
            for (int i = 0; i < numberOfTrades; ++i) {
                int randomInputAmount = 1 + this.f_19796_.m_188503_(6);
                int randomOutputAmount = 1 + this.f_19796_.m_188503_(5);
                Item randomOutputItem = possibleOutputs[this.f_19796_.m_188503_(possibleOutputs.length)];
                ItemStack inputItem = new ItemStack((ItemLike)Items.f_41953_, randomInputAmount);
                ItemStack outputItem = new ItemStack((ItemLike)randomOutputItem, randomOutputAmount);
                this.f_35261_.add((Object)new MerchantOffer(inputItem, outputItem, 7, 2, 0.05f));
            }
        }
    }

    protected void m_8058_(MerchantOffer pOffer) {
        if (pOffer.m_45383_()) {
            int $$1 = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), $$1));
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.ROOFER_AMBIENT.get();
    }
}

