/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import dev.dracu.bigmobs.entity.WalkerEntity;
import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.EntityInit;
import dev.dracu.bigmobs.init.ItemInit;
import dev.dracu.bigmobs.init.SoundInit;
import dev.dracu.bigmobs.init.TagInit;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SavannariEntity
extends Animal
implements NeutralMob {
    public final AnimationState idleAnimationState = new AnimationState();
    private boolean diggingGoalActive = false;
    private int diggingTime = 0;
    private int diggingCooldown = 0;
    private BlockPos digPos = null;
    public final AnimationState diggingAnimationState = new AnimationState();
    public final AnimationState undigAnimationState = new AnimationState();
    private final List<WeightedItem> dirtLootTable = Arrays.asList(new WeightedItem(new ItemStack((ItemLike)Items.f_42404_), 30), new WeightedItem(new ItemStack((ItemLike)Items.f_42733_), 30), new WeightedItem(new ItemStack((ItemLike)Items.f_42484_), 25), new WeightedItem(new ItemStack((ItemLike)Items.f_42591_), 25), new WeightedItem(new ItemStack((ItemLike)Items.f_42401_), 25), new WeightedItem(new ItemStack((ItemLike)Items.f_42500_), 25), new WeightedItem(new ItemStack((ItemLike)Items.f_151019_), 20), new WeightedItem(new ItemStack((ItemLike)Items.f_42539_), 20), new WeightedItem(new ItemStack((ItemLike)Items.f_42539_), 20), new WeightedItem(new ItemStack((ItemLike)Items.f_42399_), 20), new WeightedItem(new ItemStack((ItemLike)Items.f_42749_), 18), new WeightedItem(new ItemStack((ItemLike)Items.f_42416_), 16), new WeightedItem(new ItemStack((ItemLike)Items.f_42417_), 14), new WeightedItem(new ItemStack((ItemLike)Items.f_271133_), 10), new WeightedItem(new ItemStack((ItemLike)Items.f_42718_), 5), new WeightedItem(new ItemStack((ItemLike)Items.f_265996_), 5), new WeightedItem(new ItemStack((ItemLike)Items.f_42109_), 10));
    private final List<WeightedItem> sandLootTable = Arrays.asList(new WeightedItem(new ItemStack((ItemLike)Items.f_42403_), 25), new WeightedItem(new ItemStack((ItemLike)Items.f_42577_), 40), new WeightedItem(new ItemStack((ItemLike)Items.f_42484_), 30), new WeightedItem(new ItemStack((ItemLike)Items.f_42398_), 25), new WeightedItem(new ItemStack((ItemLike)Items.f_42461_), 25), new WeightedItem(new ItemStack((ItemLike)Items.f_42500_), 25), new WeightedItem(new ItemStack((ItemLike)Items.f_42027_), 20), new WeightedItem(new ItemStack((ItemLike)Items.f_42493_), 20), new WeightedItem(new ItemStack((ItemLike)Items.f_151059_), 20), new WeightedItem(new ItemStack((ItemLike)Items.f_42587_), 18), new WeightedItem(new ItemStack((ItemLike)Items.f_42417_), 16), new WeightedItem(new ItemStack((ItemLike)Items.f_42416_), 14), new WeightedItem(new ItemStack((ItemLike)Items.f_41996_), 10), new WeightedItem(new ItemStack((ItemLike)Items.f_42718_), 5), new WeightedItem(new ItemStack((ItemLike)Items.f_266078_), 5), new WeightedItem(new ItemStack((ItemLike)Items.f_279616_), 12), new WeightedItem(new ItemStack((ItemLike)Items.f_279636_), 12));

    public SavannariEntity(EntityType<SavannariEntity> type, Level level) {
        super(type, level);
    }

    public SavannariEntity(Level level, double x, double y, double z) {
        this((EntityType<SavannariEntity>)((EntityType)EntityInit.Savannari_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public SavannariEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41910_}), false));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(TagInit.SAVANNARI_BREED_FOOD), false));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, WalkerEntity.class, true, false));
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(TagInit.SAVANNARI_BREED_FOOD);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        SavannariEntity baby = (SavannariEntity)((EntityType)EntityInit.Savannari_Entity.get()).m_20615_((Level)serverLevel);
        return (AgeableMob)((EntityType)EntityInit.Savannari_Entity.get()).m_20615_((Level)serverLevel);
    }

    public void m_6863_(boolean isBaby) {
        super.m_6863_(isBaby);
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.m_6162_()) {
            return EntityDimensions.m_20395_((float)0.8f, (float)0.95f);
        }
        return EntityDimensions.m_20395_((float)1.6f, (float)1.9f);
    }

    public boolean m_7848_(@NotNull Animal pOtherAnimal) {
        return pOtherAnimal != this && pOtherAnimal instanceof SavannariEntity;
    }

    public void m_27563_(ServerLevel pLevel, Animal pOtherAnimal) {
        ItemStack itemstack = new ItemStack((ItemLike)ItemInit.RATITE_EGG.get());
        ItemEntity itementity = new ItemEntity((Level)pLevel, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), itemstack);
        itementity.m_32060_();
        this.m_277117_(pLevel, pOtherAnimal, null);
        this.m_5496_(SoundEvents.f_279531_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
        pLevel.m_7967_((Entity)itementity);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.undigAnimationState.m_246184_(this.undigAnimationState.m_216984_(), this.f_19797_);
            this.idleAnimationState.m_246184_(!this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        if (this.diggingCooldown > 0) {
            --this.diggingCooldown;
        }
        if (!this.diggingGoalActive && this.diggingCooldown == 0) {
            this.tryStartDigging();
        }
        if (this.diggingGoalActive) {
            this.handleDiggingTick();
        }
    }

    private void tryStartDigging() {
        BlockPos posBelow = this.m_20183_().m_7495_();
        Block block = this.m_9236_().m_8055_(posBelow).m_60734_();
        if (this.isDiggableBlock(block) && this.f_19796_.m_188503_(5000) == 0) {
            this.diggingGoalActive = true;
            this.diggingTime = 60 + this.f_19796_.m_188503_(40);
            this.digPos = posBelow;
            this.diggingAnimationState.m_216977_(this.f_19797_);
            this.m_9236_().m_7605_((Entity)this, (byte)10);
        }
    }

    private void handleDiggingTick() {
        if (--this.diggingTime <= 0) {
            this.dropDigLoot(this.digPos);
            this.diggingAnimationState.m_216973_();
            this.undigAnimationState.m_216977_(this.f_19797_);
            this.diggingGoalActive = false;
            this.diggingCooldown = 100 + this.f_19796_.m_188503_(100);
        }
    }

    private void dropDigLoot(BlockPos pos) {
        Block block = this.m_9236_().m_8055_(pos).m_60734_();
        ItemStack drop = ItemStack.f_41583_;
        if (block == Blocks.f_50440_ || block == Blocks.f_50493_ || block == Blocks.f_50599_ || block == Blocks.f_50546_) {
            drop = this.getWeightedRandomLoot(this.dirtLootTable);
        } else if (block == Blocks.f_49992_ || block == Blocks.f_49993_) {
            drop = this.getWeightedRandomLoot(this.sandLootTable);
        }
        if (!drop.m_41619_()) {
            this.m_19983_(drop);
        }
    }

    private boolean isDiggableBlock(Block block) {
        return block == Blocks.f_50440_ || block == Blocks.f_50493_ || block == Blocks.f_49992_ || block == Blocks.f_49993_ || block == Blocks.f_50546_ || block == Blocks.f_50599_;
    }

    private int getTotalWeight(List<WeightedItem> lootTable) {
        return lootTable.stream().mapToInt(item -> item.weight).sum();
    }

    private ItemStack getWeightedRandomLoot(List<WeightedItem> lootTable) {
        int totalWeight = this.getTotalWeight(lootTable);
        int randomValue = this.f_19796_.m_188503_(totalWeight);
        for (WeightedItem weightedItem : lootTable) {
            if ((randomValue -= weightedItem.weight) >= 0) continue;
            return weightedItem.item;
        }
        return ItemStack.f_41583_;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        return this.m_6972_((Pose)pPose).f_20378_ * 0.6f;
    }

    public void m_284177_() {
        super.m_284177_();
        if (this.m_6060_() || this.m_20069_()) {
            this.m_21441_(BlockPathTypes.WATER, 0.0f);
        }
    }

    public static AttributeSupplier.Builder createSavannariAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22276_, 13.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 40.0);
    }

    public static boolean canSpawn(EntityType<SavannariEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.savannariSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.SAVANNARI_AMBIENT.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12237_, 0.15f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.SAVANNARI_DEATH.get();
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int i) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID uuid) {
    }

    public void m_6825_() {
    }

    protected void m_6135_() {
        double d1;
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        boolean flag = this.m_6898_(itemstack);
        InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
        if (interactionresult.m_19077_() && flag) {
            this.m_9236_().m_6269_((Player)null, (Entity)this, this.m_7866_(itemstack), SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
        }
        return interactionresult;
    }

    private BlockPos getHeadBlock() {
        Vec3 vec3 = this.getHeadPosition();
        return BlockPos.m_274561_((double)vec3.m_7096_(), (double)(this.m_20186_() + (double)0.2f), (double)vec3.m_7094_());
    }

    private Vec3 getHeadPosition() {
        return this.m_20182_().m_82549_(this.m_20156_().m_82490_(2.25));
    }

    private static class WeightedItem {
        public final ItemStack item;
        public final int weight;

        public WeightedItem(ItemStack item, int weight) {
            this.item = item;
            this.weight = weight;
        }
    }
}

