/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import dev.dracu.bigmobs.entity.ai.EntityPoopGoal;
import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.EntityInit;
import dev.dracu.bigmobs.init.ItemInit;
import dev.dracu.bigmobs.init.SoundInit;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class SeagullEntity
extends Animal {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState floatingAnimationState = new AnimationState();
    public final AnimationState flyingAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState barterAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(SeagullEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(SeagullEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SeagullEntity(EntityType<SeagullEntity> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, false);
    }

    public SeagullEntity(Level level, double x, double y, double z) {
        this((EntityType<SeagullEntity>)((EntityType)EntityInit.Seagull_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public SeagullEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        return pOtherAnimal != this && pOtherAnimal instanceof SeagullEntity;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42528_);
    }

    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions dimensions = super.m_6972_(pose);
        return this.m_6162_() ? dimensions.m_20388_(0.7f) : dimensions;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        SeagullEntity baby = (SeagullEntity)((EntityType)EntityInit.Seagull_Entity.get()).m_20615_((Level)serverLevel);
        if (baby != null) {
            baby.m_6863_(true);
        }
        return baby;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 30.0f));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new EntityPoopGoal((LivingEntity)this));
        this.f_21345_.m_25352_(4, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42528_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42406_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42572_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.POOP.get()}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ItemInit.BEANBURRITO.get()}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42780_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151079_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42521_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42527_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42529_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42404_}), false));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42581_}), false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(!this.m_20072_() && !this.f_267362_.m_267780_() && this.m_20096_(), this.f_19797_);
            this.floatingAnimationState.m_246184_(this.m_20072_(), this.f_19797_);
            this.floatingAnimationState.m_246184_(this.m_20072_(), this.f_19797_);
            this.flyingAnimationState.m_246184_(!this.m_20096_() && !this.m_20072_(), this.f_19797_);
        }
        super.m_8119_();
    }

    public static AttributeSupplier.Builder createSeagullAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22280_, 0.25);
    }

    public static boolean canSpawn(EntityType<SeagullEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.seagullSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.SEAGULL_AMBIENT.get();
    }

    public boolean isFlying() {
        return !this.m_20096_();
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag data) {
        super.m_6518_(level, difficulty, spawnType, spawnData, data);
        if (this.getVariant() == 0) {
            this.setVariant(this.randomizeVariant());
        }
        return spawnData;
    }

    public void m_6863_(boolean isBaby) {
        super.m_6863_(isBaby);
        this.setVariant(this.randomizeVariant());
    }

    private int randomizeVariant() {
        Random random = new Random();
        int roll = random.nextInt(100);
        if (roll < 40) {
            return 1;
        }
        return 0;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.m_9236_().f_46443_ && stack.m_150930_(Items.f_42715_)) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.giveLoot();
            this.m_5496_((SoundEvent)SoundInit.SEAGULL_BARTER.get(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void giveLoot() {
        RandomSource randomsource = this.m_217043_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        blockpos$mutableblockpos.m_122190_((Vec3i)this.m_20183_());
        LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(new ResourceLocation("bigmobs", "gameplay/seagull_barter"));
        LootParams lootparams = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81416_);
        for (ItemStack itemstack : loottable.m_287195_(lootparams)) {
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), (double)blockpos$mutableblockpos.m_123341_(), (double)blockpos$mutableblockpos.m_123342_(), (double)blockpos$mutableblockpos.m_123343_(), itemstack));
        }
    }
}

