/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import dev.dracu.bigmobs.entity.ai.DistractedByBlockGoal;
import dev.dracu.bigmobs.entity.ai.ShellbiteAttackGoal;
import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.BlockInit;
import dev.dracu.bigmobs.init.EntityInit;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShellbiteEntity
extends WaterAnimal
implements Enemy {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    private boolean isFlopping;
    private static final double HITBOX_MIN_X = -20.5;
    private static final double HITBOX_MIN_Y = 20.0;
    private static final double HITBOX_MIN_Z = -0.5;
    private static final double HITBOX_MAX_X = -10.0;
    private static final double HITBOX_MAX_Y = 50.0;
    private static final double HITBOX_MAX_Z = -10.0;
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(ShellbiteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private int attackAnimationTick;
    private int flopTicks;

    public ShellbiteEntity(@NotNull EntityType<ShellbiteEntity> type, Level level) {
        super(type, level);
        this.m_21530_();
        if (!((Boolean)BigMobsConfig.COMMON.shellbiteSpawnEnabled.get()).booleanValue() && !this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
        this.flopTicks = 0;
        this.isFlopping = false;
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 45, 10, 0.1f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 5);
    }

    public int m_21529_() {
        return 4;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_20301_(this.m_6062_());
        this.m_146926_(0.0f);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public ShellbiteEntity(Level level, double x, double y, double z) {
        this((EntityType<ShellbiteEntity>)((EntityType)EntityInit.Shellbite_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public ShellbiteEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 1));
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new ShellbiteAttackGoal((PathfinderMob)this, 3.0, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 4.0, 30.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new DistractedByBlockGoal((Mob)this, 3.0, (Block)BlockInit.GLOW_BULB.get()));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Guardian.class, true, false));
    }

    public boolean m_6040_() {
        return true;
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new WaterBoundPathNavigation((Mob)this, pLevel);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        if (this.m_9236_().m_5776_() && this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 40;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
        if (!((Boolean)BigMobsConfig.COMMON.shellbiteSpawnEnabled.get()).booleanValue()) {
            this.m_146870_();
        }
        if (!this.m_20072_() && this.m_6084_() && this.m_20096_() && this.f_19796_.m_188501_() < 0.05f) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f)));
            this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
            this.m_5496_(SoundEvents.f_12329_, this.m_6121_(), this.m_6100_());
        }
        super.m_8119_();
    }

    public static AttributeSupplier.Builder createShellbiteAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 19.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 0.2);
    }

    public static boolean canSpawn(EntityType<ShellbiteEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.shellbiteSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return WaterAnimal.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.5f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int p_21673_) {
        this.remainingPersistentAngerTime = p_21673_;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_21672_) {
        this.persistentAngerTarget = p_21672_;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_213824_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        double entityHeight;
        double entityY;
        double attackerY;
        if (source.m_7640_() != null && (attackerY = source.m_7640_().m_20186_()) > (entityY = this.m_20186_()) + (entityHeight = (double)this.m_20206_()) * 0.1) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    private void startFlopping() {
        this.isFlopping = true;
        this.m_21573_().m_26573_();
        this.m_20256_(new Vec3(Math.random() - 0.5, 0.2, Math.random() - 0.5));
    }

    private boolean canSeeBlock(BlockPos destinationBlock) {
        Vec3 Vector3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 blockVec = Vec3.m_82512_((Vec3i)destinationBlock);
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(Vector3d, blockVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return result.m_82425_().equals((Object)destinationBlock);
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 Vector3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        return this.m_9236_().m_45547_(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.BLOCK;
    }

    private BlockPos findNearestWater(BlockPos start, int radius) {
        return BlockPos.m_121930_((BlockPos)start, (int)radius, (int)radius, pos -> this.m_9236_().m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13131_)).orElse(null);
    }
}

