/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.BiomeTagInit;
import dev.dracu.bigmobs.init.EntityInit;
import dev.dracu.bigmobs.init.ItemInit;
import dev.dracu.bigmobs.init.SoundInit;
import dev.dracu.bigmobs.init.TagInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class TrickyChestEntity
extends PathfinderMob
implements Enemy {
    private boolean hasSeenPlayer = false;
    private int scaredTicks = 0;
    private int dabloonsDropped = 0;
    private int maxDabloons = 5 + this.f_19796_.m_188503_(7);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState scaredAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(TrickyChestEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public TrickyChestEntity(EntityType<TrickyChestEntity> type, Level world) {
        super(type, world);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        if (!((Boolean)BigMobsConfig.COMMON.trickychestSpawnEnabled.get()).booleanValue() && !this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    public TrickyChestEntity(Level level, double x, double y, double z) {
        this((EntityType<TrickyChestEntity>)((EntityType)EntityInit.TrickyChest_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public TrickyChestEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 26.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void m_8119_() {
        Player player;
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(!this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        if (!((Boolean)BigMobsConfig.COMMON.trickychestSpawnEnabled.get()).booleanValue()) {
            this.m_146870_();
        }
        if (this.scaredTicks > 0) {
            --this.scaredTicks;
            this.scaredAnimationState.m_216982_(this.f_19797_);
            this.m_21573_().m_26573_();
            return;
        }
        this.scaredAnimationState.m_216973_();
        if (!this.hasSeenPlayer && (player = this.m_9236_().m_45930_((Entity)this, 12.0)) != null && this.m_142582_((Entity)player) && !player.m_7500_()) {
            this.scaredTicks = 20;
            this.m_216990_((SoundEvent)SoundInit.TRICKYCHEST_FRIGHT.get());
            this.hasSeenPlayer = true;
        }
        super.m_8119_();
    }

    public static AttributeSupplier.Builder createTrickyChestAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22281_, 2.5).m_22268_(Attributes.f_22278_, 0.3).m_22268_(Attributes.f_22277_, 25.0);
    }

    public static boolean canSpawn(EntityType<TrickyChestEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.trickychestSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return Mob.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random) && level.m_8055_(position.m_7495_()).m_204336_(TagInit.TRICKYCHEST_SPAWN_BLOCKS) && position.m_123342_() <= level.m_5736_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)1);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        SpawnGroupData result = super.m_6518_(world, difficulty, reason, spawnData, dataTag);
        Holder $$5 = world.m_204166_(this.m_20183_());
        if ($$5.m_203656_(BiomeTagInit.SPAWNS_GREEN_TRICKYCHEST)) {
            this.setVariant(0);
        } else if ($$5.m_203656_(BiomeTagInit.SPAWNS_PINK_TRICKYCHEST)) {
            this.setVariant(2);
        } else {
            this.setVariant(1);
        }
        return result;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("DabloonsDropped", this.dabloonsDropped);
        tag.m_128405_("MaxDabloons", this.maxDabloons);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        this.dabloonsDropped = tag.m_128451_("DabloonsDropped");
        this.maxDabloons = tag.m_128441_("MaxDabloons") ? tag.m_128451_("MaxDabloons") : 5 + this.f_19796_.m_188503_(7);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (!this.m_9236_().f_46443_ && result && this.shouldDropDabloon(source) && this.dabloonsDropped < this.maxDabloons) {
            this.m_19998_((ItemLike)ItemInit.DABLOON.get());
            ++this.dabloonsDropped;
        }
        return result;
    }

    private boolean shouldDropDabloon(DamageSource source) {
        return source.m_7639_() instanceof Player && !source.m_276093_(DamageTypes.f_268671_);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7334_(Entity p_70108_1_) {
    }

    public void m_5997_(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.TRICKYCHEST_IDLE.get();
    }
}

