/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity;

import dev.dracu.bigmobs.entity.ShellbiteEntity;
import dev.dracu.bigmobs.entity.ai.SeaMoveController;
import dev.dracu.bigmobs.entity.ai.WaternGroundNavigator;
import dev.dracu.bigmobs.init.BigMobsConfig;
import dev.dracu.bigmobs.init.EntityInit;
import dev.dracu.bigmobs.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WalkerEntity
extends Monster
implements Enemy {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState croakAnimationState = new AnimationState();
    public final AnimationState swimAnimationState = new AnimationState();
    private final SeaMoveController seaMoveControl;
    private final MoveControl landMoveControl;
    public final AnimationState swimIdleAnimationState = new AnimationState();
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(WalkerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public WalkerEntity(EntityType<WalkerEntity> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.landMoveControl = new MoveControl((Mob)this);
        this.seaMoveControl = new SeaMoveController((PathfinderMob)this, 1.0f, 5.0f);
        this.f_21342_ = this.landMoveControl;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        if (!((Boolean)BigMobsConfig.COMMON.walkerSpawnEnabled.get()).booleanValue() && !this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    public WalkerEntity(Level level, double x, double y, double z) {
        this((EntityType<WalkerEntity>)((EntityType)EntityInit.Walker_Entity.get()), level);
        this.m_6034_(x, y, z);
    }

    public WalkerEntity(Level level, BlockPos position) {
        this(level, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.3, 26.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 1));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{WalkerEntity.class}).m_26044_(new Class[]{ShellbiteEntity.class}));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Guardian.class, true, false));
    }

    public boolean m_6040_() {
        return true;
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaternGroundNavigator((Mob)this, level);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return this.m_6162_() ? pSize.f_20378_ * 0.75f : pSize.f_20378_ * 0.72f;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public static AttributeSupplier.Builder createWalkerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, (double)0.2345653f).m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22281_, 2.5);
    }

    public static boolean canSpawn(EntityType<WalkerEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        if (!((Boolean)BigMobsConfig.COMMON.walkerSpawnEnabled.get()).booleanValue()) {
            return false;
        }
        return Mob.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public void m_8119_() {
        if (this.m_20069_()) {
            if (this.f_21342_ != this.seaMoveControl) {
                this.f_21342_ = this.seaMoveControl;
            }
        } else if (this.f_21342_ != this.landMoveControl) {
            this.f_21342_ = this.landMoveControl;
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
        }
        if (this.m_9236_().m_5776_()) {
            this.swimAnimationState.m_246184_(this.m_20072_() && this.f_267362_.m_267780_() && !this.m_20096_(), this.f_19797_);
        }
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(!this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        if (this.m_9236_().m_5776_()) {
            this.swimIdleAnimationState.m_246184_(this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        if (!((Boolean)BigMobsConfig.COMMON.walkerSpawnEnabled.get()).booleanValue()) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.WALKER_IDLE.get();
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (f_19806_.equals(pKey)) {
            Pose $$1 = this.m_20089_();
            if ($$1 == Pose.CROAKING) {
                this.croakAnimationState.m_216977_(this.f_19797_);
            } else {
                this.croakAnimationState.m_216973_();
            }
        }
        super.m_7350_(pKey);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean m_6063_() {
        return false;
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    class WalkerLookControl
    extends SmoothSwimmingLookControl {
        public WalkerLookControl(WalkerEntity pAxolotl, int pMaxYRotFromCenter) {
            super((Mob)pAxolotl, pMaxYRotFromCenter);
        }

        public void m_8128_() {
            super.m_8128_();
        }
    }

    static class WalkerMoveControl
    extends SmoothSwimmingMoveControl {
        private final WalkerEntity axolotl;

        public WalkerMoveControl(WalkerEntity pAxolotl) {
            super((Mob)pAxolotl, 15, 10, 0.3f, 0.2f, false);
            this.axolotl = pAxolotl;
        }

        public void m_8126_() {
            super.m_8126_();
        }
    }
}

