/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import dev.dracu.bigmobs.entity.EnormousEggplantEntity;
import dev.dracu.bigmobs.init.EntityInit;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;

public class EggplantAi {
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 4.0f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 2.5f;
    private static final float SPEED_MULTIPLIER_WHEN_FOLLOWING_ADULT = 2.5f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 1.0f;
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.m_146622_((int)5, (int)16);
    private static final ImmutableList<SensorType<? extends Sensor<? super EnormousEggplantEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26814_, (Object)SensorType.f_26822_);
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_217768_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_148196_, (Object)MemoryModuleType.f_148197_, (Object)MemoryModuleType.f_244205_, (Object)MemoryModuleType.f_148198_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26375_, MemoryModuleType.f_26331_});

    public static void initMemories(EnormousEggplantEntity entity, RandomSource pRandom) {
    }

    public static Brain.Provider<EnormousEggplantEntity> brainProvider() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<EnormousEggplantEntity> pBrain) {
        EggplantAi.initCoreActivity(pBrain);
        EggplantAi.initIdleActivity(pBrain);
        pBrain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        pBrain.m_21944_(Activity.f_37979_);
        pBrain.m_21962_();
        return pBrain;
    }

    private static void initCoreActivity(Brain<EnormousEggplantEntity> pBrain) {
        pBrain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)((Object)new CamelPanic(4.0f)), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(MemoryModuleType.f_244205_)));
    }

    private static void initIdleActivity(Brain<EnormousEggplantEntity> pBrain) {
        pBrain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new AnimalMakeLove((EntityType)EntityInit.EnormousEggplant_Entity.get(), 1.0f)), (Object)Pair.of((Object)2, (Object)new FollowTemptation(p_250812_ -> Float.valueOf(2.5f))), (Object)Pair.of((Object)3, (Object)BehaviorBuilder.m_257845_(Predicate.not(EnormousEggplantEntity::refuseToMove), (OneShot)BabyFollowAdult.m_257685_((UniformInt)ADULT_FOLLOW_RANGE, (float)2.5f))), (Object)Pair.of((Object)4, (Object)new RandomLookAround((IntProvider)UniformInt.m_146622_((int)150, (int)250), 30.0f, 0.0f, 0.0f)), (Object)Pair.of((Object)5, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)BehaviorBuilder.m_257845_(Predicate.not(EnormousEggplantEntity::refuseToMove), (OneShot)RandomStroll.m_257965_((float)2.0f)), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.m_257845_(Predicate.not(EnormousEggplantEntity::refuseToMove), (OneShot)SetWalkTargetFromLookTarget.m_257764_((float)2.0f, (int)3)), (Object)1), (Object)Pair.of((Object)((Object)new RandomSitting(20)), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    public static void updateActivity(EnormousEggplantEntity entity) {
        entity.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37979_));
    }

    public static Ingredient getTemptations() {
        return EnormousEggplantEntity.TEMPTATION_ITEM;
    }

    public static class CamelPanic
    extends AnimalPanic {
        public CamelPanic(float p_249921_) {
            super(p_249921_);
        }

        protected void m_6735_(ServerLevel p_249530_, PathfinderMob p_248643_, long p_251124_) {
            if (p_248643_ instanceof EnormousEggplantEntity) {
                EnormousEggplantEntity $$3 = (EnormousEggplantEntity)p_248643_;
                $$3.standUpInstantly();
            }
            super.m_6735_(p_249530_, p_248643_, p_251124_);
        }
    }

    public static class RandomSitting
    extends Behavior<EnormousEggplantEntity> {
        private final int minimalPoseTicks;

        public RandomSitting(int pMinimalPoseSeconds) {
            super((Map)ImmutableMap.of());
            this.minimalPoseTicks = pMinimalPoseSeconds * 20;
        }

        protected boolean checkExtraStartConditions(ServerLevel pLevel, EnormousEggplantEntity pOwner) {
            return !pOwner.m_20069_() && pOwner.getPoseTime() >= (long)this.minimalPoseTicks && !pOwner.m_21523_() && pOwner.m_20096_() && !pOwner.m_217005_();
        }

        protected void start(ServerLevel pLevel, EnormousEggplantEntity pEntity, long pGameTime) {
            if (pEntity.isCamelSitting()) {
                pEntity.standUp();
            } else if (!pEntity.isPanicking()) {
                pEntity.sitDown();
            }
        }
    }
}

