/*
 * Decompiled with CFR 0.152.
 */
package dev.dracu.bigmobs.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import dev.dracu.bigmobs.entity.GoliathEntity;
import dev.dracu.bigmobs.init.EntityInit;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.Croak;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.TryFindLand;
import net.minecraft.world.entity.ai.behavior.TryFindLandNearWater;
import net.minecraft.world.entity.ai.behavior.TryLaySpawnOnWaterNearLand;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.ShootTongue;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class GoliathAi {
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_MAKING_LOVE = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_ON_LAND = 1.0f;
    private static final float SPEED_MULTIPLIER_IN_WATER = 0.75f;
    private static final UniformInt TIME_BETWEEN_LONG_JUMPS = UniformInt.m_146622_((int)100, (int)140);
    private static final int MAX_LONG_JUMP_HEIGHT = 2;
    private static final int MAX_LONG_JUMP_WIDTH = 4;
    private static final float MAX_JUMP_VELOCITY = 1.5f;
    private static final float SPEED_MULTIPLIER_WHEN_TEMPTED = 1.25f;

    public static void initMemories(GoliathEntity pGoliathEntity, RandomSource pRandom) {
        pGoliathEntity.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)TIME_BETWEEN_LONG_JUMPS.m_214085_(pRandom));
    }

    public static Brain<?> makeBrain(Brain<GoliathEntity> pBrain) {
        GoliathAi.initCoreActivity(pBrain);
        GoliathAi.initIdleActivity(pBrain);
        GoliathAi.initSwimActivity(pBrain);
        GoliathAi.initLaySpawnActivity(pBrain);
        GoliathAi.initTongueActivity(pBrain);
        pBrain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        pBrain.m_21944_(Activity.f_37979_);
        pBrain.m_21962_();
        return pBrain;
    }

    private static void initCoreActivity(Brain<GoliathEntity> pBrain) {
        pBrain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148197_), (Object)new CountDownCooldownTicks(MemoryModuleType.f_148199_)));
    }

    private static void initIdleActivity(Brain<GoliathEntity> pBrain) {
        pBrain.m_21903_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)0, (Object)new AnimalMakeLove((EntityType)EntityInit.Goliath_Entity.get(), 1.0f)), (Object)Pair.of((Object)1, (Object)new FollowTemptation(p_218585_ -> Float.valueOf(1.25f))), (Object)Pair.of((Object)2, (Object)StartAttacking.m_257741_(GoliathAi::canAttack, p_218605_ -> p_218605_.m_6274_().m_21952_(MemoryModuleType.f_148194_))), (Object)Pair.of((Object)3, (Object)TryFindLand.m_257647_((int)6, (float)1.0f)), (Object)Pair.of((Object)4, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new Croak(), (Object)3), (Object)Pair.of((Object)BehaviorBuilder.m_257590_(Entity::m_20096_), (Object)2))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148200_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_217766_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initSwimActivity(Brain<GoliathEntity> pBrain) {
        pBrain.m_21903_(Activity.f_219847_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new FollowTemptation(p_218574_ -> Float.valueOf(1.25f))), (Object)Pair.of((Object)2, (Object)StartAttacking.m_257741_(GoliathAi::canAttack, p_218601_ -> p_218601_.m_6274_().m_21952_(MemoryModuleType.f_148194_))), (Object)Pair.of((Object)3, (Object)TryFindLand.m_257647_((int)8, (float)1.5f)), (Object)Pair.of((Object)5, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257751_((float)0.75f), (Object)1), (Object)Pair.of((Object)RandomStroll.m_257798_((float)1.0f, (boolean)true), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.m_257590_(Entity::m_20072_), (Object)5))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148200_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_217766_, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initLaySpawnActivity(Brain<GoliathEntity> pBrain) {
        pBrain.m_21903_(Activity.f_219848_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.m_257472_((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)StartAttacking.m_257741_(GoliathAi::canAttack, p_218597_ -> p_218597_.m_6274_().m_21952_(MemoryModuleType.f_148194_))), (Object)Pair.of((Object)2, (Object)TryFindLandNearWater.m_257557_((int)8, (float)1.0f)), (Object)Pair.of((Object)3, (Object)TryLaySpawnOnWaterNearLand.m_257849_((Block)Blocks.f_220862_)), (Object)Pair.of((Object)4, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)new Croak(), (Object)2), (Object)Pair.of((Object)BehaviorBuilder.m_257590_(Entity::m_20096_), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_148200_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_217767_, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initTongueActivity(Brain<GoliathEntity> pBrain) {
        pBrain.m_21895_(Activity.f_219846_, 0, ImmutableList.of((Object)StopAttackingIfTargetInvalid.m_257822_(), (Object)new ShootTongue(SoundEvents.f_215697_, SoundEvents.f_215692_)), MemoryModuleType.f_26372_);
    }

    private static boolean canAttack(GoliathEntity p_218589_) {
        return !BehaviorUtils.m_217126_((LivingEntity)p_218589_);
    }

    public static void updateActivity(GoliathEntity pGoliathEntity) {
        pGoliathEntity.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_219846_, (Object)Activity.f_219848_, (Object)Activity.f_150239_, (Object)Activity.f_219847_, (Object)Activity.f_37979_));
    }

    public static Ingredient getTemptations() {
        return Frog.f_218455_;
    }
}

