/*
 * Decompiled with CFR 0.152.
 */
package net.cozystudios.cozystudioscore.mixin;

import java.util.ArrayList;
import java.util.List;
import net.cozystudios.cozystudioscore.block.entity.TranquilLanternBlockEntity;
import net.cozystudios.cozystudioscore.config.ModConfig;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1317.class})
public class MobEntityTranquilSpawnMixin {
    @Unique
    private static Integer RADIUS = null;

    @Unique
    private static int getRadius() {
        if (RADIUS == null) {
            RADIUS = ModConfig.get().tranquilLanternRadius;
        }
        return RADIUS;
    }

    @Inject(method={"canSpawn"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onCanSpawn(class_1299<?> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random, CallbackInfoReturnable<Boolean> cir) {
        if (spawnReason != class_3730.field_16459) {
            return;
        }
        class_1311 group = type.method_5891();
        if (group != class_1311.field_6302) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        int radius = MobEntityTranquilSpawnMixin.getRadius();
        int radiusSq = radius * radius;
        for (TranquilLanternBlockEntity be : MobEntityTranquilSpawnMixin.getLanternsNearby(serverWorld, pos, radius)) {
            double distSq = be.method_11016().method_10262((class_2382)pos);
            if (!(distSq <= (double)radiusSq)) continue;
            cir.setReturnValue((Object)false);
            return;
        }
    }

    @Unique
    private static List<TranquilLanternBlockEntity> getLanternsNearby(class_3218 world, class_2338 center, int range) {
        ArrayList<TranquilLanternBlockEntity> lanterns = new ArrayList<TranquilLanternBlockEntity>();
        int chunkRadius = (range >> 4) + 1;
        int chunkX = center.method_10263() >> 4;
        int chunkZ = center.method_10260() >> 4;
        for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
            for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
                class_2818 chunk = world.method_8497(chunkX + dx, chunkZ + dz);
                for (class_2586 be : chunk.method_12214().values()) {
                    if (!(be instanceof TranquilLanternBlockEntity)) continue;
                    TranquilLanternBlockEntity tl = (TranquilLanternBlockEntity)be;
                    lanterns.add(tl);
                }
            }
        }
        return lanterns;
    }
}

