/*
 * Decompiled with CFR 0.152.
 */
package net.cozystudios.cozystudioscore.entity.custom;

import net.cozystudios.cozystudioscore.config.ModConfig;
import net.cozystudios.cozystudioscore.entity.ModEntities;
import net.cozystudios.cozystudioscore.entity.variant.FernlingVariant;
import net.cozystudios.cozystudioscore.item.ModItems;
import net.cozystudios.cozystudioscore.sound.ModSounds;
import net.cozystudios.cozystudioscore.world.gen.ModEntitySpawns;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1924;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class FernlingEntity
extends class_1321 {
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(FernlingEntity.class, (class_2941)class_2943.field_13327);
    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    public final class_7094 sitAnimationState = new class_7094();
    private int bonemealCooldown = 0;

    public FernlingEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(1, (class_1352)new class_1350((class_1321)this, 1.1, 10.0f, 3.0f, false));
        this.field_6201.method_6277(1, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.15));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.25, class_1856.method_8091((class_1935[])new class_1935[]{ModItems.COZY_CRUMBS}), false));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 4.0f){

            public boolean method_6264() {
                return !FernlingEntity.this.method_6172() && super.method_6264();
            }
        });
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.method_6172()) {
            this.sitAnimationState.method_41324(this.field_6012);
        } else {
            this.sitAnimationState.method_41325();
        }
    }

    protected void method_48565(float v) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f, 0.2f);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        }
        if (!this.method_37908().method_8608() && this.method_6181() && !this.method_24345() && this.method_5805()) {
            if (this.bonemealCooldown > 0) {
                --this.bonemealCooldown;
            } else {
                ModConfig cfg = ModConfig.get();
                if (this.method_6051().method_43057() < (float)cfg.fernlingBonemealChance) {
                    boolean didBonemeal = this.tryBonemealNearby(cfg.fernlingBonemealRadius);
                    this.bonemealCooldown = cfg.fernlingBonemealCooldownMin + this.field_5974.method_43048(cfg.fernlingBonemealCooldownMax - cfg.fernlingBonemealCooldownMin + 1);
                    if (didBonemeal) {
                        this.bonemealCooldown += 40;
                    }
                } else {
                    this.bonemealCooldown = 40;
                }
            }
        }
    }

    private boolean tryBonemealNearby(int radius) {
        class_1937 class_19372 = this.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 world = (class_3218)class_19372;
        class_2338 base = this.method_24515();
        for (int tries = 0; tries < 10; ++tries) {
            class_2256 fertilizable;
            class_2338 pos = base.method_10069(this.field_5974.method_39332(-radius, radius), this.field_5974.method_39332(-1, 1), this.field_5974.method_39332(-radius, radius));
            class_2680 state = world.method_8320(pos);
            class_2248 class_22482 = state.method_26204();
            if (!(class_22482 instanceof class_2256) || !(fertilizable = (class_2256)class_22482).method_9651((class_4538)world, pos, state, false) || !fertilizable.method_9650((class_1937)world, world.field_9229, pos, state)) continue;
            fertilizable.method_9652(world, world.field_9229, pos, state);
            world.method_20290(1505, pos, 0);
            world.method_8396(null, pos, class_3417.field_33433, this.method_5634(), 0.7f, 1.0f);
            return true;
        }
        return false;
    }

    public static class_5132.class_5133 createFernlingAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 12.0).method_26868(class_5134.field_23719, 0.25);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        FernlingEntity baby = (FernlingEntity)ModEntities.FERNLING.method_5883((class_1937)world);
        if (baby != null) {
            if (entity instanceof FernlingEntity) {
                FernlingEntity other = (FernlingEntity)entity;
                if (this.getVariant() == other.getVariant()) {
                    baby.setVariant(this.getVariant());
                } else {
                    baby.setVariant((FernlingVariant)((Object)class_156.method_27173((Object[])FernlingVariant.values(), (class_5819)this.field_5974)));
                }
            } else {
                baby.setVariant(this.getVariant());
            }
        }
        return baby;
    }

    @Nullable
    protected class_3414 method_5994() {
        return ModSounds.FERNLING_IDLE;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_18061;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_18059;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1792 itemForTaming;
        class_1799 itemstack = player.method_5998(hand);
        class_1792 item = itemstack.method_7909();
        if (item == (itemForTaming = ModItems.COZY_CRUMBS) && !this.method_6181()) {
            if (this.method_37908().method_8608()) {
                return class_1269.field_21466;
            }
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            if (!this.method_37908().method_8608()) {
                super.method_6170(player);
                this.field_6189.method_6356();
                this.method_5980(null);
                this.method_37908().method_8421((class_1297)this, (byte)7);
                this.method_24346(true);
                this.method_6179(true);
            }
            return class_1269.field_5812;
        }
        if (this.method_6181() && item == itemForTaming && this.method_6032() < this.method_6063()) {
            if (!player.method_31549().field_7477) {
                itemstack.method_7934(1);
            }
            this.method_6025(2.0f);
            return class_1269.field_5812;
        }
        if (this.method_6181() && this.method_6171((class_1309)player) && hand == class_1268.field_5808 && item != itemForTaming && !this.method_6481(itemstack)) {
            boolean sitting = !this.method_24345();
            this.method_24346(sitting);
            this.method_6179(sitting);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(ModItems.COZY_CRUMBS);
    }

    public FernlingVariant getVariant() {
        return FernlingVariant.byId((Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT) & 0xFF);
    }

    public void setVariant(FernlingVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", ((Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT)).intValue());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(FernlingVariant.byId(nbt.method_10550("Variant")));
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.setVariant(ModEntitySpawns.pickFernlingVariantForBiome(world, this.method_24515()).orElse((FernlingVariant)((Object)class_156.method_27173((Object[])FernlingVariant.values(), (class_5819)this.field_5974))));
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }
}

